/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.sling.api.adapter.Adaptable;

public class AdaptToIterator<F, T>
implements Iterator<T> {
    private final Iterator<F> iterator;
    private final Class<? extends T> clazz;
    private T currentModel;

    public AdaptToIterator(Iterator<F> iterator, Class<? extends T> clazz) {
        this.clazz = clazz;
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        if (this.currentModel == null) {
            this.getCurrentModel();
        }
        return this.currentModel != null;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T model = this.currentModel;
        this.currentModel = null;
        return model;
    }

    public void getCurrentModel() {
        while (this.iterator.hasNext()) {
            F element = this.iterator.next();
            if (element instanceof Adaptable) {
                this.currentModel = ((Adaptable)element).adaptTo(this.clazz);
            }
            if (this.currentModel == null) continue;
            break;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

