/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.function;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.sling.query.api.SearchStrategy;
import org.apache.sling.query.api.internal.ElementToIteratorFunction;
import org.apache.sling.query.api.internal.TreeProvider;
import org.apache.sling.query.iterator.WarningIterator;
import org.apache.sling.query.iterator.tree.BfsTreeIterator;
import org.apache.sling.query.iterator.tree.DfsTreeIterator;
import org.apache.sling.query.selector.parser.Selector;
import org.apache.sling.query.selector.parser.SelectorParser;
import org.apache.sling.query.selector.parser.SelectorSegment;

public class FindFunction<T>
implements ElementToIteratorFunction<T> {
    private final List<SelectorSegment> preFilteringSelector;
    private final TreeProvider<T> provider;
    private final SearchStrategy strategy;

    public FindFunction(SearchStrategy searchStrategy, TreeProvider<T> provider, SelectorSegment preFilteringSelector) {
        this.strategy = searchStrategy;
        this.provider = provider;
        this.preFilteringSelector = Arrays.asList(preFilteringSelector);
    }

    public FindFunction(SearchStrategy searchStrategy, TreeProvider<T> provider, String preFilteringSelector) {
        this.strategy = searchStrategy;
        this.provider = provider;
        List<Selector> selectors = SelectorParser.parse(preFilteringSelector);
        this.preFilteringSelector = SelectorParser.getFirstSegmentFromEachSelector(selectors);
    }

    @Override
    public Iterator<T> apply(T input) {
        Iterator<T> iterator;
        switch (this.strategy) {
            case BFS: {
                iterator = new BfsTreeIterator<T>(input, this.provider);
                break;
            }
            case QUERY: {
                iterator = this.provider.query(this.preFilteringSelector, input);
                break;
            }
            default: {
                iterator = new DfsTreeIterator<T>(input, this.provider);
            }
        }
        return new WarningIterator<T>(iterator);
    }
}

