/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.sling.pipes.PipeBindings;
import org.jetbrains.annotations.NotNull;

public class CommandUtil {
    static final String PAIR_SEP = ",";
    static final String KEY_VALUE_SEP = "=";
    static final String FIRST_KEY = "first";
    static final String SECOND_KEY = "second";
    static final String PN_JCR_MIXIN = "jcr:mixinTypes";
    static final String QUOTE = "\"";
    static final Pattern MIXINS_ARRAY_PATTERN = Pattern.compile("^\\s*\\[(.*)\\]\\s*$");
    private static final Pattern UNEMBEDDEDSCRIPT_PATTERN = Pattern.compile("^(\\d+(\\.\\d+)?)|\\[.*]$|[\\w_\\-]+\\..+|[\\w_\\-]+\\['.+']|true$|false$|new .*|(.*'$)");
    static final String EXPR_TOKEN = "([^=]+|\\$\\{(([^\\{^\\}]+(\\{[0-9,]+\\})?)+)\\})+";
    static final String CONFIGURATION_TOKEN = "\\s*(?<first>([^=]+|\\$\\{(([^\\{^\\}]+(\\{[0-9,]+\\})?)+)\\})+)\\s*=\\s*(?<second>(([^=]+|\\$\\{(([^\\{^\\}]+(\\{[0-9,]+\\})?)+)\\})+)+)\\s*";
    public static final Pattern CONFIGURATION_PATTERN = Pattern.compile("\\s*(?<first>([^=]+|\\$\\{(([^\\{^\\}]+(\\{[0-9,]+\\})?)+)\\})+)\\s*=\\s*(?<second>(([^=]+|\\$\\{(([^\\{^\\}]+(\\{[0-9,]+\\})?)+)\\})+)+)\\s*");

    private CommandUtil() {
    }

    public static void checkArguments(Object ... params) {
        if (params.length % 2 > 0) {
            throw new IllegalArgumentException("there should be an even number of arguments");
        }
    }

    static Object embedIfNeeded(Object value) {
        Matcher matcher;
        if (value instanceof String && (matcher = UNEMBEDDEDSCRIPT_PATTERN.matcher(value.toString())).matches()) {
            return PipeBindings.embedAsScript(value.toString());
        }
        return value;
    }

    public static void writeToMap(Map<String, Object> map, boolean embed, Object ... params) {
        for (int i = 0; i < params.length - 1; i += 2) {
            map.put(params[i].toString(), embed ? CommandUtil.embedIfNeeded(params[i + 1]) : params[i + 1]);
            if (!params[i].toString().equals(PN_JCR_MIXIN)) continue;
            map.put(PN_JCR_MIXIN, CommandUtil.handleMixins((String)params[i + 1]));
        }
    }

    static String[] handleMixins(String value) {
        Matcher matcher = MIXINS_ARRAY_PATTERN.matcher(value);
        if (matcher.matches()) {
            return Arrays.stream(matcher.group(1).split(PAIR_SEP)).map(String::trim).collect(Collectors.toList()).toArray(new String[0]);
        }
        return new String[]{value};
    }

    public static Map<String, Object> stringToMap(@NotNull String input, UnaryOperator<String> valueTransformer) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String pair : input.split(PAIR_SEP)) {
            Matcher matcher = CONFIGURATION_PATTERN.matcher(pair);
            if (!matcher.find()) continue;
            map.put(matcher.group(FIRST_KEY), valueTransformer.apply(matcher.group(SECOND_KEY)));
        }
        return map;
    }

    public static String trimQuotes(@NotNull String quotedString) {
        if (quotedString.startsWith(QUOTE) && quotedString.endsWith(QUOTE)) {
            return quotedString.substring(1, quotedString.length() - 1);
        }
        return quotedString;
    }

    public static String[] keyValuesToArray(List<String> o) {
        ArrayList<String> args = new ArrayList<String>();
        if (o != null) {
            for (String pair : o) {
                Matcher matcher = CONFIGURATION_PATTERN.matcher(pair.trim());
                if (!matcher.matches()) continue;
                args.add(CommandUtil.trimQuotes(matcher.group(FIRST_KEY)));
                args.add(CommandUtil.trimQuotes(matcher.group(SECOND_KEY)));
            }
        }
        return args.toArray(new String[args.size()]);
    }
}

