/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.json.JsonValue;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.AbstractResourceVisitor;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.caconfig.spi.ConfigurationMetadataProvider;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.DistributionResponse;
import org.apache.sling.distribution.Distributor;
import org.apache.sling.distribution.SimpleDistributionRequest;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.consumer.JobConsumer;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.ExecutionResult;
import org.apache.sling.pipes.OutputWriter;
import org.apache.sling.pipes.Pipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.PipeBuilder;
import org.apache.sling.pipes.PipeExecutor;
import org.apache.sling.pipes.Plumber;
import org.apache.sling.pipes.PlumberMXBean;
import org.apache.sling.pipes.internal.ContainerPipe;
import org.apache.sling.pipes.internal.JsonUtil;
import org.apache.sling.pipes.internal.JsonWriter;
import org.apache.sling.pipes.internal.ManifoldPipe;
import org.apache.sling.pipes.internal.PipeBuilderImpl;
import org.apache.sling.pipes.internal.PipeMonitor;
import org.apache.sling.pipes.internal.bindings.ConfigurationMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Plumber.class, JobConsumer.class, PlumberMXBean.class, Runnable.class}, property={"job.topics=org/apache/sling/pipes/topic"})
@Designate(ocd=Configuration.class)
public class PlumberImpl
implements Plumber,
JobConsumer,
PlumberMXBean,
Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final int DEFAULT_BUFFER_SIZE = 1000;
    static final String PN_MONITORED = "monitored";
    static final String MONITORED_PIPES_QUERY = String.format("//element(*,nt:base)[@sling:resourceType='%s' and @%s]", "slingPipes/container", "monitored");
    static final String MBEAN_NAME_FORMAT = "org.apache.sling.pipes:name=%s";
    static final String PARAM_BINDINGS = "bindings";
    static final String PARAM_FILE = "pipes_inputFile";
    static final String PERMISSION_EXECUTION = "/system/sling/permissions/pipes/exec";
    static final String JCR_LAST_MODIFIED_BY = "jcr:lastModifiedBy";
    static final String JCR_LAST_MODIFIED_BY_PIPE = "jcr:lastModifiedByPipe";
    public static final String PIPES_REPOSITORY_PATH = "/var/pipes";
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    volatile Distributor distributor = null;
    @Reference
    JobManager jobManager;
    @Reference
    ResourceResolverFactory factory;
    @Reference
    ConfigurationMetadataProvider configMetadataProvider;
    Map<String, Class<? extends BasePipe>> registry;
    public static final String SLING_EVENT_TOPIC = "org/apache/sling/pipes/topic";
    private Configuration configuration;
    private Map<String, Object> serviceUser;
    private List<String> allowedUsers;
    private Map<String, PipeMonitor> monitoredPipes;
    public static final String PN_NBOUTPUTRESOURCES = "nbOutputResources";

    @Activate
    public void activate(Configuration configuration) {
        this.configuration = configuration;
        this.serviceUser = configuration.serviceUser() != null ? Collections.singletonMap("sling.service.subservice", configuration.serviceUser()) : null;
        this.allowedUsers = Arrays.asList(configuration.authorizedUsers());
        this.registry = new HashMap<String, Class<? extends BasePipe>>();
        this.registerPipes();
        this.toggleJmxRegistration(this, PlumberMXBean.class.getName(), true);
        this.refreshMonitoredPipes();
    }

    void registerPipes() {
        this.registerPipe("slingPipes/container", ContainerPipe.class);
        this.registerPipe("slingPipes/manifold", ManifoldPipe.class);
        for (Method method : PipeBuilder.class.getDeclaredMethods()) {
            PipeExecutor executor = method.getAnnotation(PipeExecutor.class);
            if (executor == null) continue;
            this.registerPipe(executor.resourceType(), executor.pipeClass());
        }
    }

    void checkPermissions(ResourceResolver context, String ... permissions) {
        for (String permission : permissions) {
            if (context.getResource(permission) != null) continue;
            this.log.debug("error trying to check permission {}", (Object)permission);
            throw new AccessControlException("User has not the required permissions");
        }
    }

    public Map getServiceUser() {
        return this.serviceUser;
    }

    @Override
    public Map getContextAwareConfigurationMap(Resource currentResource) {
        return new ConfigurationMap(currentResource, this.configMetadataProvider);
    }

    @Override
    @Nullable
    public Resource getReferencedResource(Resource referrer, String reference) {
        ResourceResolver resolver = referrer.getResourceResolver();
        for (String path : this.configuration.referencesPaths()) {
            Resource target = resolver.getResource(path + "/" + reference);
            if (target == null) continue;
            return target;
        }
        return null;
    }

    @Deactivate
    public void deactivate() {
        this.toggleJmxRegistration(null, PlumberMXBean.class.getName(), false);
        if (this.monitoredPipes != null) {
            for (String path : this.monitoredPipes.keySet()) {
                this.toggleJmxRegistration(null, path, false);
            }
        }
    }

    private void toggleJmxRegistration(Object instance, String name, boolean register) {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName oName = ObjectName.getInstance(String.format(MBEAN_NAME_FORMAT, name));
            if (register && !server.isRegistered(oName)) {
                server.registerMBean(instance, oName);
            }
            if (!register && server.isRegistered(oName)) {
                server.unregisterMBean(oName);
            }
        }
        catch (Exception e) {
            this.log.error("unable to toggle mbean {} registration", (Object)name, (Object)e);
        }
    }

    @Override
    public Pipe getPipe(Resource resource) {
        return this.getPipe(resource, null);
    }

    @Override
    public Pipe getPipe(Resource resource, PipeBindings upperBindings) {
        if (resource == null || !this.registry.containsKey(resource.getResourceType())) {
            this.log.error("Pipe configuration resource is either null, or its type is not registered");
        } else {
            try {
                Class<? extends BasePipe> pipeClass = this.registry.get(resource.getResourceType());
                return pipeClass.getDeclaredConstructor(Plumber.class, Resource.class, PipeBindings.class).newInstance(this, resource, upperBindings);
            }
            catch (Exception e) {
                this.log.error("Unable to properly instantiate the pipe configured in {}", (Object)resource.getPath(), (Object)e);
            }
        }
        return null;
    }

    @Override
    public void markWithJcrLastModified(@NotNull Pipe pipe, @NotNull Resource resource) {
        ModifiableValueMap mvm;
        if (!pipe.isDryRun() && (mvm = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class)) != null) {
            mvm.put((Object)"jcr:lastModified", (Object)Calendar.getInstance());
            mvm.put((Object)JCR_LAST_MODIFIED_BY, (Object)resource.getResourceResolver().getUserID());
            if (this.configuration.mark_pipe_path()) {
                mvm.put((Object)JCR_LAST_MODIFIED_BY_PIPE, (Object)pipe.getResource().getPath());
            }
        }
    }

    @Override
    public Map<String, Object> getBindingsFromRequest(SlingHttpServletRequest request, boolean writeAllowed) throws IOException {
        RequestParameter fileParameter;
        String paramBindings;
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        String dryRun = request.getParameter("dryRun");
        if (StringUtils.isNotBlank((CharSequence)dryRun) && !dryRun.equals(Boolean.FALSE.toString())) {
            bindings.put("dryRun", true);
        }
        if (StringUtils.isNotBlank((CharSequence)(paramBindings = request.getParameter(PARAM_BINDINGS)))) {
            try {
                bindings.putAll((Map)JsonUtil.unbox((JsonValue)JsonUtil.parseObject(paramBindings)));
            }
            catch (Exception e) {
                this.log.error("Unable to retrieve bindings information", (Throwable)e);
            }
        }
        if ((fileParameter = request.getRequestParameter(PARAM_FILE)) != null) {
            bindings.put("org.apache.sling.pipes.RequestInputStream", fileParameter.getInputStream());
        }
        bindings.put("readOnly", !writeAllowed);
        return bindings;
    }

    @Override
    public Job executeAsync(ResourceResolver resolver, String path, Map<String, Object> bindings) {
        if (this.allowedUsers.contains(resolver.getUserID())) {
            return this.executeAsync(path, bindings);
        }
        return null;
    }

    @Override
    public Job executeAsync(String path, Map<String, Object> bindings) {
        if (StringUtils.isBlank((CharSequence)((String)this.serviceUser.get("sling.service.subservice")))) {
            this.log.error("please configure plumber service user");
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("path", path);
        props.put("additionalBindings", bindings);
        return this.jobManager.addJob(SLING_EVENT_TOPIC, props);
    }

    public ExecutionResult execute(ResourceResolver resolver, String path, Map additionalBindings, OutputWriter writer, boolean save) {
        Resource pipeResource = resolver.getResource(path);
        Pipe pipe = this.getPipe(pipeResource);
        if (pipe == null) {
            throw new IllegalArgumentException("unable to build pipe based on configuration at " + path);
        }
        return this.execute(resolver, pipe, additionalBindings, writer, save);
    }

    private ExecutionResult internalExecute(ResourceResolver resolver, OutputWriter writer, Pipe pipe) throws InterruptedException, PersistenceException {
        ExecutionResult result = new ExecutionResult(writer);
        Iterator<Resource> it = pipe.getOutput();
        while (it.hasNext()) {
            Resource resource = it.next();
            this.checkError(pipe, result);
            if (resource == null) continue;
            this.log.debug("[{}] retrieved {}", (Object)pipe.getName(), (Object)resource.getPath());
            result.addResultItem(resource);
            this.persist(resolver, pipe, result, resource);
        }
        this.checkError(pipe, result);
        return result;
    }

    /*
     * Exception decompiling
     */
    public ExecutionResult execute(ResourceResolver resolver, Pipe pipe, Map additionalBindings, OutputWriter writer, boolean save) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void checkError(Pipe pipe, ExecutionResult result) {
        String error = pipe.getBindings().popCurrentError();
        if (StringUtils.isNotBlank((CharSequence)error)) {
            result.addError(error);
        }
    }

    private boolean shouldSave(ResourceResolver resolver, Pipe pipe, ExecutionResult result, Resource currentResource) {
        return pipe.modifiesContent() && resolver.hasChanges() && !pipe.isDryRun() && (currentResource == null || result.size() % (long)this.configuration.bufferSize() == 0L);
    }

    void persist(ResourceResolver resolver, Pipe pipe, ExecutionResult result, Resource currentResource) throws PersistenceException, InterruptedException {
        if (this.shouldSave(resolver, pipe, result, currentResource)) {
            this.log.info("[{}] saving changes...", (Object)pipe.getName());
            this.writeStatus(pipe, currentResource == null ? "finished" : currentResource.getPath(), result);
            resolver.commit();
            if (currentResource == null && this.distributor != null && StringUtils.isNotBlank((CharSequence)pipe.getDistributionAgent())) {
                this.log.info("a distribution agent is configured, will try to distribute the changes");
                SimpleDistributionRequest request = new SimpleDistributionRequest(DistributionRequestType.ADD, true, result.getCurrentPathSet().toArray(new String[result.getCurrentPathSet().size()]));
                DistributionResponse response = this.distributor.distribute(pipe.getDistributionAgent(), resolver, (DistributionRequest)request);
                this.log.info("distribution response : {}", (Object)response);
            }
            if (result.size() > (long)this.configuration.bufferSize()) {
                result.emptyCurrentSet();
            }
            if (this.configuration.sleep() > 0L) {
                this.log.debug("sleeping for {}ms", (Object)this.configuration.sleep());
                Thread.sleep(this.configuration.sleep());
            }
        }
    }

    @Override
    public void registerPipe(String type, Class<? extends BasePipe> pipeClass) {
        this.registry.put(type, pipeClass);
    }

    @Override
    public boolean isTypeRegistered(String type) {
        return this.registry.containsKey(type);
    }

    void writeStatus(Pipe pipe, String status, ExecutionResult result) {
        ModifiableValueMap vm;
        if (StringUtils.isNotBlank((CharSequence)status) && (vm = (ModifiableValueMap)pipe.getResource().adaptTo(ModifiableValueMap.class)) != null) {
            vm.put((Object)"status", (Object)status);
            vm.put((Object)PN_NBOUTPUTRESOURCES, (Object)(result != null ? result.size() : -1L));
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(new Date());
            vm.put((Object)"statusModified", (Object)cal);
        }
    }

    @Override
    public String getStatus(Resource pipeResource) {
        String status;
        Resource statusResource = pipeResource.getChild("status");
        if (statusResource != null && StringUtils.isNotBlank((CharSequence)(status = (String)statusResource.adaptTo(String.class)))) {
            return status;
        }
        return "finished";
    }

    @Override
    public PipeBuilder newPipe(ResourceResolver resolver) {
        return new PipeBuilderImpl(resolver, this);
    }

    @Override
    public boolean isRunning(Resource pipeResource) {
        return !this.getStatus(pipeResource).equals("finished");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JobConsumer.JobResult process(Job job) {
        try (ResourceResolver resolver = this.factory.getServiceResourceResolver(this.serviceUser);){
            String path = (String)job.getProperty("path");
            Map bindings = (Map)job.getProperty("additionalBindings");
            JsonWriter writer = new JsonWriter();
            ((OutputWriter)writer).starts();
            this.execute(resolver, path, bindings, (OutputWriter)writer, true);
            JobConsumer.JobResult jobResult = JobConsumer.JobResult.OK;
            return jobResult;
        }
        catch (LoginException e) {
            this.log.error("unable to retrieve resolver for executing scheduled pipe", (Throwable)e);
            return JobConsumer.JobResult.FAILED;
        }
        catch (Exception e) {
            this.log.error("failed to execute the pipe", (Throwable)e);
        }
        return JobConsumer.JobResult.FAILED;
    }

    @Override
    public void refreshMonitoredPipes() {
        HashMap<String, PipeMonitor> map = new HashMap<String, PipeMonitor>();
        this.getMonitoredPipes().stream().forEach(bean -> map.put(bean.getPath(), (PipeMonitor)bean));
        if (this.monitoredPipes != null) {
            Collection shouldBeRemoved = CollectionUtils.subtract(this.monitoredPipes.keySet(), map.keySet());
            for (String path : shouldBeRemoved) {
                this.toggleJmxRegistration(null, path, false);
            }
        }
        this.monitoredPipes = map;
        for (Map.Entry<String, PipeMonitor> entry : this.monitoredPipes.entrySet()) {
            this.toggleJmxRegistration(entry.getValue(), entry.getKey(), true);
        }
    }

    Collection<PipeMonitor> getMonitoredPipes() {
        ArrayList<PipeMonitor> beans = new ArrayList<PipeMonitor>();
        if (this.serviceUser != null) {
            try (ResourceResolver resolver = this.factory.getServiceResourceResolver(this.serviceUser);){
                Iterator resourceIterator = resolver.findResources(MONITORED_PIPES_QUERY, "xpath");
                while (resourceIterator.hasNext()) {
                    beans.add(new PipeMonitor(this, this.getPipe((Resource)resourceIterator.next())));
                }
            }
            catch (LoginException e) {
                this.log.error("unable to retrieve resolver for collecting exposed pipes", (Throwable)e);
            }
            catch (Exception e) {
                this.log.error("failed to execute the pipe", (Throwable)e);
            }
        } else {
            this.log.warn("no service user configured, pipes can't be monitored");
        }
        return beans;
    }

    @Override
    public String generateUniquePath() {
        Calendar now = Calendar.getInstance();
        return "/var/pipes/" + now.get(1) + '/' + now.get(2) + '/' + now.get(5) + "/" + UUID.randomUUID().toString();
    }

    void cleanResourceAndEmptyParents(Resource resource) throws PersistenceException {
        this.log.debug("starting removal of {}", (Object)resource);
        Resource parent = resource.getParent();
        resource.getResourceResolver().delete(resource);
        if (parent != null && !parent.hasChildren() && !PIPES_REPOSITORY_PATH.equals(parent.getPath())) {
            this.cleanResourceAndEmptyParents(parent);
        }
    }

    void purge(ResourceResolver resolver, final Instant now, final int maxDays) throws PersistenceException {
        final ArrayList pipesToRemove = new ArrayList();
        AbstractResourceVisitor visitor = new AbstractResourceVisitor(){

            protected void visit(Resource res) {
                Calendar cal = (Calendar)res.getValueMap().get("statusModified", Calendar.class);
                if (cal != null && ChronoUnit.DAYS.between(cal.toInstant(), now) > (long)maxDays) {
                    pipesToRemove.add(res.getPath());
                }
            }
        };
        visitor.accept(resolver.getResource(PIPES_REPOSITORY_PATH));
        if (!pipesToRemove.isEmpty()) {
            this.log.info("about to remove {} pipe instances", (Object)pipesToRemove.size());
            for (String path : pipesToRemove) {
                this.cleanResourceAndEmptyParents(resolver.getResource(path));
            }
            resolver.commit();
            this.log.info("purge done.");
        }
    }

    @Override
    public void run() {
        if (this.serviceUser == null) {
            this.log.warn("no service user configured, will not be able to purge old pipe instances");
        } else {
            try (ResourceResolver resolver = this.factory.getServiceResourceResolver(this.serviceUser);){
                this.log.info("Starting pipe purge based on a max age of {} days", (Object)this.configuration.maxAge());
                this.purge(resolver, Instant.now(), this.configuration.maxAge());
                resolver.commit();
            }
            catch (LoginException | PersistenceException e) {
                this.log.error("unable purge {}", (Object)PIPES_REPOSITORY_PATH, (Object)e);
            }
        }
    }

    @ObjectClassDefinition(name="Apache Sling Pipes : Plumber configuration")
    public static @interface Configuration {
        @AttributeDefinition(description="Number of iterations after which plumber should saves a pipe execution")
        public int bufferSize() default 1000;

        @AttributeDefinition(description="Number of milliseconds of sleep after each persistence")
        public long sleep() default 0L;

        @AttributeDefinition(description="Name of service user, with appropriate rights, that will be used for async execution")
        public String serviceUser();

        @AttributeDefinition(description="Path of the permission resource for executing pipes")
        public String executionPermissionResource() default "/system/sling/permissions/pipes/exec";

        @AttributeDefinition(description="Users allowed to register async pipes")
        public String[] authorizedUsers() default {"admin"};

        @AttributeDefinition(description="Paths to search for references in")
        public String[] referencesPaths() default {};

        @AttributeDefinition(description="max age (in days) of automatically generated pipe persistence")
        public int maxAge() default 31;

        @AttributeDefinition(description="should add pipe path to updated properties")
        public boolean mark_pipe_path() default false;

        @AttributeDefinition(description="schedule of purge process")
        public String scheduler_expression() default "0 0 12 */7 * ?";
    }
}

