/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInputStreamPipe
extends BasePipe {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractInputStreamPipe.class);
    public static final String REMOTE_START = "http";
    protected static final Pattern VALID_PATH = Pattern.compile("/([\\w\\.\\-_]+/)+[\\w\\.\\-_]+");
    public static final String BINDING_IS = "org.apache.sling.pipes.RequestInputStream";
    private static final String BASIC_AUTH_BINDINGS = "basicAuth";
    private static final String AUTH_HEADER = "Authentication";
    private static final String BASIC_PREFIX = "Basic ";
    private static final String PN_URL_MODE = "url_mode";
    private static final String URL_MODE_FETCH = "FETCH";
    private static final String URL_MODE_AS_IS = "AS_IS";
    protected Object binding = null;
    InputStream is;

    public AbstractInputStreamPipe(Plumber plumber, Resource resource, PipeBindings upperBindings) {
        super(plumber, resource, upperBindings);
    }

    InputStream getInputStreamFromResource(String expr) {
        Resource resource = this.resolver.getResource(expr);
        if (resource != null) {
            return (InputStream)resource.adaptTo(InputStream.class);
        }
        return null;
    }

    InputStream getInputStream() throws IOException {
        InputStream resourceIs;
        String urlExpression;
        String expr = this.getExpr();
        if (expr.startsWith(REMOTE_START) && !((String)this.properties.get(PN_URL_MODE, (Object)URL_MODE_FETCH)).equalsIgnoreCase(URL_MODE_AS_IS) && StringUtils.isNotBlank((CharSequence)(urlExpression = this.getExpr()))) {
            URL url = new URL(urlExpression);
            URLConnection urlConnection = url.openConnection();
            String basicAuth = (String)this.getBindings().getBindings().get(BASIC_AUTH_BINDINGS);
            if (StringUtils.isNotBlank((CharSequence)basicAuth)) {
                LOGGER.debug("Configuring basic authentication for {}", (Object)urlConnection);
                HttpURLConnection connection = (HttpURLConnection)urlConnection;
                String encoded = Base64.getEncoder().encodeToString(basicAuth.getBytes(StandardCharsets.UTF_8));
                connection.setRequestProperty(AUTH_HEADER, BASIC_PREFIX + encoded);
            }
            LOGGER.debug("Executing GET {}", (Object)url);
            return urlConnection.getInputStream();
        }
        if (VALID_PATH.matcher(expr).find() && (resourceIs = this.getInputStreamFromResource(expr)) != null) {
            return resourceIs;
        }
        if (this.getBindings().getBindings().get(BINDING_IS) != null) {
            return (InputStream)this.getBindings().getBindings().get(BINDING_IS);
        }
        return new ByteArrayInputStream(expr.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public Object getOutputBinding() {
        return this.binding;
    }

    public abstract Iterator<Resource> getOutput(InputStream var1);

    @Override
    public Iterator<Resource> computeOutput() {
        try {
            this.is = this.getInputStream();
            Iterator<Resource> iterator = this.getOutput(this.is);
            return iterator;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.is);
        }
    }
}

