/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.model;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.factory.ModelClassException;
import org.apache.sling.models.impl.ReflectionUtil;
import org.apache.sling.models.impl.Result;
import org.apache.sling.models.impl.model.AbstractInjectableElement;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;

public class InjectableField
extends AbstractInjectableElement {
    private final Field field;

    public InjectableField(Field field, StaticInjectAnnotationProcessorFactory[] processorFactories, DefaultInjectionStrategy defaultInjectionStrategy) {
        super(field, ReflectionUtil.mapPrimitiveClasses(field.getGenericType()), field.getName(), processorFactories, defaultInjectionStrategy);
        this.field = field;
    }

    public RuntimeException set(Object createdObject, Result<Object> result) {
        try {
            this.field.setAccessible(true);
            this.field.set(createdObject, result.getValue());
        }
        catch (Exception e) {
            return new ModelClassException("Could not inject field " + this.field + " due to reflection issues", (Throwable)e);
        }
        return null;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    public Class<?> getFieldType() {
        return this.field.getType();
    }

    public Type getFieldGenericType() {
        return this.field.getGenericType();
    }
}

