/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.impl.model.AbstractInjectableElement;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;

public class ConstructorParameter
extends AbstractInjectableElement {
    private final Type parameterType;
    private final Type genericType;
    private final boolean isPrimitive;
    private final int parameterIndex;

    public ConstructorParameter(Annotation[] annotations, Type parameterType, Type genericType, boolean isPrimitive, int parameterIndex, StaticInjectAnnotationProcessorFactory[] processorFactories, DefaultInjectionStrategy defaultInjectionStrategy) {
        super(new FakeAnnotatedElement(annotations, parameterIndex), genericType, null, processorFactories, defaultInjectionStrategy);
        this.parameterType = parameterType;
        this.genericType = genericType;
        this.isPrimitive = isPrimitive;
        this.parameterIndex = parameterIndex;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public Type getParameterType() {
        return this.parameterType;
    }

    @Override
    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public String toString() {
        return "Parameter" + this.parameterIndex + "[" + this.genericType.toString() + "]";
    }

    public static class FakeAnnotatedElement
    implements AnnotatedElement {
        private final Annotation[] annotations;
        private final int parameterIndex;

        public FakeAnnotatedElement(Annotation[] annotations, int parameterIndex) {
            this.annotations = annotations;
            this.parameterIndex = parameterIndex;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> paramClass) {
            return this.getAnnotation(paramClass) != null;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> paramClass) {
            for (Annotation annotation : this.annotations) {
                if (!paramClass.isInstance(annotation)) continue;
                return (T)annotation;
            }
            return null;
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.annotations;
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.annotations;
        }

        public int getParameterIndex() {
            return this.parameterIndex;
        }

        public String toString() {
            return "FakeAnnotatedElement [annotations=" + Arrays.toString(this.annotations) + ", parameterIndex=" + this.parameterIndex + "]";
        }
    }
}

