/*
 * Decompiled with CFR 0.152.
 */
package slingmodelsimpl.org.apache.sling.commons.osgi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class PropertiesUtil {
    public static boolean toBoolean(Object propValue, boolean defaultValue) {
        if ((propValue = PropertiesUtil.toObject(propValue)) instanceof Boolean) {
            return (Boolean)propValue;
        }
        if (propValue != null) {
            return Boolean.parseBoolean(String.valueOf(propValue));
        }
        return defaultValue;
    }

    public static String toString(Object propValue, String defaultValue) {
        return (propValue = PropertiesUtil.toObject(propValue)) != null ? propValue.toString() : defaultValue;
    }

    public static long toLong(Object propValue, long defaultValue) {
        if ((propValue = PropertiesUtil.toObject(propValue)) instanceof Long) {
            return (Long)propValue;
        }
        if (propValue != null) {
            try {
                return Long.parseLong(String.valueOf(propValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int toInteger(Object propValue, int defaultValue) {
        if ((propValue = PropertiesUtil.toObject(propValue)) instanceof Integer) {
            return (Integer)propValue;
        }
        if (propValue != null) {
            try {
                return Integer.parseInt(String.valueOf(propValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static double toDouble(Object propValue, double defaultValue) {
        if ((propValue = PropertiesUtil.toObject(propValue)) instanceof Double) {
            return (Double)propValue;
        }
        if (propValue != null) {
            try {
                return Double.parseDouble(String.valueOf(propValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Object toObject(Object propValue) {
        if (propValue == null) {
            return null;
        }
        if (propValue.getClass().isArray()) {
            Object[] prop = (Object[])propValue;
            return prop.length > 0 ? prop[0] : null;
        }
        if (propValue instanceof Collection) {
            Collection prop = (Collection)propValue;
            return prop.isEmpty() ? null : prop.iterator().next();
        }
        return propValue;
    }

    public static String[] toStringArray(Object propValue) {
        return PropertiesUtil.toStringArray(propValue, null);
    }

    public static String[] toStringArray(Object propValue, String[] defaultArray) {
        if (propValue == null) {
            return defaultArray;
        }
        if (propValue instanceof String) {
            return new String[]{(String)propValue};
        }
        if (propValue instanceof String[]) {
            return (String[])propValue;
        }
        if (propValue.getClass().isArray()) {
            Object[] valueArray = (Object[])propValue;
            ArrayList<String> values = new ArrayList<String>(valueArray.length);
            for (Object value : valueArray) {
                if (value == null) continue;
                values.add(value.toString());
            }
            return values.toArray(new String[values.size()]);
        }
        if (propValue instanceof Collection) {
            Collection valueCollection = (Collection)propValue;
            ArrayList<String> valueList = new ArrayList<String>(valueCollection.size());
            for (Object value : valueCollection) {
                if (value == null) continue;
                valueList.add(value.toString());
            }
            return valueList.toArray(new String[valueList.size()]);
        }
        return defaultArray;
    }

    public static Map<String, String> toMap(Object propValue, String[] defaultArray) {
        String[] arrayValue = PropertiesUtil.toStringArray(propValue, defaultArray);
        if (arrayValue == null) {
            return null;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String kv : arrayValue) {
            int indexOfEqual = kv.indexOf(61);
            if (indexOfEqual <= 0) continue;
            String key = PropertiesUtil.trimToNull(kv.substring(0, indexOfEqual));
            String value = PropertiesUtil.trimToNull(kv.substring(indexOfEqual + 1));
            if (key == null) continue;
            result.put(key, value);
        }
        return result;
    }

    private static String trimToNull(String str) {
        String ts = PropertiesUtil.trim(str);
        return PropertiesUtil.isEmpty(ts) ? null : ts;
    }

    private static String trim(String str) {
        return str == null ? null : str.trim();
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

