/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import javax.inject.Inject;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.impl.ReflectionUtil;
import org.apache.sling.models.impl.model.ConstructorParameter;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;

public class ModelClassConstructor<ModelType> {
    private final Constructor<ModelType> constructor;
    private final boolean hasInjectAnnotation;
    private final ConstructorParameter[] constructorParametersArray;

    public ModelClassConstructor(Constructor<ModelType> constructor, StaticInjectAnnotationProcessorFactory[] processorFactories, DefaultInjectionStrategy defaultInjectionStrategy) {
        this.constructor = constructor;
        this.hasInjectAnnotation = constructor.isAnnotationPresent(Inject.class);
        Type[] parameterTypes = constructor.getGenericParameterTypes();
        this.constructorParametersArray = new ConstructorParameter[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type genericType = ReflectionUtil.mapPrimitiveClasses(parameterTypes[i]);
            boolean isPrimitive = parameterTypes[i] != genericType;
            this.constructorParametersArray[i] = new ConstructorParameter(constructor.getParameterAnnotations()[i], constructor.getParameterTypes()[i], genericType, isPrimitive, i, processorFactories, defaultInjectionStrategy);
        }
    }

    public Constructor<ModelType> getConstructor() {
        return this.constructor;
    }

    public boolean hasInjectAnnotation() {
        return this.hasInjectAnnotation;
    }

    public ConstructorParameter[] getConstructorParameters() {
        return this.constructorParametersArray;
    }
}

