/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.injectors;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.apache.sling.models.impl.injectors.AbstractInjector;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.ValuePreparer;
import org.apache.sling.models.spi.injectorspecific.AbstractInjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessor;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessorFactory;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.ranking:Integer=2000"}, service={Injector.class, InjectAnnotationProcessorFactory.class, ValuePreparer.class})
public class ValueMapInjector
extends AbstractInjector
implements Injector,
InjectAnnotationProcessorFactory,
ValuePreparer {
    private static final Logger log = LoggerFactory.getLogger(ValueMapInjector.class);

    @NotNull
    public String getName() {
        return "valuemap";
    }

    public Object getValue(@NotNull Object adaptable, String name, @NotNull Type type, @NotNull AnnotatedElement element, @NotNull DisposalCallbackRegistry callbackRegistry) {
        if (adaptable == ObjectUtils.NULL) {
            return null;
        }
        ValueMap map = this.getValueMap(adaptable);
        if (map == null) {
            return null;
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            try {
                return map.get(name, clazz);
            }
            catch (ClassCastException e) {
                if (clazz.isArray()) {
                    Class<?> componentType = clazz.getComponentType();
                    if (componentType.isPrimitive()) {
                        Object wrapperArray;
                        Class wrapper = ClassUtils.primitiveToWrapper(componentType);
                        if (wrapper != componentType && (wrapperArray = map.get(name, Array.newInstance(wrapper, 0).getClass())) != null) {
                            return this.unwrapArray(wrapperArray, componentType);
                        }
                    } else {
                        Object primitiveArray;
                        Class primitiveType = ClassUtils.wrapperToPrimitive(componentType);
                        if (primitiveType != componentType && (primitiveArray = map.get(name, Array.newInstance(primitiveType, 0).getClass())) != null) {
                            return this.wrapArray(primitiveArray, componentType);
                        }
                    }
                }
                return null;
            }
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            if (pType.getActualTypeArguments().length != 1) {
                return null;
            }
            Class collectionType = (Class)pType.getRawType();
            if (!collectionType.equals(Collection.class) && !collectionType.equals(List.class)) {
                return null;
            }
            Class itemType = (Class)pType.getActualTypeArguments()[0];
            Object array = map.get(name, Array.newInstance(itemType, 0).getClass());
            if (array == null) {
                return null;
            }
            return Arrays.asList((Object[])array);
        }
        log.debug("ValueMapInjector doesn't support non-class types {}", (Object)type);
        return null;
    }

    private Object unwrapArray(Object wrapperArray, Class<?> primitiveType) {
        int length = Array.getLength(wrapperArray);
        Object primitiveArray = Array.newInstance(primitiveType, length);
        for (int i = 0; i < length; ++i) {
            Array.set(primitiveArray, i, Array.get(wrapperArray, i));
        }
        return primitiveArray;
    }

    private Object wrapArray(Object primitiveArray, Class<?> wrapperType) {
        int length = Array.getLength(primitiveArray);
        Object wrapperArray = Array.newInstance(wrapperType, length);
        for (int i = 0; i < length; ++i) {
            Array.set(wrapperArray, i, Array.get(primitiveArray, i));
        }
        return wrapperArray;
    }

    public Object prepareValue(Object adaptable) {
        ValueMap prepared = this.getValueMap(adaptable);
        return prepared != null ? prepared : ObjectUtils.NULL;
    }

    public InjectAnnotationProcessor createAnnotationProcessor(Object adaptable, AnnotatedElement element) {
        ValueMapValue annotation = element.getAnnotation(ValueMapValue.class);
        if (annotation != null) {
            return new ValueAnnotationProcessor(annotation, adaptable);
        }
        return null;
    }

    private static class ValueAnnotationProcessor
    extends AbstractInjectAnnotationProcessor2 {
        private final ValueMapValue annotation;
        private final Object adaptable;

        public ValueAnnotationProcessor(ValueMapValue annotation, Object adaptable) {
            this.annotation = annotation;
            this.adaptable = adaptable;
        }

        public String getName() {
            if (this.annotation.name().isEmpty()) {
                return null;
            }
            return this.annotation.name();
        }

        public String getVia() {
            if (StringUtils.isNotBlank((CharSequence)this.annotation.via())) {
                return this.annotation.via();
            }
            if (this.adaptable instanceof SlingHttpServletRequest) {
                return "resource";
            }
            return null;
        }

        public Boolean isOptional() {
            return this.annotation.optional();
        }

        public InjectionStrategy getInjectionStrategy() {
            return this.annotation.injectionStrategy();
        }
    }
}

