/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.injectors;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.models.annotations.Filter;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.spi.AcceptsNullName;
import org.apache.sling.models.spi.DisposalCallback;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.injectorspecific.AbstractInjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.ranking:Integer=5000"}, service={Injector.class, StaticInjectAnnotationProcessorFactory.class, AcceptsNullName.class})
public class OSGiServiceInjector
implements Injector,
StaticInjectAnnotationProcessorFactory,
AcceptsNullName {
    private static final Logger log = LoggerFactory.getLogger(OSGiServiceInjector.class);
    private BundleContext bundleContext;

    @NotNull
    public String getName() {
        return "osgi-services";
    }

    @Activate
    public void activate(BundleContext ctx) {
        this.bundleContext = ctx;
    }

    public Object getValue(@NotNull Object adaptable, String name, @NotNull Type type, @NotNull AnnotatedElement element, @NotNull DisposalCallbackRegistry callbackRegistry) {
        return this.getValue(adaptable, name, type, element, callbackRegistry, this.bundleContext);
    }

    public Object getValue(@NotNull Object adaptable, String name, @NotNull Type type, @NotNull AnnotatedElement element, @NotNull DisposalCallbackRegistry callbackRegistry, @Nullable BundleContext modelContext) {
        OSGiService annotation = element.getAnnotation(OSGiService.class);
        String filterString = null;
        if (annotation != null) {
            if (StringUtils.isNotBlank((CharSequence)annotation.filter())) {
                filterString = annotation.filter();
            }
        } else {
            Filter filter = element.getAnnotation(Filter.class);
            if (filter != null) {
                filterString = filter.value();
            }
        }
        return this.getValue(adaptable, type, filterString, callbackRegistry, modelContext == null ? this.bundleContext : modelContext);
    }

    private <T> Object getService(Object adaptable, Class<T> type, String filter, DisposalCallbackRegistry callbackRegistry, BundleContext modelContext) {
        try {
            ServiceReference[] refs = modelContext.getServiceReferences(type.getName(), filter);
            if (refs == null || refs.length == 0) {
                return null;
            }
            List<ServiceReference> references = Arrays.asList(refs);
            Collections.sort(references);
            callbackRegistry.addDisposalCallback((DisposalCallback)new Callback(refs, modelContext));
            return modelContext.getService(references.get(references.size() - 1));
        }
        catch (InvalidSyntaxException e) {
            log.error("invalid filter expression", (Throwable)e);
            return null;
        }
    }

    private <T> Object[] getServices(Object adaptable, Class<T> type, String filter, DisposalCallbackRegistry callbackRegistry, BundleContext modelContext) {
        try {
            ServiceReference[] refs = modelContext.getServiceReferences(type.getName(), filter);
            if (refs == null || refs.length == 0) {
                return null;
            }
            List<ServiceReference> references = Arrays.asList(refs);
            Collections.sort(references);
            Collections.reverse(references);
            callbackRegistry.addDisposalCallback((DisposalCallback)new Callback(refs, modelContext));
            ArrayList<Object> services = new ArrayList<Object>();
            for (ServiceReference ref : references) {
                Object service = modelContext.getService(ref);
                if (service == null) continue;
                services.add(service);
            }
            return services.toArray();
        }
        catch (InvalidSyntaxException e) {
            log.error("invalid filter expression", (Throwable)e);
            return null;
        }
    }

    private Object getValue(Object adaptable, Type type, String filterString, DisposalCallbackRegistry callbackRegistry, BundleContext modelContext) {
        if (type instanceof Class) {
            Class injectedClass = (Class)type;
            if (injectedClass.isArray()) {
                Object[] services = this.getServices(adaptable, injectedClass.getComponentType(), filterString, callbackRegistry, modelContext);
                if (services == null) {
                    return null;
                }
                Object arr = Array.newInstance(injectedClass.getComponentType(), services.length);
                for (int i = 0; i < services.length; ++i) {
                    Array.set(arr, i, services[i]);
                }
                return arr;
            }
            return this.getService(adaptable, injectedClass, filterString, callbackRegistry, modelContext);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            if (ptype.getActualTypeArguments().length != 1) {
                return null;
            }
            Class collectionType = (Class)ptype.getRawType();
            if (!collectionType.equals(Collection.class) && !collectionType.equals(List.class)) {
                return null;
            }
            Class serviceType = (Class)ptype.getActualTypeArguments()[0];
            Object[] services = this.getServices(adaptable, serviceType, filterString, callbackRegistry, modelContext);
            if (services == null) {
                return null;
            }
            return Arrays.asList(services);
        }
        log.warn("Cannot handle type {}", (Object)type);
        return null;
    }

    public InjectAnnotationProcessor2 createAnnotationProcessor(AnnotatedElement element) {
        OSGiService annotation = element.getAnnotation(OSGiService.class);
        if (annotation != null) {
            return new OSGiServiceAnnotationProcessor(annotation);
        }
        return null;
    }

    private static class OSGiServiceAnnotationProcessor
    extends AbstractInjectAnnotationProcessor2 {
        private final OSGiService annotation;

        public OSGiServiceAnnotationProcessor(OSGiService annotation) {
            this.annotation = annotation;
        }

        public InjectionStrategy getInjectionStrategy() {
            return this.annotation.injectionStrategy();
        }

        public Boolean isOptional() {
            return this.annotation.optional();
        }
    }

    private static class Callback
    implements DisposalCallback {
        private final ServiceReference<?>[] refs;
        private final BundleContext context;

        public Callback(ServiceReference<?>[] refs, BundleContext context) {
            this.refs = refs;
            this.context = context;
        }

        public void onDisposed() {
            if (this.refs != null) {
                for (ServiceReference<?> ref : this.refs) {
                    this.context.ungetService(ref);
                }
            }
        }
    }
}

