/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.testservices.servlets;

import java.io.IOException;
import javax.jcr.Repository;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;

@Component(immediate=true)
@Service
@Properties(value={@Property(name="service.description", value={"Repository Descriptors Servlet"}), @Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="sling.servlet.paths", value={"/testing/RepositoryDescriptors"}), @Property(name="sling.servlet.extensions", value={"json"})})
public class RepositoryDescriptorsServlet
extends SlingSafeMethodsServlet {
    @Reference
    private Repository repository;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        try {
            JSONWriter w = new JSONWriter(response.getWriter());
            w.object();
            w.key("descriptors");
            w.object();
            for (String key : this.repository.getDescriptorKeys()) {
                w.key(key).value(this.repository.getDescriptor(key));
            }
            w.endObject();
            w.endObject();
            w.flush();
        }
        catch (IOException je) {
            throw (IOException)new IOException("JSONException in doGet").initCause(je);
        }
    }

    protected void bindRepository(Repository repository) {
        this.repository = repository;
    }

    protected void unbindRepository(Repository repository) {
        if (this.repository == repository) {
            this.repository = null;
        }
    }
}

