/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.jupiter.osgi;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.sling.junit.jupiter.osgi.Service;
import org.apache.sling.junit.jupiter.osgi.ServiceCardinality;
import org.apache.sling.junit.jupiter.osgi.impl.AbstractTypeBasedParameterResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.platform.commons.support.AnnotationSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

class ServiceParameterResolver
extends AbstractTypeBasedParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{ServiceParameterResolver.class});

    ServiceParameterResolver() {
    }

    @Override
    protected boolean supportsParameter(@NotNull ParameterContext parameterContext, @NotNull ExtensionContext extensionContext, @NotNull Type resolvedParameterType) {
        Optional service = ServiceParameterResolver.computeServiceType(resolvedParameterType).flatMap(serviceType -> ServiceParameterResolver.findServiceAnnotation(parameterContext, extensionContext, serviceType));
        return service.isPresent();
    }

    @Override
    protected Object resolveParameter(@NotNull ParameterContext parameterContext, @NotNull ExtensionContext extensionContext, @NotNull Type resolvedParameterType) {
        ServiceHolder.Key key = (ServiceHolder.Key)ServiceParameterResolver.computeServiceType(resolvedParameterType).flatMap(serviceType -> ServiceParameterResolver.findServiceAnnotation(parameterContext, extensionContext, serviceType).map(ann -> ServiceParameterResolver.toKey(serviceType, ann))).orElseThrow(() -> new ParameterResolutionException("Cannot handle type " + resolvedParameterType));
        ServiceHolder serviceHolder = (ServiceHolder)extensionContext.getStore(NAMESPACE).getOrComputeIfAbsent((Object)key, ServiceParameterResolver.serviceHolderFactory(extensionContext), ServiceHolder.class);
        return ServiceParameterResolver.isMultiple(resolvedParameterType) ? serviceHolder.getServices() : serviceHolder.getService();
    }

    private static ServiceHolder.Key toKey(Class<?> serviceType, Service serviceAnnotation) {
        return new ServiceHolder.Key(serviceType, serviceAnnotation);
    }

    @NotNull
    private static Optional<Class<?>> computeServiceType(@NotNull Type resolvedParameterType) {
        if (resolvedParameterType instanceof ParameterizedType) {
            Type[] actualTypeArguments;
            ParameterizedType parameterizedType = (ParameterizedType)resolvedParameterType;
            if (ServiceParameterResolver.isMultiple(parameterizedType) && (actualTypeArguments = parameterizedType.getActualTypeArguments()).length == 1 && actualTypeArguments[0] instanceof Class) {
                return Optional.of((Class)actualTypeArguments[0]);
            }
        } else if (resolvedParameterType instanceof Class) {
            return Optional.of((Class)resolvedParameterType);
        }
        return Optional.empty();
    }

    @NotNull
    private static Class<?> getRawClass(ParameterizedType parameterizedType) {
        Type rawType = parameterizedType.getRawType();
        if (!(rawType instanceof Class)) {
            throw new UnsupportedOperationException("Unexpected raw type of parametereized type " + parameterizedType + ": " + rawType);
        }
        return (Class)rawType;
    }

    @NotNull
    private static Function<ServiceHolder.Key, ServiceHolder> serviceHolderFactory(ExtensionContext extensionContext) {
        return key -> new ServiceHolder(ServiceParameterResolver.getBundleContext(extensionContext), (ServiceHolder.Key)key);
    }

    @NotNull
    private static BundleContext getBundleContext(@NotNull ExtensionContext extensionContext) {
        return Optional.ofNullable(FrameworkUtil.getBundle((Class)extensionContext.getRequiredTestClass())).map(Bundle::getBundleContext).orElseThrow(() -> new ParameterResolutionException("@OSGi and @Service annotations can only be used with tests running in an OSGi environment"));
    }

    @NotNull
    private static Optional<Service> findServiceAnnotation(@NotNull ParameterContext parameterContext, @NotNull ExtensionContext extensionContext, @NotNull Class<?> requiredServiceType) {
        return Stream.concat(Stream.of(ServiceParameterResolver.findMatchingServiceAnnotationOnParameter(parameterContext, requiredServiceType)), Stream.of(parameterContext.getDeclaringExecutable(), extensionContext.getRequiredTestClass()).map(annotatedElement -> ServiceParameterResolver.findMatchingServiceAnnotation(annotatedElement, requiredServiceType))).filter(Objects::nonNull).findFirst();
    }

    private static Service findMatchingServiceAnnotationOnParameter(@NotNull ParameterContext parameterContext, @NotNull Class<?> requiredServiceType) {
        List serviceAnnotations = parameterContext.findRepeatableAnnotations(Service.class);
        switch (serviceAnnotations.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Service serviceAnnotation = (Service)serviceAnnotations.get(0);
                if (!serviceAnnotation.value().isAssignableFrom(requiredServiceType)) {
                    throw new ParameterResolutionException("Mismatched types in annotation and parameter. Annotation type is \"" + serviceAnnotation.value().getSimpleName() + "\", parameter type is \"" + requiredServiceType.getSimpleName() + "\"");
                }
                return serviceAnnotation;
            }
        }
        throw new ParameterResolutionException("Parameters must not be annotated with multiple @Service annotations: " + parameterContext.getDeclaringExecutable());
    }

    @Nullable
    private static Service findMatchingServiceAnnotation(@Nullable AnnotatedElement annotatedElement, @NotNull Class<?> requiredServiceType) {
        return AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)annotatedElement, Service.class).stream().filter(serviceAnnotation -> Objects.equals(serviceAnnotation.value(), requiredServiceType)).findFirst().orElse(null);
    }

    private static boolean isMultiple(@NotNull Type resolvedParameterType) {
        if (resolvedParameterType instanceof ParameterizedType) {
            Class<?> type = ServiceParameterResolver.getRawClass((ParameterizedType)resolvedParameterType);
            return Collection.class == type || List.class.isAssignableFrom(type);
        }
        return false;
    }

    private static class ServiceHolder
    implements ExtensionContext.Store.CloseableResource {
        private final Key key;
        private final ServiceTracker<?, ?> serviceTracker;

        private ServiceHolder(@NotNull BundleContext bundleContext, @NotNull Key key) {
            this.key = key;
            Filter filter = ServiceHolder.createFilter(bundleContext, key.type(), key.filter());
            this.serviceTracker = new SortingServiceTracker(bundleContext, filter);
            this.serviceTracker.open();
        }

        public void close() throws Throwable {
            this.serviceTracker.close();
        }

        @Nullable
        public Object getService() throws ParameterResolutionException {
            Object service = this.serviceTracker.getService();
            return this.checkCardinality(service, false);
        }

        @NotNull
        public List<Object> getServices() throws ParameterResolutionException {
            @Nullable Object[] services = this.serviceTracker.getServices();
            return Optional.ofNullable(this.checkCardinality(services, true)).map(Arrays::asList).orElseGet(Collections::emptyList);
        }

        @Nullable
        private <T> T checkCardinality(@Nullable T service, boolean isMultiple) throws ParameterResolutionException {
            ServiceCardinality effectiveCardinality = this.calculateEffectiveCardinality(isMultiple);
            if (service == null && effectiveCardinality == ServiceCardinality.MANDATORY) {
                throw ServiceHolder.createServiceNotFoundException(this.key.filter(), this.key.type());
            }
            return service;
        }

        @NotNull
        private ServiceCardinality calculateEffectiveCardinality(boolean isMultiple) {
            ServiceCardinality cardinality = this.key.cardinality();
            if (cardinality == ServiceCardinality.AUTO) {
                return isMultiple ? ServiceCardinality.OPTIONAL : ServiceCardinality.MANDATORY;
            }
            return cardinality;
        }

        @NotNull
        private static ParameterResolutionException createServiceNotFoundException(@NotNull String ldapFilter, @NotNull Type resolvedParameterType) {
            return Optional.of(ldapFilter).map(String::trim).filter(filter -> !filter.isEmpty()).map(filter -> new ParameterResolutionException("No service of type \"" + resolvedParameterType.getTypeName() + "\" with filter \"" + filter + "\" available")).orElseGet(() -> new ParameterResolutionException("No service of type \"" + resolvedParameterType.getTypeName() + "\" available"));
        }

        @NotNull
        private static Filter createFilter(@NotNull BundleContext bundleContext, @NotNull Class<?> clazz, @NotNull String ldapFilter) {
            String classFilter = String.format("(%s=%s)", "objectClass", clazz.getName());
            String combinedFilter = ldapFilter.trim().isEmpty() ? classFilter : String.format("(&%s%s)", classFilter, ldapFilter);
            try {
                return bundleContext.createFilter(combinedFilter);
            }
            catch (InvalidSyntaxException e) {
                throw new ParameterResolutionException("Invalid filter expression used in @Service annotation :\"" + ldapFilter + "\"", (Throwable)e);
            }
        }

        private static class Key {
            private final Class<?> serviceType;
            private final Service serviceAnnotation;

            public Key(@NotNull Class<?> serviceType, @NotNull Service serviceAnnotation) {
                this.serviceType = serviceType;
                this.serviceAnnotation = serviceAnnotation;
            }

            @NotNull
            public Class<?> type() {
                return this.serviceType;
            }

            @NotNull
            public String filter() {
                return this.serviceAnnotation.filter();
            }

            @NotNull
            public ServiceCardinality cardinality() {
                return this.serviceAnnotation.cardinality();
            }

            public boolean equals(Object o) {
                if (!(o instanceof Key)) {
                    return false;
                }
                Key key = (Key)o;
                return this == o || Objects.equals(this.serviceType, key.serviceType) && Objects.equals(this.serviceAnnotation, key.serviceAnnotation);
            }

            public int hashCode() {
                return Objects.hash(this.serviceType, this.serviceAnnotation);
            }
        }

        private static class SortingServiceTracker<T>
        extends ServiceTracker<T, T> {
            public SortingServiceTracker(@NotNull BundleContext bundleContext, @NotNull Filter filter) {
                super(bundleContext, filter, null);
            }

            @Nullable
            public ServiceReference<T>[] getServiceReferences() {
                return Optional.ofNullable(super.getServiceReferences()).map(serviceReferences -> {
                    Arrays.sort(serviceReferences, Comparator.reverseOrder());
                    return serviceReferences;
                }).orElse(null);
            }
        }
    }
}

