/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import junit.runner.BaseTestRunner;
import org.apache.sling.junit.Renderer;
import org.apache.sling.junit.RendererFactory;
import org.apache.sling.junit.TestSelector;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.osgi.service.component.annotations.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

@Component
public class XmlRenderer
extends RunListener
implements Renderer,
RendererFactory {
    public static final String EXTENSION = "xml";
    private PrintWriter output;
    private Document doc;
    private Element suitesElement;
    private Element rootElement;
    private Hashtable<Description, Element> testElements = new Hashtable();
    private ArrayList<Description> failures = new ArrayList();
    Hashtable<Description, Long> tests = new Hashtable();
    private String name;
    private long suiteStartTime = 0L;
    private int testSuiteCount = 0;

    @Override
    public Renderer createRenderer() {
        return new XmlRenderer();
    }

    @Override
    public boolean appliesTo(TestSelector selector) {
        return EXTENSION.equals(selector.getExtension());
    }

    @Override
    public String getExtension() {
        return EXTENSION;
    }

    @Override
    public void setup(HttpServletResponse response, String pageTitle) throws IOException, UnsupportedEncodingException {
        if (this.output != null) {
            throw new IllegalStateException("Output Writer already set");
        }
        this.suiteStartTime = System.currentTimeMillis();
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        this.output = response.getWriter();
        this.doc = XmlRenderer.getDocumentBuilder().newDocument();
        this.suitesElement = this.doc.createElement("testsuites");
    }

    @Override
    public void info(String cssClass, String str) {
    }

    @Override
    public void list(String cssClass, Collection<String> data) {
    }

    @Override
    public void title(int level, String title) {
        if (level == 3) {
            this.name = title;
        }
    }

    @Override
    public void link(String info, String url, String method) {
    }

    @Override
    public void cleanup() {
        if (this.testSuiteCount > 1) {
            this.output.println(XmlRenderer.getStringFromElement(this.suitesElement));
        } else {
            this.output.println(XmlRenderer.getStringFromElement(this.rootElement));
        }
        this.output = null;
    }

    @Override
    public RunListener getRunListener() {
        return this;
    }

    @Override
    public void testFailure(Failure failure) throws Exception {
        super.testFailure(failure);
        this.failures.add(failure.getDescription());
        Element nested = this.doc.createElement("failure");
        Element currentTest = this.testElements.get(failure.getDescription());
        currentTest.appendChild(nested);
        String message = failure.getMessage();
        if (message != null && message.length() > 0) {
            nested.setAttribute("message", message);
        }
        nested.setAttribute("type", failure.getClass().getName());
        String strace = XmlRenderer.getException(failure.getException());
        strace = BaseTestRunner.getFilteredTrace(strace);
        Text trace = this.doc.createTextNode(strace);
        nested.appendChild(trace);
    }

    @Override
    public void testFinished(Description description) throws Exception {
        super.testFinished(description);
        Long startTime = this.tests.get(description);
        long totalTime = System.currentTimeMillis() - startTime;
        Element currentTest = this.testElements.get(description);
        currentTest.setAttribute("time", String.valueOf((double)totalTime / 1000.0));
    }

    @Override
    public void testIgnored(Description description) throws Exception {
        super.testIgnored(description);
    }

    @Override
    public void testRunFinished(Result result) throws Exception {
        super.testRunFinished(result);
        String cssClass = "testRun ";
        cssClass = result.getFailureCount() > 0 ? cssClass + "failure" : (result.getIgnoreCount() > 0 ? cssClass + "ignored" : cssClass + "success");
        long suiteEndTime = System.currentTimeMillis();
        this.rootElement.setAttribute("name", this.name);
        this.rootElement.setAttribute("timestamp", String.valueOf(suiteEndTime));
        this.rootElement.setAttribute("hostname", this.getHostname());
        this.rootElement.setAttribute("tests", "" + result.getRunCount());
        this.rootElement.setAttribute("failures", "" + result.getFailureCount());
        this.rootElement.setAttribute("time", "" + (double)(suiteEndTime - this.suiteStartTime) / 1000.0);
    }

    @Override
    public void testRunStarted(Description description) throws Exception {
        super.testRunStarted(description);
        ++this.testSuiteCount;
        this.rootElement = this.doc.createElement("testsuite");
        this.suitesElement.appendChild(this.rootElement);
        Element propsElement = this.doc.createElement("properties");
        this.rootElement.appendChild(propsElement);
    }

    @Override
    public void testSuiteStarted(Description description) throws Exception {
        super.testSuiteStarted(description);
        if (description.getTestClass() != null) {
            this.title(3, description.getClassName());
        }
    }

    @Override
    public void testStarted(Description description) throws Exception {
        super.testStarted(description);
        this.tests.put(description, new Long(System.currentTimeMillis()));
        Element currentTest = this.doc.createElement("testcase");
        String n = description.getDisplayName();
        n = n.substring(0, n.indexOf("("));
        currentTest.setAttribute("name", n == null ? "unknown" : n);
        currentTest.setAttribute("classname", description.getClassName());
        this.rootElement.appendChild(currentTest);
        this.testElements.put(description, currentTest);
    }

    public static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exc) {
            throw new ExceptionInInitializerError(exc);
        }
    }

    public static String getStringFromElement(Element element) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            StringWriter sw = new StringWriter();
            trans.transform(new DOMSource(element), new StreamResult(sw));
            String elementString = sw.toString();
            return elementString;
        }
        catch (TransformerConfigurationException e) {
            System.err.println(XmlRenderer.getException(e));
        }
        catch (TransformerException e) {
            System.err.println(XmlRenderer.getException(e));
        }
        return "";
    }

    private String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    public static String getException(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.getBuffer().toString();
    }
}

