/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.junit.Renderer;
import org.apache.sling.junit.RendererFactory;
import org.apache.sling.junit.TestSelector;
import org.apache.sling.junit.impl.servlet.HtmlFilter;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;

@Component(scope=ServiceScope.BUNDLE, service={Renderer.class, RendererFactory.class})
public class HtmlRenderer
extends RunListener
implements Renderer,
RendererFactory {
    public static final String EXTENSION = "html";
    private PrintWriter output;

    @Override
    public Renderer createRenderer() {
        return new HtmlRenderer();
    }

    @Override
    public boolean appliesTo(TestSelector s) {
        return EXTENSION.equals(s.getExtension()) || "".equals(s.getExtension());
    }

    @Override
    public String getExtension() {
        return EXTENSION;
    }

    @Override
    public void info(String cssClass, String str) {
        this.output.println("<p class='" + cssClass + "'>");
        HtmlFilter.escape(this.output, str);
        this.output.println("</p>");
    }

    @Override
    public void list(String cssClass, Collection<String> data) {
        this.output.println("<ul class='testNames'>");
        for (String str : data) {
            this.output.println("<li>");
            this.link(str, str + ".html", "GET");
            this.output.println("</li>");
        }
        this.output.println("</ul>");
    }

    @Override
    public void title(int level, String title) {
        this.output.print("<h" + level + ">");
        HtmlFilter.escape(this.output, title);
        this.output.print("</h" + level + ">");
    }

    @Override
    public void link(String info, String url, String method) {
        this.output.println("<div class='link'>");
        if ("POST".equalsIgnoreCase(method)) {
            this.output.print("<form method='POST' action='");
            this.output.print(url);
            this.output.print("'>");
            this.output.print("<input type='submit' value='");
            HtmlFilter.escape(this.output, info);
            this.output.print("'/>");
            this.output.println("</form>");
        } else {
            this.output.print("<a href='");
            this.output.print(url);
            this.output.print("'>");
            HtmlFilter.escape(this.output, info);
            this.output.println("</a>");
        }
        this.output.println("</div>");
    }

    @Override
    public void setup(HttpServletResponse response, String pageTitle) throws IOException {
        if (this.output != null) {
            throw new IllegalStateException("Output Writer already set");
        }
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        this.setWriter(response.getWriter());
        this.output.println("<html><head>");
        this.output.println("<link rel='stylesheet' type='text/css' href='junit.css'/>");
        this.output.print("<title>");
        HtmlFilter.escape(this.output, pageTitle);
        this.output.println("</title>");
        this.output.println("</head><body><h1>");
        HtmlFilter.escape(this.output, pageTitle);
        this.output.println("</h1>");
    }

    public void setWriter(PrintWriter writer) {
        this.output = writer;
    }

    @Override
    public void cleanup() {
        this.output.println("</body>");
        this.output.println("</html>");
        this.output = null;
    }

    @Override
    public RunListener getRunListener() {
        return this;
    }

    @Override
    public void testAssumptionFailure(Failure failure) {
        super.testAssumptionFailure(failure);
        this.output.print("<p class='ignored'><h3>TEST ABORTED: ");
        HtmlFilter.escape(this.output, failure.getTestHeader());
        this.output.print("</h3><b>");
        String message = failure.getMessage();
        if (!message.startsWith("Assumption failed: ")) {
            message = "Assumption failed: " + message;
        }
        HtmlFilter.escape(this.output, message);
        this.output.println("</b></p>");
    }

    @Override
    public void testFailure(Failure failure) throws Exception {
        super.testFailure(failure);
        this.output.print("<div class='failure'><h3>");
        this.output.print("TEST FAILED: ");
        HtmlFilter.escape(this.output, failure.getTestHeader());
        this.output.print("</h3><div class='failureDetails'>");
        this.output.print("<div>");
        HtmlFilter.escape(this.output, failure.toString());
        this.output.print("</div><div>Stack Trace: ");
        HtmlFilter.escape(this.output, failure.getTrace());
        this.output.println("</div></div></div>");
    }

    @Override
    public void testFinished(Description description) throws Exception {
        super.testFinished(description);
        this.output.print("<p class='finished'>Test finished: ");
        HtmlFilter.escape(this.output, description.toString());
        this.output.println("</p></div>");
    }

    @Override
    public void testIgnored(Description description) throws Exception {
        super.testIgnored(description);
        this.output.print("<p class='ignored'><h3>TEST IGNORED</h3><b>");
        HtmlFilter.escape(this.output, description.toString());
        this.output.println("</b></p>");
    }

    private void counter(String name, String cssName, int value) {
        String cssClass = cssName + (value > 0 ? "NonZero" : "Zero");
        this.output.print("<span class='");
        this.output.print(cssClass);
        this.output.print("'>");
        HtmlFilter.escape(this.output, name);
        this.output.print(":");
        HtmlFilter.escape(this.output, String.valueOf(value));
        this.output.println("</span>");
    }

    @Override
    public void testRunFinished(Result result) throws Exception {
        super.testRunFinished(result);
        this.output.println("<p class='testRun'>");
        this.output.print("TEST RUN FINISHED: ");
        this.counter("tests", "testCount", result.getRunCount());
        this.output.print(", ");
        this.counter("failures", "failureCount", result.getFailureCount());
        this.output.print(", ");
        this.counter("ignored", "ignoredCount", result.getIgnoreCount());
        this.output.print(", ");
        this.counter("aborted", "abortedCount", result.getAssumptionFailureCount());
        this.output.println("</p>");
    }

    @Override
    public void testSuiteStarted(Description description) throws Exception {
        super.testSuiteStarted(description);
        if (description.getTestClass() != null) {
            this.title(3, description.getClassName());
        }
    }

    @Override
    public void testStarted(Description description) throws Exception {
        super.testStarted(description);
        this.output.println("<div class='test'>");
    }
}

