/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sling.junit.Renderer;
import org.apache.sling.junit.RendererFactory;
import org.apache.sling.junit.RendererSelector;
import org.apache.sling.junit.TestSelector;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class RendererSelectorImpl
implements RendererSelector {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<Renderer> renderers = new ArrayList<Renderer>();
    private ServiceTracker renderersTracker;
    private int renderersTrackerTrackingCount = -1;
    private BundleContext bundleContext;

    @Override
    public Collection<Renderer> getRenderers() {
        return Collections.unmodifiableCollection(this.renderers);
    }

    @Override
    public Renderer getRenderer(TestSelector selector) {
        if (this.renderersTracker.getTrackingCount() != this.renderersTrackerTrackingCount) {
            this.log.debug("Rebuilding list of {}", (Object)Renderer.class.getSimpleName());
            this.renderersTrackerTrackingCount = this.renderersTracker.getTrackingCount();
            ServiceReference[] refs = this.renderersTracker.getServiceReferences();
            this.renderers.clear();
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    this.renderers.add((Renderer)this.bundleContext.getService(ref));
                }
            }
            this.log.info("List of {} rebuilt: {}", (Object)Renderer.class.getSimpleName(), this.renderers);
        }
        for (Renderer r : this.renderers) {
            if (!r.appliesTo(selector)) continue;
            if (r instanceof RendererFactory) {
                return ((RendererFactory)((Object)r)).createRenderer();
            }
            throw new UnsupportedOperationException("Renderers must implement RendererFactory, this one does not:" + r);
        }
        return null;
    }

    @Activate
    protected void activate(ComponentContext ctx) {
        this.bundleContext = ctx.getBundleContext();
        this.renderersTracker = new ServiceTracker(ctx.getBundleContext(), Renderer.class.getName(), null);
        this.renderersTracker.open();
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx) {
        if (this.renderersTracker != null) {
            this.renderersTracker.close();
            this.renderersTracker = null;
        }
        this.bundleContext = null;
    }
}

