/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit;

import org.apache.sling.junit.TestSelector;

public class RequestParser
implements TestSelector {
    private final String testNameSelector;
    private final String selectedMethodName;
    private final String extension;
    private static final String EMPTY_STRING = "";

    public RequestParser(String subpath) {
        if (subpath == null) {
            this.testNameSelector = EMPTY_STRING;
            this.selectedMethodName = EMPTY_STRING;
            this.extension = EMPTY_STRING;
        } else {
            if (subpath.startsWith("/")) {
                subpath = subpath.substring(1);
            }
            String beforeExtension = null;
            int pos = subpath.lastIndexOf(46);
            if (pos >= 0) {
                beforeExtension = subpath.substring(0, pos);
                this.extension = subpath.substring(pos + 1);
            } else {
                beforeExtension = subpath;
                this.extension = EMPTY_STRING;
            }
            pos = beforeExtension.lastIndexOf(47);
            if (pos >= 0) {
                this.testNameSelector = beforeExtension.substring(0, pos);
                this.selectedMethodName = beforeExtension.substring(pos + 1);
            } else {
                this.testNameSelector = beforeExtension;
                this.selectedMethodName = EMPTY_STRING;
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", testSelector [" + RequestParser.safeForLogging(this.testNameSelector) + "], methodName [" + RequestParser.safeForLogging(this.selectedMethodName) + "], extension [" + RequestParser.safeForLogging(this.extension) + "]";
    }

    private static String safeForLogging(String str) {
        return str.replaceAll("[\n\r\t]", "_");
    }

    @Override
    public String getTestSelectorString() {
        return this.testNameSelector;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    public String getMethodName() {
        return this.selectedMethodName;
    }

    @Override
    public boolean acceptTestName(String testName) {
        if (this.testNameSelector.length() == 0) {
            return true;
        }
        return testName.equals(this.testNameSelector) || testName.startsWith(this.testNameSelector + '.');
    }

    @Override
    public String getSelectedTestMethodName() {
        return this.selectedMethodName;
    }
}

