/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.webconsole.internal;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.OnParentVersionAction;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"felix.inventory.printer.name=JCR Node Types", "felix.inventory.printer.format=TEXT"})
public class NodeTypeConfigurationPrinter
implements InventoryPrinter {
    @Reference
    private SlingRepository slingRepository;

    private List<NodeType> sortTypes(NodeTypeIterator it) {
        ArrayList<NodeType> types = new ArrayList<NodeType>();
        while (it.hasNext()) {
            NodeType nt = it.nextNodeType();
            types.add(nt);
        }
        Collections.sort(types, new Comparator<NodeType>(){

            @Override
            public int compare(NodeType o1, NodeType o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return types;
    }

    private void printRequiredChildTypes(PrintWriter pw, NodeDefinition child) {
        if (child.getRequiredPrimaryTypes() != null && child.getRequiredPrimaryTypes().length > 0) {
            pw.print(" (");
            boolean first = true;
            for (NodeType required : child.getRequiredPrimaryTypes()) {
                if (!first) {
                    pw.print(", ");
                }
                pw.print(required.getName());
                first = false;
            }
            pw.print(")");
        }
    }

    private void printDefaultValues(PrintWriter pw, PropertyDefinition prop) throws RepositoryException {
        if (prop.getDefaultValues() != null && prop.getDefaultValues().length > 0) {
            pw.print(" = ");
            boolean first = true;
            for (Value v : prop.getDefaultValues()) {
                if (!first) {
                    pw.print(", ");
                }
                pw.print(v.getString());
                first = false;
            }
        }
    }

    private void printConstraints(PrintWriter pw, PropertyDefinition prop) throws RepositoryException {
        if (prop.getValueConstraints() != null && prop.getValueConstraints().length > 0) {
            pw.print(" < ");
            boolean first = true;
            for (String s : prop.getValueConstraints()) {
                if (!first) {
                    pw.print(", ");
                }
                pw.print(s);
                first = false;
            }
        }
    }

    private void printSuperTypes(PrintWriter pw, NodeType nt) {
        pw.print(" > ");
        boolean first = true;
        for (NodeType st : nt.getSupertypes()) {
            if (!first) {
                pw.print(", ");
            }
            pw.print(st.getName());
            first = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(PrintWriter pw, Format format, boolean isZip) {
        Session session = null;
        try {
            session = this.slingRepository.loginAdministrative(null);
            NodeTypeManager ntm = session.getWorkspace().getNodeTypeManager();
            NodeTypeIterator it = ntm.getAllNodeTypes();
            List<NodeType> sortedTypes = this.sortTypes(it);
            for (NodeType nt : sortedTypes) {
                pw.printf("[%s]", nt.getName());
                this.printSuperTypes(pw, nt);
                if (nt.hasOrderableChildNodes()) {
                    pw.print(" orderable");
                }
                if (nt.isMixin()) {
                    pw.print(" mixin");
                }
                pw.println();
                for (PropertyDefinition propertyDefinition : nt.getPropertyDefinitions()) {
                    pw.printf("- %s", propertyDefinition.getName());
                    this.printDefaultValues(pw, propertyDefinition);
                    if (propertyDefinition.getName().equals(nt.getPrimaryItemName())) {
                        pw.print(" primary");
                    }
                    if (propertyDefinition.isMandatory()) {
                        pw.print(" mandatory");
                    }
                    if (propertyDefinition.isAutoCreated()) {
                        pw.print(" autocreated");
                    }
                    if (propertyDefinition.isProtected()) {
                        pw.print(" protected");
                    }
                    if (propertyDefinition.isMultiple()) {
                        pw.print(" multiple");
                    }
                    pw.printf(" %s", OnParentVersionAction.nameFromValue((int)propertyDefinition.getOnParentVersion()));
                    this.printConstraints(pw, propertyDefinition);
                    pw.println();
                }
                for (PropertyDefinition propertyDefinition : nt.getChildNodeDefinitions()) {
                    pw.printf("+ %s", propertyDefinition.getName());
                    this.printRequiredChildTypes(pw, (NodeDefinition)propertyDefinition);
                    if (propertyDefinition.getDefaultPrimaryType() != null) {
                        pw.printf(" = %s", propertyDefinition.getDefaultPrimaryType().getName());
                    }
                    if (propertyDefinition.isMandatory()) {
                        pw.print(" mandatory");
                    }
                    if (propertyDefinition.isAutoCreated()) {
                        pw.print(" autocreated");
                    }
                    if (propertyDefinition.isProtected()) {
                        pw.print(" protected");
                    }
                    if (propertyDefinition.allowsSameNameSiblings()) {
                        pw.print(" multiple");
                    }
                    pw.printf(" %s", OnParentVersionAction.nameFromValue((int)propertyDefinition.getOnParentVersion()));
                    pw.println();
                }
                pw.println();
            }
        }
        catch (RepositoryException e) {
            pw.println("Unable to output node type definitions.");
            e.printStackTrace(pw);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

