/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Value;

public class LazyInputStream
extends InputStream {
    private final Value value;
    private InputStream delegatee;

    public LazyInputStream(Value value) {
        this.value = value;
    }

    @Override
    public void close() throws IOException {
        if (this.delegatee != null) {
            this.delegatee.close();
        }
    }

    @Override
    public int available() throws IOException {
        return this.getStream().available();
    }

    @Override
    public int read() throws IOException {
        return this.getStream().read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.getStream().read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.getStream().read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.getStream().skip(n);
    }

    @Override
    public boolean markSupported() {
        try {
            return this.getStream().markSupported();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.getStream().mark(readlimit);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.getStream().reset();
    }

    private InputStream getStream() throws IOException {
        if (this.delegatee == null) {
            try {
                this.delegatee = this.value.getBinary().getStream();
            }
            catch (RepositoryException re) {
                throw (IOException)new IOException(re.getMessage()).initCause(re);
            }
        }
        return this.delegatee;
    }
}

