/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.external.URIProvider;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;

public class HelperData {
    private static final URIProvider[] EMPTY_URLPROVIDERS = new URIProvider[0];
    private final AtomicReference<DynamicClassLoaderManager> dynamicClassLoaderManagerReference;
    private final AtomicReference<URIProvider[]> uriProviderReference;
    private volatile String[] namespacePrefixes;

    public HelperData(AtomicReference<DynamicClassLoaderManager> dynamicClassLoaderManagerReference, AtomicReference<URIProvider[]> uriProviderReference) {
        this.dynamicClassLoaderManagerReference = dynamicClassLoaderManagerReference;
        this.uriProviderReference = uriProviderReference;
    }

    public String[] getNamespacePrefixes(Session session) throws RepositoryException {
        if (this.namespacePrefixes == null) {
            this.namespacePrefixes = session.getNamespacePrefixes();
        }
        return this.namespacePrefixes;
    }

    public ClassLoader getDynamicClassLoader() {
        DynamicClassLoaderManager dclm = this.dynamicClassLoaderManagerReference.get();
        if (dclm == null) {
            return null;
        }
        return dclm.getDynamicClassLoader();
    }

    public URIProvider[] getURIProviders() {
        URIProvider[] ups = this.uriProviderReference.get();
        if (ups == null) {
            ups = EMPTY_URLPROVIDERS;
        }
        return ups;
    }
}

