/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.repoinit.impl;

import java.util.Collections;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.jcr.repoinit.impl.AclUtil;
import org.apache.sling.jcr.repoinit.impl.DoNothingVisitor;
import org.apache.sling.repoinit.parser.operations.AclLine;
import org.apache.sling.repoinit.parser.operations.DeleteAclPaths;
import org.apache.sling.repoinit.parser.operations.DeleteAclPrincipalBased;
import org.apache.sling.repoinit.parser.operations.DeleteAclPrincipals;
import org.apache.sling.repoinit.parser.operations.EnsureAclPrincipalBased;
import org.apache.sling.repoinit.parser.operations.RemoveAcePaths;
import org.apache.sling.repoinit.parser.operations.RemoveAcePrincipalBased;
import org.apache.sling.repoinit.parser.operations.RemoveAcePrincipals;
import org.apache.sling.repoinit.parser.operations.RestrictionClause;
import org.apache.sling.repoinit.parser.operations.SetAclPaths;
import org.apache.sling.repoinit.parser.operations.SetAclPrincipalBased;
import org.apache.sling.repoinit.parser.operations.SetAclPrincipals;

class AclVisitor
extends DoNothingVisitor {
    public static final String OPTION_IGNORE_MISSING_PRINCIPAL = "ignoreMissingPrincipal";

    public AclVisitor(Session s) {
        super(s);
    }

    private void handleAclLine(AclLine line, Instruction instruction, List<String> principals, List<String> paths, List<String> options) throws RepositoryException {
        AclLine.Action action = line.getAction();
        if (action == AclLine.Action.REMOVE) {
            this.report("remove not supported. use 'remove acl' instead.");
        } else if (action == AclLine.Action.REMOVE_ALL) {
            AclUtil.removeEntries(this.session, principals, paths);
        } else {
            boolean isAllow = action == AclLine.Action.ALLOW;
            String actionName = isAllow ? "allow" : "deny";
            List privileges = line.getProperty("privileges");
            if (instruction == Instruction.SET) {
                this.log.info("Adding ACL '{}' entry '{}' for {} on {}", new Object[]{actionName, privileges, principals, paths});
                AclUtil.setAcl(this.session, principals, paths, (List<String>)privileges, isAllow, (List<RestrictionClause>)line.getRestrictions(), options);
            } else if (instruction == Instruction.REMOVE) {
                this.log.info("Removing ACL '{}' entry '{}' for {} on {}", new Object[]{actionName, privileges, principals, paths});
                AclUtil.removeEntries(this.session, principals, paths, privileges, isAllow, line.getRestrictions());
            }
        }
    }

    @Override
    public void visitSetAclPrincipal(SetAclPrincipals s) {
        List principals = s.getPrincipals();
        for (AclLine line : s.getLines()) {
            List<String> paths = line.getProperty("paths");
            boolean isRepositoryAcl = paths.isEmpty();
            paths = isRepositoryAcl ? Collections.singletonList(":repository") : paths;
            try {
                this.handleAclLine(line, Instruction.SET, principals, paths, s.getOptions());
            }
            catch (Exception e) {
                if (isRepositoryAcl) {
                    this.report(e, "Failed to set repository level ACL (" + e + ") " + line);
                    continue;
                }
                this.report(e, "Failed to set ACL (" + e + ") " + line);
            }
        }
    }

    @Override
    public void visitSetAclPaths(SetAclPaths s) {
        List paths = s.getPaths();
        for (AclLine line : s.getLines()) {
            try {
                this.handleAclLine(line, Instruction.SET, line.getProperty("principals"), paths, s.getOptions());
            }
            catch (Exception e) {
                this.report(e, "Failed to set ACL (" + e + ") " + line);
            }
        }
    }

    @Override
    public void visitSetAclPrincipalBased(SetAclPrincipalBased s) {
        for (String principalName : s.getPrincipals()) {
            try {
                this.log.info("Adding principal-based access control entry for {}", (Object)principalName);
                AclUtil.setPrincipalAcl(this.session, principalName, s.getLines(), false);
            }
            catch (Exception e) {
                this.report(e, "Failed to set principal-based ACL (" + e.getMessage() + ")");
            }
        }
    }

    @Override
    public void visitEnsureAclPrincipalBased(EnsureAclPrincipalBased s) {
        for (String principalName : s.getPrincipals()) {
            try {
                this.log.info("Enforcing principal-based access control entry for {}", (Object)principalName);
                AclUtil.setPrincipalAcl(this.session, principalName, s.getLines(), true);
            }
            catch (Exception e) {
                this.report(e, "Failed to set principal-based ACL (" + e.getMessage() + ")");
            }
        }
    }

    @Override
    public void visitRemoveAcePrincipal(RemoveAcePrincipals s) {
        List principals = s.getPrincipals();
        for (AclLine line : s.getLines()) {
            try {
                this.handleAclLine(line, Instruction.REMOVE, principals, line.getProperty("paths"), s.getOptions());
            }
            catch (Exception e) {
                this.report(e, "Failed to remove access control entries (" + e.toString() + ") " + line);
            }
        }
    }

    @Override
    public void visitRemoveAcePaths(RemoveAcePaths s) {
        List paths = s.getPaths();
        for (AclLine line : s.getLines()) {
            try {
                this.handleAclLine(line, Instruction.REMOVE, line.getProperty("principals"), paths, s.getOptions());
            }
            catch (Exception e) {
                this.report(e, "Failed to remove access control entries (" + e.toString() + ") " + line);
            }
        }
    }

    @Override
    public void visitRemoveAcePrincipalBased(RemoveAcePrincipalBased s) {
        for (String principalName : s.getPrincipals()) {
            try {
                this.log.info("Removing principal-based access control entries for {}", (Object)principalName);
                AclUtil.removePrincipalEntries(this.session, principalName, s.getLines());
            }
            catch (Exception e) {
                this.report(e, "Failed to remove principal-based access control entries (" + e.getMessage() + ")");
            }
        }
    }

    @Override
    public void visitDeleteAclPrincipals(DeleteAclPrincipals s) {
        for (String principalName : s.getPrincipals()) {
            try {
                this.log.info("Removing access control policy for {}", (Object)principalName);
                AclUtil.removePolicy(this.session, principalName);
            }
            catch (RepositoryException e) {
                this.report((Exception)((Object)e), "Failed to remove ACL (" + e.getMessage() + ")");
            }
        }
    }

    @Override
    public void visitDeleteAclPaths(DeleteAclPaths s) {
        try {
            AclUtil.removePolicies(this.session, s.getPaths());
        }
        catch (RepositoryException e) {
            this.report((Exception)((Object)e), "Failed to remove ACL (" + e.getMessage() + ")");
        }
    }

    @Override
    public void visitDeleteAclPrincipalBased(DeleteAclPrincipalBased s) {
        for (String principalName : s.getPrincipals()) {
            try {
                this.log.info("Removing principal-based access control policy for {}", (Object)principalName);
                AclUtil.removePrincipalPolicy(this.session, principalName);
            }
            catch (RepositoryException e) {
                this.report((Exception)((Object)e), "Failed to remove principal-based ACL (" + e.getMessage() + ")");
            }
        }
    }

    private static enum Instruction {
        SET,
        REMOVE;

    }
}

