/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.repoinit.impl;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.api.SlingRepositoryInitializer;
import org.apache.sling.jcr.repoinit.JcrRepoInitOpsProcessor;
import org.apache.sling.jcr.repoinit.impl.RepoInitException;
import org.apache.sling.jcr.repoinit.impl.RepoinitTextProvider;
import org.apache.sling.jcr.repoinit.impl.RetryableOperation;
import org.apache.sling.repoinit.parser.RepoInitParser;
import org.apache.sling.repoinit.parser.operations.Operation;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Designate(ocd=Config.class, factory=true)
@Component(service={SlingRepositoryInitializer.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"org.apache.sling.jcr.repoinit.RepositoryInitializer"}, property={"service.vendor=The Apache Software Foundation", "service.ranking:Integer=100"})
public class RepositoryInitializerFactory
implements SlingRepositoryInitializer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private RepoInitParser parser;
    @Reference
    private JcrRepoInitOpsProcessor processor;
    private Config config;

    @Activate
    public void activate(Config config) {
        this.config = config;
        this.log.debug("Activated: {}", (Object)this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", references=" + Arrays.toString(this.config.references()) + ", scripts=" + (this.config.scripts() != null ? this.config.scripts().length : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRepository(SlingRepository repo) throws Exception {
        block32: {
            if (this.config.references() != null && this.config.references().length > 0 || this.config.scripts() != null && this.config.scripts().length > 0) {
                Session s = repo.loginAdministrative(null);
                try {
                    if (this.config.references() != null) {
                        RepoinitTextProvider p = new RepoinitTextProvider();
                        String[] stringArray = this.config.references();
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            List ops;
                            String reference = stringArray[i];
                            if (reference == null || reference.trim().length() == 0) continue;
                            String repoinitText = p.getRepoinitText("raw:" + reference);
                            try (StringReader sr = new StringReader(repoinitText);){
                                ops = this.parser.parse((Reader)sr);
                            }
                            String msg = String.format("Executing %s repoinit operations", ops.size());
                            this.log.info(msg);
                            this.applyOperations(s, ops, msg);
                        }
                    }
                    if (this.config.scripts() == null) break block32;
                    for (String script : this.config.scripts()) {
                        List ops;
                        if (script == null || script.trim().length() == 0) continue;
                        try (StringReader sr = new StringReader(script);){
                            ops = this.parser.parse((Reader)sr);
                        }
                        String msg = String.format("Executing %s repoinit operations", ops.size());
                        this.log.info(msg);
                        this.applyOperations(s, ops, msg);
                    }
                }
                finally {
                    s.logout();
                }
            }
        }
    }

    protected void applyOperations(Session session, List<Operation> ops, String logMessage) throws RepositoryException {
        RetryableOperation retry = new RetryableOperation.Builder().withBackoffBaseMsec(1000).withMaxRetries(3).build();
        RetryableOperation.RetryableOperationResult result = this.applyOperationInternal(session, ops, logMessage, retry);
        if (!result.isSuccessful()) {
            String msg = String.format("Applying repoinit operation failed despite retry; set loglevel to DEBUG to see all exceptions. Last exception message was: %s", result.getFailureTrace().getMessage());
            throw new RepositoryException(msg, (Throwable)result.getFailureTrace());
        }
    }

    protected RetryableOperation.RetryableOperationResult applyOperationInternal(Session session, List<Operation> ops, String logMessage, RetryableOperation retry) {
        return retry.apply(() -> {
            try {
                this.processor.apply(session, ops);
                session.save();
                return new RetryableOperation.RetryableOperationResult(true, false, null);
            }
            catch (InvalidItemStateException | RepoInitException ex) {
                this.log.debug("(temporarily) failed to apply repoinit operations", ex);
                try {
                    session.refresh(false);
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
                return new RetryableOperation.RetryableOperationResult(false, true, (Exception)ex);
            }
            catch (RepositoryException ex) {
                try {
                    session.refresh(false);
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
                return new RetryableOperation.RetryableOperationResult(false, false, (Exception)((Object)ex));
            }
        }, logMessage);
    }

    @ObjectClassDefinition(name="Apache Sling Repository Initializer Factory", description="Initializes the JCR content repository using repoinit statements.")
    public static @interface Config {
        @AttributeDefinition(name="References", description="References to the source text that provides repoinit statements. format is a raw URL.")
        public String[] references() default {};

        @AttributeDefinition(name="Scripts", description="Contents of a repo init script.")
        public String[] scripts() default {};
    }
}

