/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.repoinit.impl;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Session;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.api.SlingRepositoryInitializer;
import org.apache.sling.jcr.repoinit.JcrRepoInitOpsProcessor;
import org.apache.sling.jcr.repoinit.impl.RepoinitTextProvider;
import org.apache.sling.repoinit.parser.RepoInitParser;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Designate(ocd=Config.class)
@Component(service={SlingRepositoryInitializer.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=The Apache Software Foundation", "service.ranking:Integer=100"})
public class RepositoryInitializer
implements SlingRepositoryInitializer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private RepoInitParser parser;
    @Reference
    private JcrRepoInitOpsProcessor processor;
    private Config config;

    @Activate
    public void activate(Config config) {
        this.config = config;
        this.log.debug("Activated: {}", (Object)this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", references=" + Arrays.toString(this.config.references());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRepository(SlingRepository repo) throws Exception {
        if (this.config.references() != null && this.config.references().length > 0) {
            Session s = repo.loginAdministrative(null);
            try {
                RepoinitTextProvider p = new RepoinitTextProvider();
                for (String reference : this.config.references()) {
                    List ops;
                    String repoinitText = p.getRepoinitText(reference);
                    try (StringReader sr = new StringReader(repoinitText);){
                        ops = this.parser.parse((Reader)sr);
                    }
                    this.log.info("Executing {} repoinit operations", (Object)ops.size());
                    this.processor.apply(s, ops);
                    s.save();
                }
            }
            finally {
                s.logout();
            }
        }
    }

    @ObjectClassDefinition(name="Apache Sling Repository Initializer", description="Initializes the JCR content repository using repoinit statements")
    public static @interface Config {
        @AttributeDefinition(name="Repoinit references", description="References to the source text that provides repoinit statements. format is either model@repoinit:<provisioning model URL> or raw:<raw URL>")
        public String[] references() default {};
    }
}

