/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.repoinit.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.value.BooleanValue;
import org.apache.jackrabbit.value.DateValue;
import org.apache.jackrabbit.value.DoubleValue;
import org.apache.jackrabbit.value.LongValue;
import org.apache.jackrabbit.value.StringValue;
import org.apache.sling.jcr.repoinit.impl.DoNothingVisitor;
import org.apache.sling.jcr.repoinit.impl.UserUtil;
import org.apache.sling.repoinit.parser.operations.PropertyLine;
import org.apache.sling.repoinit.parser.operations.SetProperties;
import org.jetbrains.annotations.NotNull;

class NodePropertiesVisitor
extends DoNothingVisitor {
    private static final String PATH_AUTHORIZABLE = ":authorizable:";
    private static final char ID_DELIMINATOR = ',';
    private static final char SUBTREE_DELIMINATOR = '#';

    public NodePropertiesVisitor(Session s) {
        super(s);
    }

    private static boolean needToSetProperty(Node n, PropertyLine line) throws RepositoryException {
        if (!line.isDefault()) {
            return true;
        }
        String name = line.getPropertyName();
        return !n.hasProperty(name) || n.getProperty(name) == null;
    }

    private static boolean needToSetProperty(Authorizable a, String pRelPath, boolean isDefault) throws RepositoryException {
        if (!isDefault) {
            return true;
        }
        return !a.hasProperty(pRelPath) || a.getProperty(pRelPath) == null;
    }

    private static String toRelPath(String subTreePath, String name) {
        String pRelPath;
        if (subTreePath == null || subTreePath.isEmpty()) {
            pRelPath = name;
        } else {
            if (subTreePath.startsWith("/")) {
                subTreePath = subTreePath.substring(1);
            }
            pRelPath = String.format("%s/%s", subTreePath, name);
        }
        return pRelPath;
    }

    @NotNull
    private static Iterable<Authorizable> getAuthorizables(@NotNull Session session, @NotNull String ids) throws RepositoryException {
        ArrayList<Authorizable> authorizables = new ArrayList<Authorizable>();
        for (String id : Text.explode((String)ids, (int)44)) {
            Authorizable a = UserUtil.getAuthorizable(session, id);
            if (a == null) {
                throw new PathNotFoundException("Cannot resolve path of authorizable with id '" + id + "'.");
            }
            authorizables.add(a);
        }
        return authorizables;
    }

    private void setAuthorizableProperties(String nodePath, List<PropertyLine> propertyLines) throws RepositoryException {
        int lastHashIndex = nodePath.lastIndexOf(35);
        if (lastHashIndex == -1) {
            throw new IllegalStateException("Invalid format of authorizable path: # deliminator expected.");
        }
        String ids = nodePath.substring(PATH_AUTHORIZABLE.length(), lastHashIndex);
        String subTreePath = nodePath.substring(lastHashIndex + 1);
        for (Authorizable a : NodePropertiesVisitor.getAuthorizables(this.session, ids)) {
            this.log.info("Setting properties on authorizable '{}'", (Object)a.getID());
            for (PropertyLine pl : propertyLines) {
                String pName = pl.getPropertyName();
                String pRelPath = NodePropertiesVisitor.toRelPath(subTreePath, pName);
                if (NodePropertiesVisitor.needToSetProperty(a, pRelPath, pl.isDefault())) {
                    List values = pl.getPropertyValues();
                    if (values.size() > 1) {
                        Value[] pValues = this.convertToValues(values);
                        a.setProperty(pRelPath, pValues);
                        continue;
                    }
                    Value pValue = this.convertToValue(values.get(0));
                    a.setProperty(pRelPath, pValue);
                    continue;
                }
                this.log.info("Property '{}' already set on authorizable '{}', existing value will not be overwritten in 'default' mode", (Object)pRelPath, (Object)a.getID());
            }
        }
    }

    private void setNodeProperties(String nodePath, List<PropertyLine> propertyLines) throws RepositoryException {
        this.log.info("Setting properties on nodePath '{}'", (Object)nodePath);
        Node n = this.session.getNode(nodePath);
        for (PropertyLine pl : propertyLines) {
            String pName = pl.getPropertyName();
            if (NodePropertiesVisitor.needToSetProperty(n, pl)) {
                PropertyLine.PropertyType pType = pl.getPropertyType();
                int type = PropertyType.valueFromName((String)pType.name());
                List values = pl.getPropertyValues();
                if (values.size() > 1) {
                    Value[] pValues = this.convertToValues(values);
                    n.setProperty(pName, pValues, type);
                    continue;
                }
                Value pValue = this.convertToValue(values.get(0));
                n.setProperty(pName, pValue, type);
                continue;
            }
            this.log.info("Property '{}' already set on path '{}', existing value will not be overwritten in 'default' mode", (Object)pName, (Object)nodePath);
        }
    }

    @Override
    public void visitSetProperties(SetProperties sp) {
        for (String nodePath : sp.getPaths()) {
            try {
                if (nodePath.startsWith(PATH_AUTHORIZABLE)) {
                    this.setAuthorizableProperties(nodePath, sp.getPropertyLines());
                    continue;
                }
                this.setNodeProperties(nodePath, sp.getPropertyLines());
            }
            catch (RepositoryException e) {
                this.report((Exception)((Object)e), "Unable to set properties on path [" + nodePath + "]:" + (Object)((Object)e));
            }
        }
    }

    private Value[] convertToValues(List<Object> values) {
        int size = values.size();
        Value[] valueArray = new Value[size];
        for (int i = 0; i < size; ++i) {
            valueArray[i] = this.convertToValue(values.get(i));
        }
        return valueArray;
    }

    private Value convertToValue(Object value) {
        StringValue convertedValue = null;
        if (value instanceof String) {
            convertedValue = new StringValue((String)value);
        } else if (value instanceof Double) {
            convertedValue = new DoubleValue((Double)value);
        } else if (value instanceof Long) {
            convertedValue = new LongValue((Long)value);
        } else if (value instanceof Boolean) {
            convertedValue = new BooleanValue((Boolean)value);
        } else if (value instanceof Calendar) {
            convertedValue = new DateValue((Calendar)value);
        } else {
            this.report("Unable to convert " + value + " to jcr Value");
        }
        return convertedValue;
    }
}

