/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.repoinit.impl;

import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.sling.jcr.repoinit.impl.AclUtil;
import org.apache.sling.jcr.repoinit.impl.DoNothingVisitor;
import org.apache.sling.repoinit.parser.operations.AclLine;
import org.apache.sling.repoinit.parser.operations.CreatePath;
import org.apache.sling.repoinit.parser.operations.DeleteAclPaths;
import org.apache.sling.repoinit.parser.operations.DeleteAclPrincipalBased;
import org.apache.sling.repoinit.parser.operations.DeleteAclPrincipals;
import org.apache.sling.repoinit.parser.operations.PathSegmentDefinition;
import org.apache.sling.repoinit.parser.operations.RemoveAcePaths;
import org.apache.sling.repoinit.parser.operations.RemoveAcePrincipalBased;
import org.apache.sling.repoinit.parser.operations.RemoveAcePrincipals;
import org.apache.sling.repoinit.parser.operations.RestrictionClause;
import org.apache.sling.repoinit.parser.operations.SetAclPaths;
import org.apache.sling.repoinit.parser.operations.SetAclPrincipalBased;
import org.apache.sling.repoinit.parser.operations.SetAclPrincipals;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AclVisitor
extends DoNothingVisitor {
    private static final Logger log = LoggerFactory.getLogger(AclVisitor.class);

    public AclVisitor(Session s) {
        super(s);
    }

    private List<String> require(AclLine line, String propertyName) {
        List result = line.getProperty(propertyName);
        if (result == null) {
            throw new IllegalStateException("Missing property " + propertyName + " on " + line);
        }
        return result;
    }

    private void setAcl(AclLine line, Session s, List<String> principals, List<String> paths, List<String> privileges, AclLine.Action action) {
        try {
            if (action == AclLine.Action.REMOVE) {
                this.report("remove not supported. use 'remove acl' instead.");
            } else if (action == AclLine.Action.REMOVE_ALL) {
                AclUtil.removeEntries(s, principals, paths);
            } else {
                boolean isAllow = line.getAction().equals((Object)AclLine.Action.ALLOW);
                log.info("Adding ACL '{}' entry '{}' for {} on {}", new Object[]{isAllow ? "allow" : "deny", privileges, principals, paths});
                List restrictions = line.getRestrictions();
                AclUtil.setAcl(s, principals, paths, privileges, isAllow, (List<RestrictionClause>)restrictions);
            }
        }
        catch (Exception e) {
            this.report(e, "Failed to set ACL (" + e.toString() + ") " + line);
        }
    }

    private void setRepositoryAcl(AclLine line, Session s, List<String> principals, List<String> privileges, AclLine.Action action) {
        try {
            if (action == AclLine.Action.REMOVE) {
                this.report("remove not supported. use 'remove acl' instead.");
            } else if (action == AclLine.Action.REMOVE_ALL) {
                AclUtil.removeEntries(s, principals, Collections.singletonList(null));
            } else {
                boolean isAllow = line.getAction().equals((Object)AclLine.Action.ALLOW);
                log.info("Adding repository level ACL '{}' entry '{}' for {}", new Object[]{isAllow ? "allow" : "deny", privileges, principals});
                List restrictions = line.getRestrictions();
                AclUtil.setRepositoryAcl(s, principals, privileges, isAllow, restrictions);
            }
        }
        catch (Exception e) {
            this.report(e, "Failed to set repository level ACL (" + e.toString() + ") " + line);
        }
    }

    @Override
    public void visitSetAclPrincipal(SetAclPrincipals s) {
        List principals = s.getPrincipals();
        for (AclLine line : s.getLines()) {
            List paths = line.getProperty("paths");
            if (paths != null && !paths.isEmpty()) {
                this.setAcl(line, this.session, principals, paths, this.require(line, "privileges"), line.getAction());
                continue;
            }
            this.setRepositoryAcl(line, this.session, principals, this.require(line, "privileges"), line.getAction());
        }
    }

    @Override
    public void visitSetAclPaths(SetAclPaths s) {
        List paths = s.getPaths();
        for (AclLine line : s.getLines()) {
            this.setAcl(line, this.session, this.require(line, "principals"), paths, this.require(line, "privileges"), line.getAction());
        }
    }

    @Override
    public void visitSetAclPrincipalBased(SetAclPrincipalBased s) {
        for (String principalName : s.getPrincipals()) {
            try {
                log.info("Adding principal-based access control entry for {}", (Object)principalName);
                AclUtil.setPrincipalAcl(this.session, principalName, s.getLines());
            }
            catch (Exception e) {
                this.report(e, "Failed to set principal-based ACL (" + e.getMessage() + ")");
            }
        }
    }

    @Override
    public void visitRemoveAcePrincipal(RemoveAcePrincipals s) {
        List principals = s.getPrincipals();
        for (AclLine line : s.getLines()) {
            List paths = line.getProperty("paths");
            try {
                AclUtil.removeEntries(this.session, principals, paths, this.require(line, "privileges"), line.getAction() == AclLine.Action.ALLOW, line.getRestrictions());
            }
            catch (Exception e) {
                this.report(e, "Failed to remove access control entries (" + e.toString() + ") " + line);
            }
        }
    }

    @Override
    public void visitRemoveAcePaths(RemoveAcePaths s) {
        List paths = s.getPaths();
        for (AclLine line : s.getLines()) {
            try {
                AclUtil.removeEntries(this.session, this.require(line, "principals"), paths, this.require(line, "privileges"), line.getAction() == AclLine.Action.ALLOW, line.getRestrictions());
            }
            catch (Exception e) {
                this.report(e, "Failed to remove access control entries (" + e.toString() + ") " + line);
            }
        }
    }

    @Override
    public void visitRemoveAcePrincipalBased(RemoveAcePrincipalBased s) {
        for (String principalName : s.getPrincipals()) {
            try {
                log.info("Removing principal-based access control entries for {}", (Object)principalName);
                AclUtil.removePrincipalEntries(this.session, principalName, s.getLines());
            }
            catch (Exception e) {
                this.report(e, "Failed to remove principal-based access control entries (" + e.getMessage() + ")");
            }
        }
    }

    @Override
    public void visitCreatePath(CreatePath cp) {
        String parentPath = "";
        for (PathSegmentDefinition psd : cp.getDefinitions()) {
            String fullPath = parentPath + "/" + psd.getSegment();
            try {
                if (this.session.itemExists(fullPath)) {
                    log.info("Path already exists, nothing to do (and not checking its primary type for now): {}", (Object)fullPath);
                } else {
                    Node parent = parentPath.equals("") ? this.session.getRootNode() : this.session.getNode(parentPath);
                    log.info("Creating node {} with primary type {}", (Object)fullPath, (Object)psd.getPrimaryType());
                    Node node = AclVisitor.addChildNode(parent, psd);
                    List mixins = psd.getMixins();
                    if (mixins != null) {
                        log.info("Adding mixins {} to node {}", (Object)mixins, (Object)fullPath);
                        for (String mixin : mixins) {
                            node.addMixin(mixin);
                        }
                    }
                }
            }
            catch (Exception e) {
                this.report(e, "CreatePath execution failed at " + psd + ": " + e);
            }
            parentPath = parentPath + "/" + psd.getSegment();
        }
        try {
            this.session.save();
        }
        catch (Exception e) {
            this.report(e, "Session.save failed: " + e);
        }
    }

    @NotNull
    private static Node addChildNode(@NotNull Node parent, @NotNull PathSegmentDefinition psd) throws RepositoryException {
        String primaryType = psd.getPrimaryType();
        if (primaryType == null) {
            try {
                return parent.addNode(psd.getSegment());
            }
            catch (ConstraintViolationException e) {
                log.info("Adding Node without node type failed ('{}'), retry with sling:Folder", (Object)e.getMessage());
                return parent.addNode(psd.getSegment(), "sling:Folder");
            }
        }
        return parent.addNode(psd.getSegment(), psd.getPrimaryType());
    }

    @Override
    public void visitDeleteAclPrincipals(DeleteAclPrincipals s) {
        for (String principalName : s.getPrincipals()) {
            try {
                log.info("Removing access control policy for {}", (Object)principalName);
                AclUtil.removePolicy(this.session, principalName);
            }
            catch (RepositoryException e) {
                this.report((Exception)((Object)e), "Failed to remove ACL (" + e.getMessage() + ")");
            }
        }
    }

    @Override
    public void visitDeleteAclPaths(DeleteAclPaths s) {
        try {
            AclUtil.removePolicies(this.session, s.getPaths());
        }
        catch (RepositoryException e) {
            this.report((Exception)((Object)e), "Failed to remove ACL (" + e.getMessage() + ")");
        }
    }

    @Override
    public void visitDeleteAclPrincipalBased(DeleteAclPrincipalBased s) {
        for (String principalName : s.getPrincipals()) {
            try {
                log.info("Removing principal-based access control policy for {}", (Object)principalName);
                AclUtil.removePrincipalPolicy(this.session, principalName);
            }
            catch (RepositoryException e) {
                this.report((Exception)((Object)e), "Failed to remove principal-based ACL (" + e.getMessage() + ")");
            }
        }
    }
}

