/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.repoinit.impl;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.jcr.repoinit.impl.DoNothingVisitor;
import org.apache.sling.jcr.repoinit.impl.UserUtil;
import org.apache.sling.repoinit.parser.operations.CreateGroup;
import org.apache.sling.repoinit.parser.operations.CreateServiceUser;
import org.apache.sling.repoinit.parser.operations.CreateUser;
import org.apache.sling.repoinit.parser.operations.DeleteGroup;
import org.apache.sling.repoinit.parser.operations.DeleteServiceUser;
import org.apache.sling.repoinit.parser.operations.DeleteUser;
import org.apache.sling.repoinit.parser.operations.DisableServiceUser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UserVisitor
extends DoNothingVisitor {
    public UserVisitor(Session s) {
        super(s);
    }

    @Override
    public void visitCreateServiceUser(CreateServiceUser s) {
        String username = s.getUsername();
        try {
            UserManager userManager = UserUtil.getUserManager(this.session);
            User user = (User)userManager.getAuthorizable(username, User.class);
            UserVisitor.checkUserType(username, user, true);
            if (user == null || s.isForcedPath() && this.needsRecreate(username, (Authorizable)user, s.getPath(), "Service user")) {
                this.log.info("Creating service user {}", (Object)username);
                userManager.createSystemUser(username, s.getPath());
            }
        }
        catch (Exception e) {
            this.report(e, "Unable to create service user [" + username + "]:" + e);
        }
    }

    @Override
    public void visitDeleteServiceUser(DeleteServiceUser s) {
        String username = s.getUsername();
        this.log.info("Deleting service user {}", (Object)username);
        try {
            UserUtil.deleteAuthorizable(this.session, username);
        }
        catch (Exception e) {
            this.report(e, "Unable to delete service user [" + username + "]:" + e);
        }
    }

    @Override
    public void visitCreateGroup(CreateGroup g) {
        String groupname = g.getGroupname();
        try {
            UserManager userManager = UserUtil.getUserManager(this.session);
            Group group = (Group)userManager.getAuthorizable(groupname, Group.class);
            String intermediatePath = g.getPath();
            if (group == null || g.isForcedPath() && this.needsRecreate(groupname, (Authorizable)group, intermediatePath, "Group")) {
                this.log.info("Creating group {}", (Object)groupname);
                if (intermediatePath == null) {
                    userManager.createGroup(groupname);
                } else {
                    userManager.createGroup(() -> groupname, intermediatePath);
                }
            }
        }
        catch (Exception e) {
            this.report(e, "Unable to create group [" + groupname + "]:" + e);
        }
    }

    @Override
    public void visitDeleteGroup(DeleteGroup g) {
        String groupname = g.getGroupname();
        this.log.info("Deleting group {}", (Object)groupname);
        try {
            if (!UserUtil.deleteAuthorizable(this.session, groupname)) {
                this.log.debug("Group {} doesn't exist - assuming delete to be a noop.", (Object)groupname);
            }
        }
        catch (Exception e) {
            this.report(e, "Unable to delete group [" + groupname + "]:" + e);
        }
    }

    @Override
    public void visitCreateUser(CreateUser u) {
        String username = u.getUsername();
        try {
            UserManager userManager = UserUtil.getUserManager(this.session);
            User user = (User)userManager.getAuthorizable(username, User.class);
            UserVisitor.checkUserType(username, user, false);
            if (user == null || u.isForcedPath() && this.needsRecreate(username, (Authorizable)user, u.getPath(), "User")) {
                String pwd = u.getPassword();
                if (pwd != null) {
                    this.log.warn("Creating user {} with cleartext password - should NOT be used on production systems", (Object)username);
                } else {
                    this.log.info("Creating user {}", (Object)username);
                }
                UserUtil.createUser(this.session, username, pwd, u.getPath());
            }
        }
        catch (Exception e) {
            this.report(e, "Unable to create user [" + username + "]:" + e);
        }
    }

    @Override
    public void visitDeleteUser(DeleteUser u) {
        String username = u.getUsername();
        this.log.info("Deleting user {}", (Object)username);
        try {
            if (!UserUtil.deleteAuthorizable(this.session, username)) {
                this.log.debug("User {} doesn't exist - assuming delete to be a noop.", (Object)username);
            }
        }
        catch (Exception e) {
            this.report(e, "Unable to delete user [" + username + "]:" + e);
        }
    }

    @Override
    public void visitDisableServiceUser(DisableServiceUser dsu) {
        String username = dsu.getUsername();
        String reason = dsu.getReason();
        this.log.info("Disabling service user {} reason {}", (Object)username, (Object)reason);
        try {
            if (!UserUtil.disableUser(this.session, username, reason)) {
                this.log.debug("Service user {} doesn't exist - assuming disable to be a noop.", (Object)username);
            }
        }
        catch (Exception e) {
            this.report(e, "Unable to disable service user [" + username + "]:" + e);
        }
    }

    private static void checkUserType(@NotNull String id, @Nullable User user, boolean expectedSystemUser) {
        if (user != null && user.isSystemUser() != expectedSystemUser) {
            String msg = expectedSystemUser ? "Existing user %s is not a service user." : "Existing user %s is a service user.";
            throw new RuntimeException(String.format(msg, id));
        }
    }

    private boolean needsRecreate(@NotNull String id, @NotNull Authorizable authorizable, @NotNull String intermediatePath, @NotNull String type) throws RepositoryException {
        String path = UserUtil.getPath(authorizable);
        if (path != null) {
            String requiredIntermediate = intermediatePath + "/";
            if (!path.contains(requiredIntermediate)) {
                this.log.info("Recreating {} '{}' with path '{}' to match required intermediate path '{}'", new Object[]{type, id, path, intermediatePath});
                authorizable.remove();
                return true;
            }
            this.log.info("{} '{}' already exists with required intermediate path '{}', no changes made.", new Object[]{type, id, intermediatePath});
        } else {
            this.log.error("{} '{}' already exists but path cannot be determined, no changes made.", (Object)type, (Object)id);
        }
        return false;
    }
}

