/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.resource;

import java.util.ArrayList;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.sling.jackrabbit.usermanager.impl.resource.BaseAuthorizableValueMap;
import org.apache.sling.jackrabbit.usermanager.resource.SystemUserManagerPaths;

public class AuthorizableValueMap
extends BaseAuthorizableValueMap {
    private static final String DECLARED_MEMBERS_KEY = "declaredMembers";
    private static final String MEMBERS_KEY = "members";
    private static final String DECLARED_MEMBER_OF_KEY = "declaredMemberOf";
    private static final String MEMBER_OF_KEY = "memberOf";
    private static final String PATH_KEY = "path";

    public AuthorizableValueMap(Authorizable authorizable, SystemUserManagerPaths systemUserManagerPaths) {
        super(authorizable, systemUserManagerPaths);
    }

    @Override
    protected Object read(String key) {
        Object value = null;
        if (!this.fullyRead) {
            try {
                if (key.equals(MEMBERS_KEY) && this.authorizable.isGroup()) {
                    value = this.getMembers((Group)this.authorizable, true);
                } else if (key.equals(DECLARED_MEMBERS_KEY) && this.authorizable.isGroup()) {
                    value = this.getMembers((Group)this.authorizable, false);
                } else if (key.equals(MEMBER_OF_KEY)) {
                    value = this.getMemberships(true);
                } else if (key.equals(DECLARED_MEMBER_OF_KEY)) {
                    value = this.getMemberships(false);
                } else if (key.equals(PATH_KEY)) {
                    value = this.getPath();
                } else if (this.authorizable.hasProperty(key)) {
                    value = this.readPropertyAndCache(key, key);
                }
            }
            catch (RepositoryException re) {
                this.log.error("Could not access authorizable property", (Throwable)re);
            }
        }
        return value;
    }

    @Override
    protected void readFully() {
        if (!this.fullyRead) {
            try {
                if (this.authorizable.isGroup()) {
                    this.cache.put(MEMBERS_KEY, this.getMembers((Group)this.authorizable, true));
                    this.cache.put(DECLARED_MEMBERS_KEY, this.getMembers((Group)this.authorizable, false));
                }
                this.cache.put(MEMBER_OF_KEY, this.getMemberships(true));
                this.cache.put(DECLARED_MEMBER_OF_KEY, this.getMemberships(false));
                String path = this.getPath();
                if (path != null) {
                    this.cache.put(PATH_KEY, path);
                }
                Iterator pi = this.authorizable.getPropertyNames();
                while (pi.hasNext()) {
                    String key = (String)pi.next();
                    if (this.cache.containsKey(key)) continue;
                    this.readPropertyAndCache(key, key);
                }
                this.fullyRead = true;
            }
            catch (RepositoryException re) {
                this.log.error("Could not access certain properties of user {}", (Object)this.authorizable, (Object)re);
            }
        }
    }

    private String[] getMembers(Group group, boolean includeAll) throws RepositoryException {
        Iterator it;
        ArrayList<String> results = new ArrayList<String>();
        Iterator iterator = it = includeAll ? group.getMembers() : group.getDeclaredMembers();
        while (it.hasNext()) {
            Authorizable auth = (Authorizable)it.next();
            if (auth.isGroup()) {
                results.add(this.systemUserManagerPaths.getGroupPrefix() + auth.getID());
                continue;
            }
            results.add(this.systemUserManagerPaths.getUserPrefix() + auth.getID());
        }
        return results.toArray(new String[results.size()]);
    }

    private String[] getMemberships(boolean includeAll) throws RepositoryException {
        Iterator it;
        ArrayList<String> results = new ArrayList<String>();
        Iterator iterator = it = includeAll ? this.authorizable.memberOf() : this.authorizable.declaredMemberOf();
        while (it.hasNext()) {
            Group group = (Group)it.next();
            results.add(this.systemUserManagerPaths.getGroupPrefix() + group.getID());
        }
        return results.toArray(new String[results.size()]);
    }

    private String getPath() throws RepositoryException {
        try {
            return this.authorizable.getPath();
        }
        catch (UnsupportedRepositoryOperationException e) {
            this.log.debug("Could not retrieve path of authorizable {}", (Object)this.authorizable, (Object)e);
            return null;
        }
    }
}

