/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.post;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jackrabbit.usermanager.UpdateGroup;
import org.apache.sling.jackrabbit.usermanager.impl.post.AbstractGroupPostServlet;
import org.apache.sling.jackrabbit.usermanager.resource.SystemUserManagerPaths;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.PostResponseCreator;
import org.apache.sling.servlets.post.impl.helper.RequestProperty;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={Servlet.class, UpdateGroup.class}, property={"sling.servlet.resourceTypes=sling/group", "sling.servlet.methods=POST", "sling.servlet.selectors=update", "sling.servlet.prefix:Integer=-1", "servlet.post.dateFormats=EEE MMM dd yyyy HH:mm:ss 'GMT'Z", "servlet.post.dateFormats=yyyy-MM-dd'T'HH:mm:ss.SSSZ", "servlet.post.dateFormats=yyyy-MM-dd'T'HH:mm:ss", "servlet.post.dateFormats=yyyy-MM-dd", "servlet.post.dateFormats=dd.MM.yyyy HH:mm:ss", "servlet.post.dateFormats=dd.MM.yyyy"})
public class UpdateGroupServlet
extends AbstractGroupPostServlet
implements UpdateGroup {
    private static final long serialVersionUID = -8292054361992488797L;
    @Reference
    private transient ResourceResolverFactory resourceResolverFactory;

    @Override
    @Activate
    protected void activate(Map<String, Object> props) {
        super.activate(props);
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    @Override
    @Reference
    protected void bindSystemUserManagerPaths(SystemUserManagerPaths sump) {
        super.bindSystemUserManagerPaths(sump);
    }

    @Override
    @Reference(service=PostResponseCreator.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        super.bindPostResponseCreator(creator, properties);
    }

    @Override
    protected void unbindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        super.unbindPostResponseCreator(creator, properties);
    }

    @Override
    protected void handleOperation(SlingHttpServletRequest request, PostResponse response, List<Modification> changes) throws RepositoryException {
        Resource resource = request.getResource();
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        this.updateGroup(session, resource.getName(), (Map<String, ?>)request.getRequestParameterMap(), changes);
    }

    @Override
    public Group updateGroup(Session jcrSession, String name, Map<String, ?> properties, List<Modification> changes) throws RepositoryException {
        Group group = null;
        UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
        Authorizable authorizable = userManager.getAuthorizable(name);
        if (!(authorizable instanceof Group)) {
            throw new ResourceNotFoundException("Group to update could not be determined");
        }
        group = (Group)authorizable;
        String groupPath = this.systemUserManagerPaths.getGroupPrefix() + group.getID();
        Map<String, RequestProperty> reqPropertiesMap = this.collectContentMap(properties);
        Collection<RequestProperty> reqPropertyValues = reqPropertiesMap.values();
        try (ResourceResolver resourceResolver = this.resourceResolverFactory.getResourceResolver(Collections.singletonMap("user.jcr.session", jcrSession));){
            this.processDeletes((Authorizable)group, reqPropertyValues, changes);
            this.processCreate(jcrSession, (Authorizable)group, reqPropertiesMap, changes);
            this.writeContent(jcrSession, (Authorizable)group, reqPropertyValues, changes);
            Resource baseResource = resourceResolver.getResource(groupPath);
            this.updateGroupMembership(baseResource, properties, (Authorizable)group, changes);
        }
        catch (RepositoryException | LoginException re) {
            throw new RepositoryException("Failed to update group.", re);
        }
        return group;
    }
}

