/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.post;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.jackrabbit.usermanager.PrincipalNameFilter;
import org.apache.sling.jackrabbit.usermanager.PrincipalNameGenerator;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPid={"org.apache.sling.jackrabbit.usermanager.PrincipalNameGenerator"}, service={PrincipalNameGenerator.class})
@Designate(ocd=Config.class)
public class PrincipalNameGeneratorImpl
implements PrincipalNameGenerator {
    private String[] parameterNames;
    public static final int DEFAULT_MAX_NAME_LENGTH = 20;
    private int maxLength = 20;

    public PrincipalNameGeneratorImpl() {
        this(null, -1);
    }

    public PrincipalNameGeneratorImpl(String[] parameterNames, int maxNameLength) {
        this.parameterNames = parameterNames == null ? new String[0] : parameterNames;
        this.maxLength = maxNameLength > 0 ? maxNameLength : 20;
    }

    @Activate
    protected void activate(Config config) {
        this.maxLength = config.principalNameMaxLength();
        this.parameterNames = config.principalNameHints();
    }

    @NotNull
    protected List<String> valueToList(Object value) {
        List<String> valuesList;
        if (value instanceof String[]) {
            valuesList = Arrays.asList((String[])value);
        } else if (value instanceof String) {
            valuesList = Collections.singletonList((String)value);
        } else if (value instanceof RequestParameter[]) {
            valuesList = new ArrayList<String>();
            for (RequestParameter rp : (RequestParameter[])value) {
                valuesList.add(rp.getString());
            }
        } else {
            valuesList = Collections.emptyList();
        }
        return valuesList;
    }

    protected String getValueToUse(Map<String, ?> parameters, String paramName) {
        String valueToUse;
        block6: {
            List<String> values;
            block7: {
                valueToUse = null;
                values = this.valueToList(parameters.get(paramName));
                if (values.isEmpty()) break block7;
                for (String specialParam : values) {
                    if (specialParam != null && !specialParam.isEmpty()) {
                        valueToUse = specialParam;
                    }
                    if (valueToUse == null) continue;
                    if (valueToUse.isEmpty()) {
                        valueToUse = null;
                        continue;
                    }
                    break block6;
                }
                break block6;
            }
            values = this.valueToList(parameters.get(String.format("%s%s", paramName, "@ValueFrom")));
            if (values.isEmpty()) break block6;
            for (String specialParam : values) {
                List<String> refValues;
                if (specialParam != null && !specialParam.isEmpty() && (refValues = this.valueToList(parameters.get(specialParam))).size() == 1 && (specialParam = refValues.get(0)) != null && !specialParam.isEmpty()) {
                    valueToUse = specialParam;
                }
                if (valueToUse == null) continue;
                if (valueToUse.isEmpty()) {
                    valueToUse = null;
                    continue;
                }
                break;
            }
        }
        return valueToUse;
    }

    @Override
    public PrincipalNameGenerator.NameInfo getPrincipalName(Map<String, ?> parameters, AuthorizableType type, PrincipalNameFilter principalNameFilter, PrincipalNameGenerator defaultPrincipalNameGenerator) {
        String valueToUse = null;
        boolean doFilter = true;
        valueToUse = this.getValueToUse(parameters, ":name");
        if (valueToUse != null) {
            doFilter = false;
        }
        if (valueToUse == null && (valueToUse = this.getValueToUse(parameters, ":nameHint")) == null && this.parameterNames != null) {
            String param;
            String[] stringArray = this.parameterNames;
            int n = stringArray.length;
            for (int i = 0; i < n && (valueToUse = this.getValueToUse(parameters, param = stringArray[i])) == null; ++i) {
            }
        }
        String result = valueToUse;
        if (doFilter && result != null && principalNameFilter != null) {
            result = principalNameFilter.filter(result);
        }
        if (doFilter && result != null && result.length() > this.maxLength) {
            result = result.substring(0, this.maxLength);
        }
        if (result != null) {
            return new PrincipalNameGenerator.NameInfo(result, doFilter);
        }
        return null;
    }

    @ObjectClassDefinition(name="Apache Sling Principal Name Generator", description="The Sling helper to generate a principal name from a hint")
    public static @interface Config {
        @AttributeDefinition(name="Maximum Principal Name Length", description="Maximum number of characters to use for automatically generated principal names. The default value is 20. Note, that actual principal names may be generated with at most 4 more characters if numeric suffixes must be appended to make the name unique.")
        public int principalNameMaxLength() default 20;

        @AttributeDefinition(name="Principal Name Hint Properties", description="The list of properties whose values may be used to derive a name for newly created principal. When handling a request to create a new principal, the name is automatically generated from this set if no \":name\" or \":nameHint\" property is provided. In this case the request parameters listed in this configuration value may be used as a hint to create the name.")
        public String[] principalNameHints();
    }
}

