/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.InconsistentVersioningState;
import org.apache.jackrabbit.core.version.InternalActivityImpl;
import org.apache.jackrabbit.core.version.InternalBaselineImpl;
import org.apache.jackrabbit.core.version.InternalFrozenNodeImpl;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionImpl;
import org.apache.jackrabbit.core.version.InternalVersionItem;
import org.apache.jackrabbit.core.version.InternalVersionItemImpl;
import org.apache.jackrabbit.core.version.InternalVersionManagerBase;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InternalVersionHistoryImpl
extends InternalVersionItemImpl
implements InternalVersionHistory {
    private static Logger log = LoggerFactory.getLogger(InternalVersionHistoryImpl.class);
    private static final Calendar CURRENT_TIME = Calendar.getInstance();
    private Map<Name, Name> labelCache = new HashMap<Name, Name>();
    private InternalVersion rootVersion;
    private Map<Name, NodeId> nameCache = new LinkedHashMap<Name, NodeId>();
    private Map<NodeId, InternalVersion> versionCache = new HashMap<NodeId, InternalVersion>();
    private Map<NodeId, InternalVersion> tempVersionCache = new HashMap<NodeId, InternalVersion>();
    private NodeStateEx labelNode;
    private NodeId historyId;
    private NodeId versionableId;

    public InternalVersionHistoryImpl(InternalVersionManagerBase vMgr, NodeStateEx node) throws RepositoryException {
        super(vMgr, node);
        this.init();
        this.fixLegacy();
    }

    private synchronized void init() throws RepositoryException {
        this.nameCache.clear();
        this.versionCache.clear();
        this.labelCache.clear();
        this.historyId = this.node.getNodeId();
        this.versionableId = NodeId.valueOf(this.node.getPropertyValue(NameConstants.JCR_VERSIONABLEUUID).toString());
        this.labelNode = this.node.getNode(NameConstants.JCR_VERSIONLABELS, 1);
        try {
            PropertyState[] labels;
            for (PropertyState pState : labels = this.labelNode.getProperties()) {
                if (pState.getType() != 9) continue;
                Name labelName = pState.getName();
                NodeId id = pState.getValues()[0].getNodeId();
                if (this.node.getState().hasChildNodeEntry(id)) {
                    this.labelCache.put(labelName, this.node.getState().getChildNodeEntry(id).getName());
                    continue;
                }
                log.warn("Error while resolving label reference. Version missing: " + id);
            }
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
        this.rootVersion = this.createVersionInstance(NameConstants.JCR_ROOTVERSION);
        for (ChildNodeEntry child : this.node.getState().getChildNodeEntries()) {
            if (child.getName().equals(NameConstants.JCR_VERSIONLABELS)) continue;
            this.nameCache.put(child.getName(), child.getId());
        }
    }

    private void fixLegacy() throws RepositoryException {
        if (this.rootVersion.getSuccessors().isEmpty()) {
            for (Name versionName : this.nameCache.keySet()) {
                InternalVersionImpl v = this.createVersionInstance(versionName);
                v.legacyResolveSuccessors();
            }
        }
    }

    synchronized void reload() throws RepositoryException {
        this.tempVersionCache.putAll(this.versionCache);
        this.init();
        for (InternalVersion o : this.tempVersionCache.values()) {
            InternalVersionImpl v = (InternalVersionImpl)o;
            v.invalidate();
        }
        this.tempVersionCache.clear();
    }

    synchronized InternalVersionImpl createVersionInstance(Name name) {
        try {
            NodeStateEx nodeStateEx = this.node.getNode(name, 1);
            InternalVersionImpl v = this.createVersionInstance(nodeStateEx);
            this.versionCache.put(v.getId(), v);
            this.vMgr.versionCreated(v);
            for (Name labelName : this.labelCache.keySet()) {
                Name versionName = this.labelCache.get(labelName);
                if (!v.getName().equals(versionName)) continue;
                v.internalAddLabel(labelName);
            }
            return v;
        }
        catch (RepositoryException e) {
            throw new InconsistentVersioningState("Failed to create version " + name + " in VHR " + this.historyId + ".", this.historyId, null);
        }
    }

    synchronized InternalVersionImpl createVersionInstance(NodeStateEx child) {
        InternalVersionImpl v = (InternalVersionImpl)this.tempVersionCache.remove(child.getNodeId());
        if (v != null) {
            v.clear();
        } else {
            try {
                NodeStateEx frozen = child.getNode(NameConstants.JCR_FROZENNODE, 1);
                Name frozenType = frozen.getPropertyValue(NameConstants.JCR_FROZENPRIMARYTYPE).getName();
                v = NameConstants.NT_CONFIGURATION.equals(frozenType) ? new InternalBaselineImpl(this, child, child.getName()) : new InternalVersionImpl(this, child, child.getName());
            }
            catch (RepositoryException e) {
                throw new InconsistentVersioningState("Version does not have a jcr:frozenNode: " + child.getNodeId(), this.historyId, e);
            }
        }
        return v;
    }

    @Override
    public NodeId getId() {
        return this.historyId;
    }

    @Override
    public InternalVersionItem getParent() {
        return null;
    }

    @Override
    public InternalVersion getRootVersion() {
        return this.rootVersion;
    }

    @Override
    public synchronized InternalVersion getVersion(Name versionName) throws VersionException {
        NodeId versionId = this.nameCache.get(versionName);
        if (versionId == null) {
            throw new VersionException("Version " + versionName + " does not exist.");
        }
        InternalVersion v = this.versionCache.get(versionId);
        if (v == null) {
            v = this.createVersionInstance(versionName);
        }
        return v;
    }

    @Override
    public synchronized boolean hasVersion(Name versionName) {
        return this.nameCache.containsKey(versionName);
    }

    @Override
    public InternalVersion getVersion(NodeId id) {
        InternalVersion v = this.getCachedVersion(id);
        if (v == null) {
            try {
                this.reload();
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
            v = this.getCachedVersion(id);
        }
        return v;
    }

    private synchronized InternalVersion getCachedVersion(NodeId id) {
        InternalVersion v = this.versionCache.get(id);
        if (v == null) {
            for (Name versionName : this.nameCache.keySet()) {
                if (!this.nameCache.get(versionName).equals(id)) continue;
                v = this.createVersionInstance(versionName);
                break;
            }
        }
        return v;
    }

    @Override
    public synchronized InternalVersion getVersionByLabel(Name label) {
        Name versionName = this.labelCache.get(label);
        if (versionName == null) {
            return null;
        }
        NodeId id = this.nameCache.get(versionName);
        InternalVersion v = this.versionCache.get(id);
        if (v == null) {
            v = this.createVersionInstance(versionName);
        }
        return v;
    }

    @Override
    public synchronized Name[] getVersionNames() {
        return this.nameCache.keySet().toArray(new Name[this.nameCache.size()]);
    }

    @Override
    public synchronized int getNumVersions() {
        return this.nameCache.size();
    }

    @Override
    public NodeId getVersionableId() {
        return this.versionableId;
    }

    @Override
    public synchronized Name[] getVersionLabels() {
        return this.labelCache.keySet().toArray(new Name[this.labelCache.size()]);
    }

    @Override
    public NodeId getVersionLabelsId() {
        return this.labelNode.getNodeId();
    }

    synchronized void removeVersion(Name versionName) throws RepositoryException {
        Name[] labels;
        InternalVersionImpl v = (InternalVersionImpl)this.getVersion(versionName);
        if (v.equals(this.rootVersion)) {
            String msg = "Removal of " + versionName + " not allowed.";
            log.debug(msg);
            throw new VersionException(msg);
        }
        if (this.vMgr.hasItemReferences(v.getId())) {
            throw new ReferentialIntegrityException("Unable to remove version. At least once referenced.");
        }
        for (Name label : labels = v.internalGetLabels()) {
            v.internalRemoveLabel(label);
            this.labelNode.removeProperty(label);
        }
        v.internalDetach();
        InternalActivityImpl activity = v.getActivity();
        if (activity != null) {
            activity.removeVersion(v);
        }
        this.node.removeNode(v.getName());
        this.versionCache.remove(v.getId());
        this.nameCache.remove(versionName);
        this.vMgr.versionDestroyed(v);
        if (!this.vMgr.hasItemReferences(this.node.getNodeId())) {
            log.debug("Current version history has no references");
            NodeStateEx[] childNodes = this.node.getChildNodes();
            if (childNodes.length == 2) {
                log.debug("Removing orphan version history as it contains only two children");
                NodeStateEx parentNode = this.node.getParent();
                parentNode.removeNode(this.node.getName());
                parentNode.store();
            } else {
                this.node.store();
            }
        } else {
            log.debug("Current version history has at least one reference");
            this.node.store();
        }
        for (Name label : labels) {
            this.labelCache.remove(label);
        }
    }

    synchronized InternalVersion setVersionLabel(Name versionName, Name label, boolean move) throws VersionException {
        InternalVersion version;
        InternalVersion internalVersion = version = versionName != null ? this.getVersion(versionName) : null;
        if (versionName != null && version == null) {
            throw new VersionException("Version " + versionName + " does not exist in this version history.");
        }
        Name prevName = this.labelCache.get(label);
        InternalVersionImpl prev = null;
        if (prevName == null) {
            if (version == null) {
                return null;
            }
        } else {
            prev = (InternalVersionImpl)this.getVersion(prevName);
            if (prev.equals(version)) {
                return version;
            }
            if (!move) {
                throw new VersionException("Version label " + label + " already defined for version " + prev.getName());
            }
        }
        try {
            if (version == null) {
                this.labelNode.removeProperty(label);
            } else {
                this.labelNode.setPropertyValue(label, InternalValue.create(version.getId()));
            }
            this.labelNode.store();
        }
        catch (RepositoryException e) {
            throw new VersionException((Throwable)e);
        }
        if (prev != null) {
            prev.internalRemoveLabel(label);
            this.labelCache.remove(label);
        }
        if (version != null) {
            this.labelCache.put(label, version.getName());
            ((InternalVersionImpl)version).internalAddLabel(label);
        }
        return prev;
    }

    synchronized InternalVersionImpl checkin(Name name, NodeStateEx src, Calendar created) throws RepositoryException {
        InternalValue[] predecessors;
        if (src.hasProperty(NameConstants.JCR_PREDECESSORS)) {
            for (InternalValue pred : predecessors = src.getPropertyValues(NameConstants.JCR_PREDECESSORS)) {
                NodeId predId = pred.getNodeId();
                if (this.nameCache.containsValue(predId)) continue;
                throw new RepositoryException("Invalid predecessor in source node: " + predId);
            }
        } else {
            Iterator<NodeId> iter = this.nameCache.values().iterator();
            NodeId last = null;
            while (iter.hasNext()) {
                last = iter.next();
            }
            if (last == null) {
                last = this.rootVersion.getId();
            }
            predecessors = new InternalValue[]{InternalValue.create(last)};
        }
        NodeId versionId = this.vMgr.getNodeIdFactory().newNodeId();
        NodeStateEx vNode = this.node.addNode(name, NameConstants.NT_VERSION, versionId, true);
        if (src.hasProperty(NameConstants.JCR_ACTIVITY)) {
            InternalValue act = src.getPropertyValue(NameConstants.JCR_ACTIVITY);
            vNode.setPropertyValue(NameConstants.JCR_ACTIVITY, act);
        }
        if (created == null) {
            created = InternalVersionHistoryImpl.getCurrentTime();
        }
        vNode.setPropertyValue(NameConstants.JCR_CREATED, InternalValue.create(created));
        vNode.setPropertyValues(NameConstants.JCR_PREDECESSORS, 9, predecessors);
        vNode.setPropertyValues(NameConstants.JCR_SUCCESSORS, 9, InternalValue.EMPTY_ARRAY);
        InternalFrozenNodeImpl.checkin(vNode, NameConstants.JCR_FROZENNODE, src);
        boolean isConfiguration = src.getEffectiveNodeType().includesNodeType(NameConstants.NT_CONFIGURATION);
        InternalVersionImpl version = isConfiguration ? new InternalBaselineImpl(this, vNode, name) : new InternalVersionImpl(this, vNode, name);
        version.internalAttach();
        this.node.store();
        this.vMgr.versionCreated(version);
        this.versionCache.put(version.getId(), version);
        this.nameCache.put(version.getName(), version.getId());
        return version;
    }

    static NodeStateEx create(InternalVersionManagerBase vMgr, NodeStateEx parent, Name name, NodeState nodeState, NodeId copiedFrom) throws RepositoryException {
        NodeId historyId = vMgr.getNodeIdFactory().newNodeId();
        NodeStateEx pNode = parent.addNode(name, NameConstants.NT_VERSIONHISTORY, historyId, true);
        String versionableUUID = nodeState.getNodeId().toString();
        pNode.setPropertyValue(NameConstants.JCR_VERSIONABLEUUID, InternalValue.create(versionableUUID));
        pNode.addNode(NameConstants.JCR_VERSIONLABELS, NameConstants.NT_VERSIONLABELS, null, false);
        if (copiedFrom != null) {
            pNode.setPropertyValue(NameConstants.JCR_COPIEDFROM, InternalValue.create(copiedFrom, true));
        }
        NodeId versionId = vMgr.getNodeIdFactory().newNodeId();
        NodeStateEx vNode = pNode.addNode(NameConstants.JCR_ROOTVERSION, NameConstants.NT_VERSION, versionId, true);
        vNode.setPropertyValue(NameConstants.JCR_CREATED, InternalValue.create(InternalVersionHistoryImpl.getCurrentTime()));
        vNode.setPropertyValues(NameConstants.JCR_PREDECESSORS, 9, InternalValue.EMPTY_ARRAY);
        vNode.setPropertyValues(NameConstants.JCR_SUCCESSORS, 9, InternalValue.EMPTY_ARRAY);
        NodeStateEx node = vNode.addNode(NameConstants.JCR_FROZENNODE, NameConstants.NT_FROZENNODE, null, true);
        node.setPropertyValue(NameConstants.JCR_FROZENUUID, InternalValue.create(versionableUUID));
        node.setPropertyValue(NameConstants.JCR_FROZENPRIMARYTYPE, InternalValue.create(nodeState.getNodeTypeName()));
        Set<Name> mixins = nodeState.getMixinTypeNames();
        if (!mixins.isEmpty()) {
            InternalValue[] ivalues = new InternalValue[mixins.size()];
            Iterator<Name> iter = mixins.iterator();
            for (int i = 0; i < mixins.size(); ++i) {
                ivalues[i] = InternalValue.create(iter.next());
            }
            node.setPropertyValues(NameConstants.JCR_FROZENMIXINTYPES, 7, ivalues);
        }
        parent.store(false);
        pNode.store(true);
        return pNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Calendar getCurrentTime() {
        long time = System.currentTimeMillis();
        Calendar calendar = CURRENT_TIME;
        synchronized (calendar) {
            if (time > CURRENT_TIME.getTimeInMillis()) {
                CURRENT_TIME.setTimeInMillis(time);
            } else {
                CURRENT_TIME.add(14, 1);
            }
            return (Calendar)CURRENT_TIME.clone();
        }
    }
}

