/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager.post;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import javax.servlet.Servlet;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.authorization.PrincipalAccessControlList;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.jcr.jackrabbit.accessmanager.LocalPrivilege;
import org.apache.sling.jcr.jackrabbit.accessmanager.LocalRestriction;
import org.apache.sling.jcr.jackrabbit.accessmanager.ModifyAce;
import org.apache.sling.jcr.jackrabbit.accessmanager.impl.PrivilegesHelper;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.AbstractAccessPostServlet;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.PostResponseCreator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={Servlet.class, ModifyAce.class}, property={"sling.servlet.resourceTypes=sling/servlet/default", "sling.servlet.methods=POST", "sling.servlet.selectors=modifyAce", "sling.servlet.prefix:Integer=-1"}, reference={@Reference(name="RestrictionProvider", bind="bindRestrictionProvider", cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY, service=RestrictionProvider.class), @Reference(name="PostResponseCreator", bind="bindPostResponseCreator", cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY, service=PostResponseCreator.class)})
public class ModifyAceServlet
extends AbstractAccessPostServlet
implements ModifyAce {
    private static final long serialVersionUID = -9182485466670280437L;
    private static final String INVALID_OR_NOT_SUPPORTED_RESTRICTION_NAME_WAS_SUPPLIED = "Invalid restriction name was supplied";
    private static final Pattern PRIVILEGE_PATTERN = Pattern.compile(String.format("^privilege@(.+)(?<!%s)$", "@Delete"));
    private static final Pattern PRIVILEGE_PATTERN_DELETE = Pattern.compile(String.format("^privilege@(.+)%s$", "@Delete"));
    private static final Pattern RESTRICTION_PATTERN = Pattern.compile("^restriction@([^@]+)(@([^@]+)@(Allow|Deny))?$");
    private static final Pattern RESTRICTION_PATTERN_DELETE = Pattern.compile(String.format("^restriction@([^@]+)(@([^@]+))?%s$", "@Delete"));

    @Override
    protected void handleOperation(SlingHttpServletRequest request, PostResponse response, List<Modification> changes) throws RepositoryException {
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        String resourcePath = this.getItemPath(request);
        String principalId = request.getParameter("principalId");
        String order = request.getParameter("order");
        Principal principal = this.validateArgs(session, resourcePath, principalId);
        Map<String, RestrictionDefinition> srMap = this.buildRestrictionNameToDefinitionMap(resourcePath);
        AccessControlManager acm = session.getAccessControlManager();
        Map<Privilege, Integer> privilegeLongestDepthMap = PrivilegesHelper.buildPrivilegeLongestDepthMap(acm.privilegeFromName("jcr:all"));
        Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap = this.loadStoredAce(acm, resourcePath, principal, srMap);
        this.processPostedPrivilegeDeleteParams(acm, request, privilegeToLocalPrivilegesMap);
        this.processPostedRestrictionDeleteParams(acm, request, srMap, privilegeToLocalPrivilegesMap);
        this.processPostedPrivilegeAndRestrictionParams(acm, request, srMap, privilegeToLocalPrivilegesMap, privilegeLongestDepthMap);
        PrivilegesHelper.consolidateAggregates(session, resourcePath, privilegeToLocalPrivilegesMap, privilegeLongestDepthMap);
        this.modifyAce(session, resourcePath, principalId, privilegeToLocalPrivilegesMap.values(), order, false, changes);
    }

    @NotNull
    protected Principal validateArgs(Session jcrSession, String resourcePath, String principalId) throws RepositoryException {
        if (jcrSession == null) {
            throw new RepositoryException("JCR Session not found");
        }
        if (RestrictionProvider.EMPTY.equals(this.getRestrictionProvider())) {
            throw new IllegalStateException("No restriction provider is available so unable to process POSTed restriction values");
        }
        if (principalId == null) {
            throw new RepositoryException("principalId was not submitted.");
        }
        PrincipalManager principalManager = ((JackrabbitSession)jcrSession).getPrincipalManager();
        Principal principal = principalManager.getPrincipal(principalId);
        if (principal == null) {
            throw new RepositoryException("Invalid principalId was submitted.");
        }
        this.validateResourcePath(jcrSession, resourcePath);
        AccessControlManager acm = jcrSession.getAccessControlManager();
        JackrabbitAccessControlList acl = this.getAcl(acm, resourcePath, principal);
        if (acl == null) {
            throw new IllegalStateException("No access control list is available so unable to process");
        }
        return principal;
    }

    @NotNull
    protected Map<String, RestrictionDefinition> buildRestrictionNameToDefinitionMap(@NotNull String resourcePath) {
        Set supportedRestrictions = this.getRestrictionProvider().getSupportedRestrictions(resourcePath);
        HashMap<String, RestrictionDefinition> srMap = new HashMap<String, RestrictionDefinition>();
        for (RestrictionDefinition restrictionDefinition : supportedRestrictions) {
            srMap.put(restrictionDefinition.getName(), restrictionDefinition);
        }
        return srMap;
    }

    @NotNull
    protected Map<Privilege, LocalPrivilege> loadStoredAce(@NotNull AccessControlManager acm, @NotNull String resourcePath, @NotNull Principal forPrincipal, @NotNull Map<String, RestrictionDefinition> srMap) throws RepositoryException {
        AccessControlEntry[] accessControlEntries;
        HashMap<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap = new HashMap<Privilege, LocalPrivilege>();
        JackrabbitAccessControlList acl = this.getAcl(acm, resourcePath, forPrincipal);
        for (AccessControlEntry accessControlEntry : accessControlEntries = acl.getAccessControlEntries()) {
            Privilege[] privileges;
            JackrabbitAccessControlEntry jrAccessControlEntry = this.getJackrabbitAccessControlEntry(accessControlEntry, resourcePath, forPrincipal);
            if (jrAccessControlEntry == null || (privileges = jrAccessControlEntry.getPrivileges()) == null) continue;
            boolean isAllow = jrAccessControlEntry.isAllow();
            @NotNull String[] restrictionNames = jrAccessControlEntry.getRestrictionNames();
            HashSet<LocalRestriction> restrictionItems = new HashSet<LocalRestriction>();
            for (String restrictionName : restrictionNames) {
                RestrictionDefinition rd = srMap.get(restrictionName);
                if (rd == null) continue;
                boolean isMulti = rd.getRequiredType().isArray();
                if (isMulti) {
                    restrictionItems.add(new LocalRestriction(rd, jrAccessControlEntry.getRestrictions(restrictionName)));
                    continue;
                }
                restrictionItems.add(new LocalRestriction(rd, jrAccessControlEntry.getRestriction(restrictionName)));
            }
            if (isAllow) {
                PrivilegesHelper.allow(privilegeToLocalPrivilegesMap, restrictionItems, Arrays.asList(privileges));
                continue;
            }
            PrivilegesHelper.deny(privilegeToLocalPrivilegesMap, restrictionItems, Arrays.asList(privileges));
        }
        return privilegeToLocalPrivilegesMap;
    }

    @Nullable
    protected JackrabbitAccessControlEntry getJackrabbitAccessControlEntry(@NotNull AccessControlEntry entry, @NotNull String resourcePath, @NotNull Principal forPrincipal) {
        JackrabbitAccessControlEntry jrEntry = null;
        if (entry instanceof JackrabbitAccessControlEntry && entry.getPrincipal().equals(forPrincipal)) {
            jrEntry = (JackrabbitAccessControlEntry)entry;
        }
        return jrEntry;
    }

    @NotNull
    protected Map<String, Matcher> getMatchedRequestParameterNames(@NotNull SlingHttpServletRequest request, @NotNull Pattern pattern) {
        HashMap<String, Matcher> keys = new HashMap<String, Matcher>();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String key = (String)parameterNames.nextElement();
            Matcher matcher = pattern.matcher(key);
            if (!matcher.matches()) continue;
            keys.put(key, matcher);
        }
        return keys;
    }

    protected void processPostedPrivilegeDeleteParams(@NotNull AccessControlManager acm, @NotNull SlingHttpServletRequest request, @NotNull Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap) throws RepositoryException {
        @NotNull Map<String, Matcher> postedPrivilegeDeleteNames = this.getMatchedRequestParameterNames(request, PRIVILEGE_PATTERN_DELETE);
        for (Map.Entry<String, Matcher> entry : postedPrivilegeDeleteNames.entrySet()) {
            String paramName = entry.getKey();
            Matcher matcher = entry.getValue();
            String privilegeName = matcher.group(1);
            Privilege privilege = acm.privilegeFromName(privilegeName);
            String paramValue = request.getParameter(paramName);
            DeleteValues value = DeleteValues.valueOfParam(paramValue);
            if (DeleteValues.ALL.equals((Object)value) || DeleteValues.ALLOW.equals((Object)value)) {
                PrivilegesHelper.unallow(privilegeToLocalPrivilegesMap, Collections.singleton(privilege));
            }
            if (!DeleteValues.ALL.equals((Object)value) && !DeleteValues.DENY.equals((Object)value)) continue;
            PrivilegesHelper.undeny(privilegeToLocalPrivilegesMap, Collections.singleton(privilege));
        }
    }

    protected void processPostedRestrictionDeleteParams(@NotNull AccessControlManager acm, @NotNull SlingHttpServletRequest request, @NotNull Map<String, RestrictionDefinition> srMap, @NotNull Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap) throws RepositoryException {
        @NotNull Map<String, Matcher> postedRestrictionDeleteNames = this.getMatchedRequestParameterNames(request, RESTRICTION_PATTERN_DELETE);
        for (Map.Entry<String, Matcher> entry : postedRestrictionDeleteNames.entrySet()) {
            Collection<Privilege> privileges;
            String restrictionName;
            String privilegeName;
            String paramName = entry.getKey();
            Matcher matcher = entry.getValue();
            if (matcher.group(2) != null) {
                privilegeName = matcher.group(1);
                restrictionName = matcher.group(3);
            } else {
                privilegeName = null;
                restrictionName = matcher.group(1);
            }
            RestrictionDefinition rd = srMap.get(restrictionName);
            if (rd == null) {
                throw new AccessControlException(INVALID_OR_NOT_SUPPORTED_RESTRICTION_NAME_WAS_SUPPLIED);
            }
            if (privilegeName == null) {
                privileges = privilegeToLocalPrivilegesMap.keySet();
            } else {
                Privilege privilege = acm.privilegeFromName(privilegeName);
                privileges = Collections.singletonList(privilege);
            }
            String[] parameterValues = privilegeName == null ? new String[]{"all"} : request.getParameterValues(paramName);
            block6: for (String allowOrDeny : parameterValues) {
                DeleteValues value = DeleteValues.valueOfParam(allowOrDeny);
                switch (value) {
                    case ALL: {
                        PrivilegesHelper.unallowOrUndenyRestriction(privilegeToLocalPrivilegesMap, restrictionName, privileges);
                        continue block6;
                    }
                    case ALLOW: {
                        PrivilegesHelper.unallowRestriction(privilegeToLocalPrivilegesMap, restrictionName, privileges);
                        continue block6;
                    }
                    case DENY: {
                        PrivilegesHelper.undenyRestriction(privilegeToLocalPrivilegesMap, restrictionName, privileges);
                        continue block6;
                    }
                }
            }
        }
    }

    protected Set<LocalRestriction> postedRestrictionsForPrivilege(@NotNull SlingHttpServletRequest request, @NotNull Map<String, RestrictionDefinition> srMap, @NotNull Privilege forPrivilege, @NotNull PrivilegeValues forAllowOrDeny, @NotNull Set<LocalRestriction> generalRestrictions) throws RepositoryException {
        HashSet<LocalRestriction> restrictions = new HashSet<LocalRestriction>(generalRestrictions);
        @NotNull Map<String, Matcher> postedRestrictionParams = this.getMatchedRequestParameterNames(request, RESTRICTION_PATTERN);
        for (Map.Entry<String, Matcher> entry : postedRestrictionParams.entrySet()) {
            PrivilegeValues allowOrDeny;
            String restrictionName;
            String privilegeName;
            String paramName = entry.getKey();
            Matcher matcher = entry.getValue();
            if (matcher.group(2) != null) {
                privilegeName = matcher.group(1);
                restrictionName = matcher.group(3);
                allowOrDeny = PrivilegeValues.valueOfParam(matcher.group(4));
            } else {
                privilegeName = null;
                restrictionName = matcher.group(1);
                allowOrDeny = null;
            }
            if (privilegeName != null && !forPrivilege.getName().equals(privilegeName) || allowOrDeny != null && !forAllowOrDeny.equals((Object)allowOrDeny)) continue;
            LocalRestriction localRestriction = this.toLocalRestriction(request, srMap, restrictionName, paramName);
            restrictions.removeIf(r -> r.getName().equals(localRestriction.getName()));
            restrictions.add(localRestriction);
        }
        return restrictions;
    }

    protected LocalRestriction toLocalRestriction(@NotNull SlingHttpServletRequest request, @NotNull Map<String, RestrictionDefinition> srMap, @NotNull String restrictionName, @NotNull String paramName) throws RepositoryException {
        LocalRestriction localRestriction;
        RestrictionDefinition rd = srMap.get(restrictionName);
        if (rd == null) {
            throw new AccessControlException(INVALID_OR_NOT_SUPPORTED_RESTRICTION_NAME_WAS_SUPPLIED);
        }
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        ValueFactory vf = session.getValueFactory();
        int restrictionType = rd.getRequiredType().tag();
        if (rd.getRequiredType().isArray()) {
            String[] parameterValues = request.getParameterValues(paramName);
            Value[] restrictionValue = new Value[parameterValues.length];
            for (int i = 0; i < parameterValues.length; ++i) {
                restrictionValue[i] = vf.createValue(parameterValues[i], restrictionType);
            }
            localRestriction = new LocalRestriction(rd, restrictionValue);
        } else {
            Value restrictionValue = vf.createValue(request.getParameter(paramName), restrictionType);
            localRestriction = new LocalRestriction(rd, restrictionValue);
        }
        return localRestriction;
    }

    protected void processPostedPrivilegeAndRestrictionParams(@NotNull AccessControlManager acm, @NotNull SlingHttpServletRequest request, @NotNull Map<String, RestrictionDefinition> srMap, @NotNull Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, @NotNull Map<Privilege, Integer> privilegeLongestDepthMap) throws RepositoryException {
        @NotNull Map<String, Matcher> postedPrivilegeNameKeys = this.getMatchedRequestParameterNames(request, PRIVILEGE_PATTERN);
        HashMap<Privilege, Set> privilegeToParamValuesMap = new HashMap<Privilege, Set>();
        for (Map.Entry<String, Matcher> entry : postedPrivilegeNameKeys.entrySet()) {
            Iterator<Map.Entry<Privilege, LocalPrivilege>> paramName = entry.getKey();
            Matcher matcher = entry.getValue();
            String string = matcher.group(1);
            Privilege privilege = acm.privilegeFromName(string);
            Set paramValues = privilegeToParamValuesMap.computeIfAbsent(privilege, p -> new HashSet());
            paramValues.addAll(Arrays.asList(request.getParameterValues(paramName)));
        }
        HashSet<LocalRestriction> generalRestrictions = new HashSet<LocalRestriction>();
        Map<String, Matcher> postedRestrictionParams = this.getMatchedRequestParameterNames(request, RESTRICTION_PATTERN);
        for (Map.Entry entry : postedRestrictionParams.entrySet()) {
            Matcher matcher = (Matcher)entry.getValue();
            if (matcher.group(2) != null) {
                PrivilegeValues allowOrDeny = PrivilegeValues.valueOfParam(matcher.group(4));
                if (!PrivilegeValues.ALLOW.equals((Object)allowOrDeny) && !PrivilegeValues.DENY.equals((Object)allowOrDeny)) continue;
                String privilegeName = matcher.group(1);
                Privilege privilege = acm.privilegeFromName(privilegeName);
                Set paramValues = privilegeToParamValuesMap.computeIfAbsent(privilege, p -> new HashSet());
                paramValues.add(allowOrDeny.getParamValue());
                continue;
            }
            String restrictionName = matcher.group(1);
            String paramName = (String)entry.getKey();
            LocalRestriction localRestriction = this.toLocalRestriction(request, srMap, restrictionName, paramName);
            generalRestrictions.removeIf(r -> r.getName().equals(localRestriction.getName()));
            generalRestrictions.add(localRestriction);
        }
        if (!generalRestrictions.isEmpty()) {
            for (Map.Entry<Privilege, LocalPrivilege> entry : privilegeToLocalPrivilegesMap.entrySet()) {
                Privilege privilege = entry.getKey();
                if (privilegeToParamValuesMap.containsKey(privilege)) continue;
                LocalPrivilege lp = entry.getValue();
                this.applyPrivilegeAndRestrictions(privilegeToLocalPrivilegesMap, privilege, lp.isAllow(), generalRestrictions, lp.isDeny(), generalRestrictions);
            }
        }
        ArrayList sortedEntries = new ArrayList(privilegeToParamValuesMap.entrySet());
        Collections.sort(sortedEntries, (e1, e2) -> ((Integer)privilegeLongestDepthMap.get(e1.getKey())).compareTo((Integer)privilegeLongestDepthMap.get(e2.getKey())));
        for (Map.Entry entry : sortedEntries) {
            Set paramValues = (Set)entry.getValue();
            Privilege privilege = (Privilege)entry.getKey();
            List privilegeValues = paramValues.stream().map(PrivilegeValues::valueOfParam).sorted((v1, v2) -> Integer.compare(v2.ordinal(), v1.ordinal())).collect(Collectors.toList());
            boolean none = false;
            boolean allow = false;
            Set<LocalRestriction> allowRestrictions = Collections.emptySet();
            boolean deny = false;
            Set<LocalRestriction> denyRestrictions = Collections.emptySet();
            for (PrivilegeValues value : privilegeValues) {
                switch (value) {
                    case DENY: 
                    case DENIED: {
                        deny = true;
                        denyRestrictions = this.postedRestrictionsForPrivilege(request, srMap, privilege, value, generalRestrictions);
                        break;
                    }
                    case ALLOW: 
                    case GRANTED: {
                        allow = true;
                        allowRestrictions = this.postedRestrictionsForPrivilege(request, srMap, privilege, value, generalRestrictions);
                        break;
                    }
                    case NONE: {
                        none = true;
                        break;
                    }
                }
            }
            if (none) {
                PrivilegesHelper.none(privilegeToLocalPrivilegesMap, Collections.singleton(privilege));
            }
            this.applyPrivilegeAndRestrictions(privilegeToLocalPrivilegesMap, privilege, allow, allowRestrictions, deny, denyRestrictions);
        }
    }

    protected void applyPrivilegeAndRestrictions(@NotNull Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, @NotNull Privilege p, boolean allow, @NotNull Set<LocalRestriction> allowRestrictions, boolean deny, @NotNull Set<LocalRestriction> denyRestrictions) throws RepositoryException {
        if (allow) {
            PrivilegesHelper.unallowRestrictions(privilegeToLocalPrivilegesMap, allowRestrictions.stream().map(LocalRestriction::getName).collect(Collectors.toSet()), Collections.singleton(p));
        }
        if (deny) {
            PrivilegesHelper.undenyRestrictions(privilegeToLocalPrivilegesMap, denyRestrictions.stream().map(LocalRestriction::getName).collect(Collectors.toSet()), Collections.singleton(p));
        }
        if (allow && deny) {
            PrivilegesHelper.allowAndDeny(privilegeToLocalPrivilegesMap, allow, allowRestrictions, deny, denyRestrictions, Collections.singleton(p));
        } else if (allow) {
            PrivilegesHelper.allow(privilegeToLocalPrivilegesMap, allowRestrictions, Collections.singleton(p));
        } else if (deny) {
            PrivilegesHelper.deny(privilegeToLocalPrivilegesMap, denyRestrictions, Collections.singleton(p));
        }
    }

    protected JackrabbitAccessControlList getAcl(@NotNull AccessControlManager acm, String resourcePath, Principal principal) throws RepositoryException {
        AccessControlPolicy[] policies = acm.getPolicies(resourcePath);
        JackrabbitAccessControlList acl = null;
        for (AccessControlPolicy policy : policies) {
            if (!(policy instanceof JackrabbitAccessControlList)) continue;
            acl = (JackrabbitAccessControlList)policy;
            break;
        }
        if (acl == null) {
            AccessControlPolicyIterator applicablePolicies = acm.getApplicablePolicies(resourcePath);
            while (applicablePolicies.hasNext()) {
                AccessControlPolicy policy = applicablePolicies.nextAccessControlPolicy();
                if (!(policy instanceof JackrabbitAccessControlList)) continue;
                acl = (JackrabbitAccessControlList)policy;
                break;
            }
        }
        return acl;
    }

    protected String removeAces(@NotNull String resourcePath, @Nullable String order, @NotNull Principal principal, @NotNull JackrabbitAccessControlList acl) throws RepositoryException {
        AccessControlEntry[] existingAccessControlEntries = acl.getAccessControlEntries();
        if (order == null || order.length() == 0) {
            HashSet<Principal> processedPrincipals = new HashSet<Principal>();
            for (int j = 0; j < existingAccessControlEntries.length; ++j) {
                AccessControlEntry ace = existingAccessControlEntries[j];
                Principal principal2 = ace.getPrincipal();
                if (principal2.equals(principal)) {
                    order = String.valueOf(processedPrincipals.size());
                    break;
                }
                processedPrincipals.add(principal2);
            }
        }
        for (int j = 0; j < existingAccessControlEntries.length; ++j) {
            AccessControlEntry ace = existingAccessControlEntries[j];
            if (!ace.getPrincipal().equals(principal)) continue;
            acl.removeAccessControlEntry(ace);
        }
        return order;
    }

    protected void addAces(@NotNull String resourcePath, @NotNull Principal principal, @NotNull Map<Set<LocalRestriction>, List<LocalPrivilege>> restrictionsToLocalPrivilegesMap, boolean isAllow, @NotNull JackrabbitAccessControlList acl, Map<Privilege, Integer> privilegeLongestDepthMap) throws RepositoryException {
        ArrayList<Map.Entry<Set<LocalRestriction>, List<LocalPrivilege>>> sortedEntries = new ArrayList<Map.Entry<Set<LocalRestriction>, List<LocalPrivilege>>>(restrictionsToLocalPrivilegesMap.entrySet());
        Collections.sort(sortedEntries, (e1, e2) -> {
            int shallowestDepth1 = Integer.MAX_VALUE;
            for (LocalPrivilege lp : (List)e1.getValue()) {
                Integer depth = (Integer)privilegeLongestDepthMap.get(lp.getPrivilege());
                if (depth == null || depth >= shallowestDepth1) continue;
                shallowestDepth1 = depth;
            }
            int shallowestDepth2 = Integer.MAX_VALUE;
            for (LocalPrivilege lp : (List)e2.getValue()) {
                Integer depth = (Integer)privilegeLongestDepthMap.get(lp.getPrivilege());
                if (depth == null || depth >= shallowestDepth2) continue;
                shallowestDepth2 = depth;
            }
            return Integer.compare(shallowestDepth1, shallowestDepth2);
        });
        for (Map.Entry entry : sortedEntries) {
            HashSet<Privilege> privilegesSet = new HashSet<Privilege>();
            HashMap<String, Value> restrictions = new HashMap<String, Value>();
            HashMap<String, Value[]> mvRestrictions = new HashMap<String, Value[]>();
            Set localRestrictions = (Set)entry.getKey();
            for (LocalRestriction localRestriction : localRestrictions) {
                if (localRestriction.isMultiValue()) {
                    mvRestrictions.put(localRestriction.getName(), localRestriction.getValues());
                    continue;
                }
                restrictions.put(localRestriction.getName(), localRestriction.getValue());
            }
            for (LocalPrivilege localPrivilege : (List)entry.getValue()) {
                privilegesSet.add(localPrivilege.getPrivilege());
            }
            if (privilegesSet.isEmpty()) continue;
            if (acl instanceof PrincipalAccessControlList) {
                ((PrincipalAccessControlList)acl).addEntry(resourcePath, privilegesSet.toArray(new Privilege[privilegesSet.size()]), restrictions, mvRestrictions);
                continue;
            }
            acl.addEntry(principal, privilegesSet.toArray(new Privilege[privilegesSet.size()]), isAllow, restrictions, mvRestrictions);
        }
    }

    private static void reorderAccessControlEntries(AccessControlList acl, Principal principal, String order) throws RepositoryException {
        if (order == null || order.length() == 0) {
            return;
        }
        if (acl instanceof JackrabbitAccessControlList) {
            JackrabbitAccessControlList jacl = (JackrabbitAccessControlList)acl;
            AccessControlEntry[] accessControlEntries = jacl.getAccessControlEntries();
            if (accessControlEntries.length <= 1) {
                return;
            }
            AccessControlEntry beforeEntry = null;
            if ("first".equals(order)) {
                beforeEntry = accessControlEntries[0];
            } else if (!"last".equals(order)) {
                if (order.startsWith("before ")) {
                    String beforePrincipalName = order.substring(7);
                    for (int i = 0; i < accessControlEntries.length; ++i) {
                        if (!beforePrincipalName.equals(accessControlEntries[i].getPrincipal().getName())) continue;
                        beforeEntry = accessControlEntries[i];
                        break;
                    }
                    if (beforeEntry == null) {
                        throw new IllegalArgumentException("No ACE was found for the specified principal: " + beforePrincipalName);
                    }
                } else if (order.startsWith("after ")) {
                    String afterPrincipalName = order.substring(6);
                    for (int i = accessControlEntries.length - 1; i >= 0; --i) {
                        if (!afterPrincipalName.equals(accessControlEntries[i].getPrincipal().getName())) continue;
                        if (i >= accessControlEntries.length - 1) {
                            beforeEntry = null;
                            break;
                        }
                        beforeEntry = accessControlEntries[i + 1];
                        break;
                    }
                    if (beforeEntry == null) {
                        throw new IllegalArgumentException("No ACE was found for the specified principal: " + afterPrincipalName);
                    }
                } else {
                    int index = -1;
                    try {
                        index = Integer.parseInt(order);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("Illegal value for the order parameter: " + order);
                    }
                    if (index > accessControlEntries.length) {
                        throw new IndexOutOfBoundsException("Index value is too large: " + index);
                    }
                    HashMap<Principal, Integer> principalToIndex = new HashMap<Principal, Integer>();
                    for (int i = 0; i < accessControlEntries.length; ++i) {
                        Principal principal2 = accessControlEntries[i].getPrincipal();
                        Integer idx = i;
                        principalToIndex.computeIfAbsent(principal2, key -> idx);
                    }
                    Integer[] sortedIndexes = (Integer[])principalToIndex.values().stream().sorted().toArray(Integer[]::new);
                    if (index >= 0 && index < sortedIndexes.length - 1) {
                        int idx = sortedIndexes[index];
                        beforeEntry = accessControlEntries[idx];
                    }
                }
            }
            if (beforeEntry != null) {
                for (AccessControlEntry ace : accessControlEntries) {
                    if (!principal.equals(ace.getPrincipal())) continue;
                    jacl.orderBefore(ace, beforeEntry);
                }
            }
        } else {
            throw new IllegalArgumentException("The acl must be an instance of JackrabbitAccessControlList");
        }
    }

    @Override
    public void modifyAce(Session jcrSession, String resourcePath, String principalId, Map<String, String> privileges, String order, boolean autoSave) throws RepositoryException {
        this.modifyAce(jcrSession, resourcePath, principalId, privileges, order, null, null, null, autoSave);
    }

    @Override
    public void modifyAce(Session jcrSession, String resourcePath, String principalId, Map<String, String> privileges, String order) throws RepositoryException {
        this.modifyAce(jcrSession, resourcePath, principalId, privileges, order, true);
    }

    @Override
    public void modifyAce(Session jcrSession, String resourcePath, String principalId, Map<String, String> privileges, String order, Map<String, Value> restrictions, Map<String, Value[]> mvRestrictions, Set<String> removeRestrictionNames) throws RepositoryException {
        this.modifyAce(jcrSession, resourcePath, principalId, privileges, order, restrictions, mvRestrictions, removeRestrictionNames, true);
    }

    @Override
    public void modifyAce(Session jcrSession, String resourcePath, String principalId, Map<String, String> privileges, String order, Map<String, Value> restrictions, Map<String, Value[]> mvRestrictions, Set<String> removeRestrictionNames, boolean autoSave) throws RepositoryException {
        this.modifyAce(jcrSession, resourcePath, principalId, privileges, order, restrictions, mvRestrictions, removeRestrictionNames, autoSave, null);
    }

    protected void modifyAce(Session jcrSession, String resourcePath, String principalId, Map<String, String> privileges, String order, Map<String, Value> restrictions, Map<String, Value[]> mvRestrictions, Set<String> removeRestrictionNames, boolean autoSave, List<Modification> changes) throws RepositoryException {
        Principal principal = this.validateArgs(jcrSession, resourcePath, principalId);
        AccessControlManager acm = jcrSession.getAccessControlManager();
        Map<String, RestrictionDefinition> srMap = this.buildRestrictionNameToDefinitionMap(resourcePath);
        Map<Privilege, Integer> privilegeLongestDepthMap = PrivilegesHelper.buildPrivilegeLongestDepthMap(acm.privilegeFromName("jcr:all"));
        Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap = this.loadStoredAce(acm, resourcePath, principal, srMap);
        for (LocalPrivilege localPrivilege : privilegeToLocalPrivilegesMap.values()) {
            if (localPrivilege.isAllow()) {
                PrivilegesHelper.unallowRestrictions(privilegeToLocalPrivilegesMap, removeRestrictionNames, Collections.singleton(localPrivilege.getPrivilege()));
            }
            if (!localPrivilege.isDeny()) continue;
            PrivilegesHelper.undenyRestrictions(privilegeToLocalPrivilegesMap, removeRestrictionNames, Collections.singleton(localPrivilege.getPrivilege()));
        }
        HashSet<LocalRestriction> localRestrictions = new HashSet<LocalRestriction>();
        if (restrictions != null) {
            for (Map.Entry<String, Value> entry : restrictions.entrySet()) {
                RestrictionDefinition restrictionDefinition = srMap.get(entry.getKey());
                if (restrictionDefinition == null) {
                    throw new AccessControlException(INVALID_OR_NOT_SUPPORTED_RESTRICTION_NAME_WAS_SUPPLIED);
                }
                localRestrictions.add(new LocalRestriction(restrictionDefinition, entry.getValue()));
            }
        }
        if (mvRestrictions != null) {
            for (Map.Entry<String, Value[]> entry : mvRestrictions.entrySet()) {
                RestrictionDefinition restrictionDefinition = srMap.get(entry.getKey());
                if (restrictionDefinition == null) {
                    throw new AccessControlException(INVALID_OR_NOT_SUPPORTED_RESTRICTION_NAME_WAS_SUPPLIED);
                }
                localRestrictions.add(new LocalRestriction(restrictionDefinition, entry.getValue()));
            }
        }
        EnumMap<PrivilegeValues, Set> enumMap = new EnumMap<PrivilegeValues, Set>(PrivilegeValues.class);
        for (Map.Entry<String, String> entry : privileges.entrySet()) {
            String privilegeName = entry.getKey();
            if (privilegeName.startsWith("privilege@")) {
                privilegeName = privilegeName.substring(10);
            }
            Privilege privilege = acm.privilegeFromName(privilegeName);
            PrivilegeValues value = PrivilegeValues.valueOfParam(entry.getValue());
            Set privilegesSet = enumMap.computeIfAbsent(value, k -> new HashSet());
            privilegesSet.add(privilege);
        }
        for (Map.Entry entry : enumMap.entrySet()) {
            switch ((PrivilegeValues)((Object)entry.getKey())) {
                case ALLOW: 
                case GRANTED: {
                    PrivilegesHelper.allow(privilegeToLocalPrivilegesMap, localRestrictions, (Collection)entry.getValue());
                    break;
                }
                case DENY: 
                case DENIED: {
                    PrivilegesHelper.deny(privilegeToLocalPrivilegesMap, localRestrictions, (Collection)entry.getValue());
                    break;
                }
                case NONE: {
                    PrivilegesHelper.none(privilegeToLocalPrivilegesMap, (Collection)entry.getValue());
                    break;
                }
            }
        }
        PrivilegesHelper.consolidateAggregates(jcrSession, resourcePath, privilegeToLocalPrivilegesMap, privilegeLongestDepthMap);
        this.modifyAce(jcrSession, resourcePath, principalId, privilegeToLocalPrivilegesMap.values(), order, autoSave, changes);
    }

    @Override
    public void modifyAce(Session jcrSession, String resourcePath, String principalId, Collection<LocalPrivilege> localPrivileges, String order, boolean autoSave) throws RepositoryException {
        this.modifyAce(jcrSession, resourcePath, principalId, localPrivileges, order, autoSave, null);
    }

    protected void modifyAce(Session jcrSession, String resourcePath, String principalId, Collection<LocalPrivilege> localPrivileges, String order, boolean autoSave, List<Modification> changes) throws RepositoryException {
        @NotNull Principal principal = this.validateArgs(jcrSession, resourcePath, principalId);
        HashMap<Set<LocalRestriction>, List<LocalPrivilege>> allowRestrictionsToLocalPrivilegesMap = new HashMap<Set<LocalRestriction>, List<LocalPrivilege>>();
        HashMap<Set<LocalRestriction>, List<LocalPrivilege>> denyRestrictionsToLocalPrivilegesMap = new HashMap<Set<LocalRestriction>, List<LocalPrivilege>>();
        for (LocalPrivilege localPrivilege : localPrivileges) {
            List list;
            if (localPrivilege.isAllow()) {
                list = allowRestrictionsToLocalPrivilegesMap.computeIfAbsent(localPrivilege.getAllowRestrictions(), key -> new ArrayList());
                list.add(localPrivilege);
            }
            if (!localPrivilege.isDeny()) continue;
            list = denyRestrictionsToLocalPrivilegesMap.computeIfAbsent(localPrivilege.getDenyRestrictions(), key -> new ArrayList());
            list.add(localPrivilege);
        }
        try {
            AccessControlManager acm = jcrSession.getAccessControlManager();
            JackrabbitAccessControlList acl = this.getAcl(acm, resourcePath, principal);
            order = this.removeAces(resourcePath, order, principal, acl);
            Map<Privilege, Integer> privilegeLongestDepthMap = PrivilegesHelper.buildPrivilegeLongestDepthMap(acm.privilegeFromName("jcr:all"));
            this.addAces(resourcePath, principal, denyRestrictionsToLocalPrivilegesMap, false, acl, privilegeLongestDepthMap);
            this.addAces(resourcePath, principal, allowRestrictionsToLocalPrivilegesMap, true, acl, privilegeLongestDepthMap);
            ModifyAceServlet.reorderAccessControlEntries((AccessControlList)acl, principal, order);
            acm.setPolicy(acl.getPath(), (AccessControlPolicy)acl);
            if (changes != null) {
                changes.add(Modification.onModified((String)principal.getName()));
            }
            if (autoSave && jcrSession.hasPendingChanges()) {
                jcrSession.save();
            }
        }
        catch (RepositoryException re) {
            throw new RepositoryException("Failed to create ace.", (Throwable)re);
        }
    }

    private static enum DeleteValues {
        ALL("all"),
        ALLOW("allow"),
        DENY("deny"),
        INVALID("*");

        private String paramValue;

        private DeleteValues(String paramValue) {
            this.paramValue = paramValue;
        }

        public static DeleteValues valueOfParam(String value) {
            return Stream.of(DeleteValues.values()).filter(item -> item.paramValue.equalsIgnoreCase(value)).findFirst().orElse(INVALID);
        }
    }

    private static enum PrivilegeValues {
        ALLOW("allow"),
        GRANTED("granted"),
        NONE("none"),
        DENIED("denied"),
        DENY("deny"),
        INVALID("*");

        private String paramValue;

        private PrivilegeValues(String paramValue) {
            this.paramValue = paramValue;
        }

        public String getParamValue() {
            return this.paramValue;
        }

        public static PrivilegeValues valueOfParam(String value) {
            return Stream.of(PrivilegeValues.values()).filter(item -> item.paramValue.equalsIgnoreCase(value)).findFirst().orElse(INVALID);
        }
    }
}

