/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager.post;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.servlet.Servlet;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.jcr.jackrabbit.accessmanager.DeleteAces;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.AbstractAccessPostServlet;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.PostResponseCreator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class, DeleteAces.class}, property={"sling.servlet.resourceTypes=sling/servlet/default", "sling.servlet.methods=POST", "sling.servlet.selectors=deleteAce", "sling.servlet.prefix:Integer=-1"})
public class DeleteAcesServlet
extends AbstractAccessPostServlet
implements DeleteAces {
    private static final long serialVersionUID = 3784866802938282971L;
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    @Reference(service=PostResponseCreator.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        super.bindPostResponseCreator(creator, properties);
    }

    @Override
    protected void unbindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        super.unbindPostResponseCreator(creator, properties);
    }

    @Override
    protected void handleOperation(SlingHttpServletRequest request, PostResponse htmlResponse, List<Modification> changes) throws RepositoryException {
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        String resourcePath = request.getResource().getPath();
        String[] applyTo = request.getParameterValues(":applyTo");
        this.deleteAces(session, resourcePath, applyTo, changes);
    }

    @Override
    public void deleteAces(Session jcrSession, String resourcePath, String[] principalNamesToDelete) throws RepositoryException {
        this.deleteAces(jcrSession, resourcePath, principalNamesToDelete, null);
    }

    protected void deleteAces(Session jcrSession, String resourcePath, String[] principalNamesToDelete, List<Modification> changes) throws RepositoryException {
        if (principalNamesToDelete == null) {
            throw new RepositoryException("principalIds were not sumitted.");
        }
        if (jcrSession == null) {
            throw new RepositoryException("JCR Session not found");
        }
        if (resourcePath == null) {
            throw new ResourceNotFoundException("Resource path was not supplied.");
        }
        Item item = jcrSession.getItem(resourcePath);
        if (item == null) {
            throw new ResourceNotFoundException("Resource is not a JCR Node");
        }
        resourcePath = item.getPath();
        HashSet<String> pidSet = new HashSet<String>();
        pidSet.addAll(Arrays.asList(principalNamesToDelete));
        HashSet<String> notFound = null;
        HashSet<Principal> found = new HashSet<Principal>();
        PrincipalManager principalManager = AccessControlUtil.getPrincipalManager((Session)jcrSession);
        for (String pid : pidSet) {
            Principal principal = principalManager.getPrincipal(pid);
            if (principal == null) {
                if (notFound == null) {
                    notFound = new HashSet<String>();
                }
                notFound.add(pid);
                continue;
            }
            found.add(principal);
        }
        if (notFound != null && !notFound.isEmpty()) {
            throw new RepositoryException("Invalid principalId was submitted.");
        }
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)jcrSession);
            AccessControlList updatedAcl = this.getAccessControlListOrNull(accessControlManager, resourcePath, false);
            if (updatedAcl == null) {
                for (Principal principal : found) {
                    this.log.warn("No AccessControlEntry was found to be deleted for principal: {}", (Object)principal.getName());
                }
            } else {
                AccessControlEntry[] accessControlEntries = updatedAcl.getAccessControlEntries();
                ArrayList<AccessControlEntry> oldAces = new ArrayList<AccessControlEntry>();
                for (AccessControlEntry ace : accessControlEntries) {
                    if (!pidSet.contains(ace.getPrincipal().getName())) continue;
                    oldAces.add(ace);
                }
                HashSet<Principal> removedPrincipalSet = new HashSet<Principal>();
                if (!oldAces.isEmpty()) {
                    for (AccessControlEntry ace : oldAces) {
                        updatedAcl.removeAccessControlEntry(ace);
                        removedPrincipalSet.add(ace.getPrincipal());
                    }
                }
                for (Principal principal : found) {
                    if (removedPrincipalSet.contains(principal)) {
                        if (changes == null) continue;
                        changes.add(Modification.onDeleted((String)principal.getName()));
                        continue;
                    }
                    this.log.warn("No AccessControlEntry was found to be deleted for principal: {}", (Object)principal.getName());
                }
                accessControlManager.setPolicy(resourcePath, (AccessControlPolicy)updatedAcl);
            }
        }
        catch (RepositoryException re) {
            throw new RepositoryException("Failed to delete access control.", (Throwable)re);
        }
    }
}

