/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.davex.impl.servlets;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.jackrabbit.server.SessionProvider;
import org.apache.jackrabbit.server.remoting.davex.JcrRemotingServlet;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="%dav.name", description="%dav.description", policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(name="service.description", value={"Sling JcrRemoting Servlet"}), @Property(name="service.vendor", value={"The Apache Software Foundation"})})
public class SlingDavExServlet
extends JcrRemotingServlet {
    private static final String DEFAULT_DAV_ROOT = "/server";
    @Property(value={"/server"})
    private static final String PROP_DAV_ROOT = "alias";
    private static final boolean DEFAULT_CREATE_ABSOLUTE_URI = true;
    @Property(boolValue={true})
    private static final String PROP_CREATE_ABSOLUTE_URI = "dav.create-absolute-uri";
    private static final String DEFAULT_PROTECTED_HANDLERS = "org.apache.jackrabbit.server.remoting.davex.AclRemoveHandler";
    @Property(value={"org.apache.jackrabbit.server.remoting.davex.AclRemoveHandler"})
    private static final String PROP_PROTECTED_HANDLERS = "dav.protectedhandlers";
    private static final String PAR_AUTH_REQ = "sling.auth.requirements";
    private static char[] EMPTY_PW = new char[0];
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference
    private SlingRepository repository;
    private ServiceRegistration davServlet;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, ?> config) {
        String davRoot = OsgiUtil.toString(config.get(PROP_DAV_ROOT), DEFAULT_DAV_ROOT);
        boolean createAbsoluteUri = OsgiUtil.toBoolean(config.get(PROP_CREATE_ABSOLUTE_URI), true);
        String protectedHandlers = OsgiUtil.toString(config.get(PROP_PROTECTED_HANDLERS), DEFAULT_PROTECTED_HANDLERS);
        Hashtable<String, String> initProps = new Hashtable<String, String>();
        ((Dictionary)initProps).put(SlingDavExServlet.toInitParamProperty("resource-path-prefix"), davRoot);
        ((Dictionary)initProps).put(SlingDavExServlet.toInitParamProperty("createAbsoluteURI"), Boolean.toString(createAbsoluteUri));
        ((Dictionary)initProps).put(SlingDavExServlet.toInitParamProperty("csrf-protection"), "disabled");
        ((Dictionary)initProps).put(SlingDavExServlet.toInitParamProperty("protectedhandlers-config"), protectedHandlers);
        ((Dictionary)initProps).put("osgi.http.whiteboard.servlet.pattern", davRoot.concat("/*"));
        ((Dictionary)initProps).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=DavExAuthHttpContext)");
        ((Dictionary)initProps).put("service.vendor", (String)config.get("service.vendor"));
        ((Dictionary)initProps).put("service.description", (String)config.get("service.description"));
        ((Dictionary)initProps).put(PAR_AUTH_REQ, "-" + davRoot);
        this.davServlet = bundleContext.registerService(Servlet.class.getName(), (Object)this, initProps);
    }

    @Deactivate
    protected void deactivate() {
        if (this.davServlet != null) {
            this.davServlet.unregister();
            this.davServlet = null;
        }
    }

    @Override
    protected Repository getRepository() {
        return this.repository;
    }

    @Override
    protected SessionProvider getSessionProvider() {
        return new SessionProvider(){

            @Override
            public Session getSession(HttpServletRequest req, Repository repository, String workspace) throws LoginException, RepositoryException, ServletException {
                Session session;
                ResourceResolver resolver = (ResourceResolver)req.getAttribute("org.apache.sling.auth.core.ResourceResolver");
                if (resolver != null && (session = (Session)resolver.adaptTo(Session.class)) != null) {
                    Session newSession = this.getLongLivedSession(session);
                    SlingDavExServlet.this.log.debug("getSession: Creating new Session ({}) for {}", (Object)newSession, (Object)newSession.getUserID());
                    return newSession;
                }
                throw new ServletException("ResourceResolver missing or not providing on JCR Session");
            }

            @Override
            public void releaseSession(Session session) {
                SlingDavExServlet.this.log.debug("releaseSession: Logging out long lived Session ({})", (Object)session);
                session.logout();
            }

            private Session getLongLivedSession(Session slingSession) throws RepositoryException {
                String user = slingSession.getUserID();
                try {
                    SimpleCredentials credentials = new SimpleCredentials(user, EMPTY_PW);
                    return slingSession.impersonate((Credentials)credentials);
                }
                catch (Exception re) {
                    throw new RepositoryException("Cannot get session for " + user, (Throwable)re);
                }
            }
        };
    }

    private static String toInitParamProperty(String name) {
        return "servlet.init.".concat(name);
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

