/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.sightly.ui.internal;

import org.apache.sling.ide.eclipse.sightly.ui.internal.AbstractNewSightlyFileWizard;
import org.apache.sling.ide.eclipse.sightly.ui.internal.JavaUtils;
import org.eclipse.core.runtime.IPath;

public class NewSightlyJavaUseScriptWizard
extends AbstractNewSightlyFileWizard {
    public NewSightlyJavaUseScriptWizard() {
        super("New Sightly Java Use-Script", "Create a new Sightly Java Use-Script");
    }

    @Override
    protected String getInitialContents() {
        IPath fullPath = this.fileCreationPage.getContainerFullPath();
        String className = this.fileCreationPage.getFileName().replace(".java", "");
        String inferredPackage = JavaUtils.inferPackage(fullPath);
        if (inferredPackage == null) {
            inferredPackage = "unknown // TODO - replace with actual path";
        }
        return "package " + inferredPackage + ";\n" + "\n" + "import java.util.Date;\n" + "\n" + "public class " + className + " {\n" + "    public String getDate() {\n" + "        return new Date().toString();\n" + "    }\n" + "}";
    }

    @Override
    protected boolean validateFileToBeCreated() {
        if (!this.fileCreationPage.getFileName().endsWith(".java")) {
            this.fileCreationPage.setErrorMessage("File extension must be 'java'");
            return false;
        }
        return true;
    }

    @Override
    protected String getInitialFileName() {
        return "Script.java";
    }
}

