/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.internal.validation;

import org.apache.sling.ide.eclipse.core.ProjectUtil;
import org.apache.sling.ide.eclipse.internal.validation.AbstractValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.validation.ValidationEvent;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;

public class ContentProjectValidator
extends AbstractValidator {
    private boolean okToValidate = false;

    public void validationStarting(IProject project, ValidationState state, IProgressMonitor monitor) {
        this.okToValidate = true;
    }

    public ValidationResult validate(ValidationEvent event, ValidationState state, IProgressMonitor monitor) {
        ValidationResult res = new ValidationResult();
        if (!this.okToValidate) {
            return res;
        }
        this.okToValidate = false;
        IResource resource = event.getResource();
        IProject project = resource.getProject();
        IPath syncDir = ProjectUtil.getSyncDirectoryValue(project);
        IResource member = project.findMember(syncDir);
        try {
            this.deleteValidationMarkers((IResource)project);
            if (member == null) {
                this.addValidatorMessage(res, (IResource)project, "Configured sync dir " + syncDir + " does not exist");
            } else if (member.getType() != 2) {
                this.addValidatorMessage(res, (IResource)project, "Configured sync dir " + syncDir + " is not a directory");
            }
        }
        catch (CoreException e) {
            this.getLogger().warn("Failed validating content project " + resource.getFullPath(), (Throwable)e);
        }
        return res;
    }
}

