/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.sling.ide.eclipse.core.ProjectUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.util.ModuleFile;
import org.eclipse.wst.server.core.util.ModuleFolder;
import org.eclipse.wst.server.core.util.ProjectModule;
import org.eclipse.wst.server.core.util.ProjectModuleFactoryDelegate;

public class SlingContentModuleFactory
extends ProjectModuleFactoryDelegate {
    static final String SLING_CONTENT_FACET_ID = "sling.content";
    private static final IPath[] SETTINGS_PATHS = new IPath[]{new Path(".settings")};

    public IModule[] getModules(IProject project) {
        IModule[] result = super.getModules(project);
        if (result != null && result.length > 0) {
            return result;
        }
        this.clearCache(project);
        return super.getModules(project);
    }

    protected IPath[] getListenerPaths() {
        return SETTINGS_PATHS;
    }

    public ModuleDelegate getModuleDelegate(IModule module) {
        return new SlingContentModuleDelegate(module);
    }

    protected IModule createModule(IProject project) {
        IFacetedProject facetedProject;
        block4: {
            facetedProject = ProjectFacetsManager.create((IProject)project);
            if (facetedProject != null) break block4;
            return null;
        }
        try {
            for (IProjectFacetVersion facet : facetedProject.getProjectFacets()) {
                if (!facet.getProjectFacet().getId().equals(SLING_CONTENT_FACET_ID)) continue;
                return this.createModule(project.getName(), project.getName(), SLING_CONTENT_FACET_ID, "1.0", project);
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    static class SlingContentModuleDelegate
    extends ProjectModule {
        private static final IModuleResource[] EMPTY_MODULE_RESOURCES = new IModuleResource[0];

        public SlingContentModuleDelegate(IModule module) {
            super(module.getProject());
        }

        public IModuleResource[] members() throws CoreException {
            final ArrayList resources = new ArrayList();
            final IFolder syncFolder = ProjectUtil.getSyncDirectory(this.getProject());
            if (syncFolder == null || !syncFolder.exists()) {
                return EMPTY_MODULE_RESOURCES;
            }
            syncFolder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    IPath relativePath = resource.getProjectRelativePath();
                    IPath modulePath = relativePath.removeFirstSegments(syncFolder.getProjectRelativePath().segmentCount());
                    ModuleFile moduleFile = null;
                    if (resource.getType() == 1) {
                        moduleFile = new ModuleFile((IFile)resource, resource.getName(), modulePath);
                    } else if (resource.getType() == 2) {
                        moduleFile = new ModuleFolder((IContainer)((IFolder)resource), resource.getName(), modulePath);
                    }
                    if (moduleFile != null) {
                        resources.add(moduleFile);
                    }
                    return true;
                }
            });
            Collections.sort(resources, new Comparator<IModuleResource>(){

                @Override
                public int compare(IModuleResource o1, IModuleResource o2) {
                    IPath p1 = o1.getModuleRelativePath();
                    IPath p2 = o2.getModuleRelativePath();
                    if (p1.segmentCount() != p2.segmentCount()) {
                        return p1.segmentCount() - p2.segmentCount();
                    }
                    if (p1.removeLastSegments(1).equals((Object)p2.removeLastSegments(1))) {
                        if (o1.getClass() != o2.getClass()) {
                            if (o1 instanceof IModuleFile) {
                                return -1;
                            }
                            return 1;
                        }
                        return p1.segment(p1.segmentCount() - 1).compareTo(p2.segment(p2.segmentCount() - 1));
                    }
                    int i = 0;
                    while (i < p1.segmentCount()) {
                        String s2;
                        String s1 = p1.segment(i);
                        int res = s1.compareTo(s2 = p2.segment(i));
                        if (res != 0) {
                            return res;
                        }
                        ++i;
                    }
                    throw new IllegalArgumentException("Could not sort " + o1 + " and " + o2);
                }
            });
            return resources.toArray(new IModuleResource[resources.size()]);
        }
    }
}

