/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core.internal;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.sling.ide.eclipse.core.internal.Activator;
import org.apache.sling.ide.eclipse.core.internal.ProjectHelper;
import org.apache.sling.ide.log.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.util.ModuleFile;
import org.eclipse.wst.server.core.util.ProjectModule;
import org.eclipse.wst.server.core.util.ProjectModuleFactoryDelegate;

public class SlingBundleModuleFactory
extends ProjectModuleFactoryDelegate {
    static final String SLING_BUNDLE_FACET_ID = "sling.bundle";
    private static final IPath[] SETTINGS_PATHS = new IPath[]{new Path(".settings")};

    public IModule[] getModules(IProject project) {
        IModule[] result = super.getModules(project);
        if (result != null && result.length > 0) {
            return result;
        }
        this.clearCache(project);
        return super.getModules(project);
    }

    protected IPath[] getListenerPaths() {
        return SETTINGS_PATHS;
    }

    public ModuleDelegate getModuleDelegate(IModule module) {
        return new SlingBundleModuleDelegate(module);
    }

    protected IModule createModule(IProject project) {
        IFacetedProject facetedProject;
        block4: {
            facetedProject = ProjectFacetsManager.create((IProject)project);
            if (facetedProject != null) break block4;
            return null;
        }
        try {
            for (IProjectFacetVersion facet : facetedProject.getProjectFacets()) {
                if (!facet.getProjectFacet().getId().equals(SLING_BUNDLE_FACET_ID)) continue;
                return this.createModule(project.getName(), project.getName(), SLING_BUNDLE_FACET_ID, "1.0", project);
            }
        }
        catch (CoreException ce) {
            Activator.getDefault().getPluginLogger().warn("Failed creating module for project " + project, (Throwable)ce);
        }
        return null;
    }

    static class SlingBundleModuleDelegate
    extends ProjectModule {
        private static final IModule[] EMPTY_MODULES = new IModule[0];

        public SlingBundleModuleDelegate(IModule module) {
            super(module.getProject());
        }

        public IStatus validate() {
            return Status.OK_STATUS;
        }

        public IModuleResource[] members() throws CoreException {
            IJavaProject javaProject = ProjectHelper.asJavaProject(this.getProject());
            final ArrayList resources = new ArrayList();
            final HashSet<String> filteredLocations = new HashSet<String>();
            IJavaProject jp = javaProject;
            IClasspathEntry[] rawCp = jp.getRawClasspath();
            int i = 0;
            while (i < rawCp.length) {
                IClasspathEntry aCp = rawCp[i];
                IPath outputLocation = aCp.getOutputLocation();
                if (outputLocation != null) {
                    outputLocation = outputLocation.makeRelativeTo(this.getProject().getFullPath());
                    filteredLocations.add(outputLocation.toString());
                }
                ++i;
            }
            this.getProject().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.getType() == 4) {
                        return true;
                    }
                    IPath relativePath = resource.getProjectRelativePath();
                    if (relativePath == null) {
                        return false;
                    }
                    String relPathStr = relativePath.toString();
                    if (relPathStr == null || relPathStr.length() == 0) {
                        return false;
                    }
                    if (resource.isDerived()) {
                        return false;
                    }
                    if (filteredLocations.contains(relPathStr)) {
                        return false;
                    }
                    if (resource.getType() == 1) {
                        ModuleFile moduleFile = new ModuleFile((IFile)resource, resource.getName(), relativePath);
                        resources.add(moduleFile);
                    }
                    return true;
                }
            });
            Logger logger = Activator.getDefault().getPluginLogger();
            for (IModuleResource iModuleResource : resources) {
                logger.trace("For module {0} added {1}", new Object[]{this.getName(), iModuleResource.getModuleRelativePath().toString()});
            }
            return resources.toArray(new IModuleResource[resources.size()]);
        }

        public IModule[] getChildModules() {
            return EMPTY_MODULES;
        }
    }
}

