/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class JarBuilder {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputStream buildJar(IFolder sourceDir) throws CoreException {
        ByteArrayOutputStream store = new ByteArrayOutputStream();
        IResource manifestResource = sourceDir.findMember("META-INF/MANIFEST.MF");
        if (manifestResource == null || manifestResource.getType() != 1) {
            throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", "No file named META-INF/MANIFEST.MF found under " + sourceDir));
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                JarOutputStream zos = new JarOutputStream(store);
                try {
                    try (InputStream manifestInput = ((IFile)manifestResource).getContents();){
                        Manifest manifest = new Manifest(manifestInput);
                        zos.setLevel(0);
                        ZipEntry anEntry = new ZipEntry("META-INF/MANIFEST.MF");
                        zos.putNextEntry(anEntry);
                        manifest.write(zos);
                        zos.closeEntry();
                        this.zipDir(sourceDir, zos, "");
                    }
                    if (zos == null) return new ByteArrayInputStream(store.toByteArray());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (zos == null) throw throwable;
                    zos.close();
                    throw throwable;
                }
                zos.close();
                return new ByteArrayInputStream(store.toByteArray());
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", e.getMessage(), (Throwable)e));
        }
    }

    private void zipDir(IFolder sourceDir, ZipOutputStream zos, String path) throws CoreException, IOException {
        IResource[] iResourceArray = sourceDir.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entry;
            IResource f = iResourceArray[n2];
            if (f.getType() == 2) {
                String prefix = String.valueOf(path) + f.getName() + "/";
                zos.putNextEntry(new ZipEntry(prefix));
                this.zipDir((IFolder)f, zos, prefix);
            } else if (f.getType() == 1 && !"META-INF/MANIFEST.MF".equals(entry = String.valueOf(path) + f.getName())) {
                Throwable throwable = null;
                Object var10_11 = null;
                try (InputStream fis = ((IFile)f).getContents();){
                    byte[] readBuffer = new byte[8192];
                    int bytesIn = 0;
                    ZipEntry anEntry = new ZipEntry(entry);
                    zos.putNextEntry(anEntry);
                    while ((bytesIn = fis.read(readBuffer)) != -1) {
                        zos.write(readBuffer, 0, bytesIn);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            ++n2;
        }
    }
}

