/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.sling.ide.eclipse.core.ISlingLaunchpadConfiguration;
import org.apache.sling.ide.eclipse.core.ISlingLaunchpadServer;
import org.apache.sling.ide.eclipse.core.internal.Activator;
import org.apache.sling.ide.eclipse.core.internal.ProjectHelper;
import org.apache.sling.ide.eclipse.core.internal.SlingLaunchpadServer;
import org.apache.sling.ide.eclipse.core.launch.SourceReferenceResolver;
import org.apache.sling.ide.eclipse.core.progress.ProgressUtils;
import org.apache.sling.ide.osgi.OsgiClient;
import org.apache.sling.ide.osgi.OsgiClientException;
import org.apache.sling.ide.osgi.SourceReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.launching.JavaSourceLookupDirector;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMConnector;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IServer;

public class JVMDebuggerConnection {
    private ILaunch launch;
    private OsgiClient osgiClient;

    public JVMDebuggerConnection(OsgiClient osgiClient) {
        this.osgiClient = osgiClient;
    }

    boolean connectInDebugMode(ILaunch launch, IServer iServer, IProgressMonitor monitor) throws CoreException {
        long start = System.currentTimeMillis();
        this.launch = launch;
        boolean success = false;
        IVMConnector connector = null;
        connector = JavaRuntime.getVMConnector((String)IJavaLaunchConfigurationConstants.ID_SOCKET_ATTACH_VM_CONNECTOR);
        if (connector == null) {
            connector = JavaRuntime.getDefaultVMConnector();
        }
        if (connector == null) {
            throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse.wst", "Could not get jvm connctor"));
        }
        ISlingLaunchpadServer launchpadServer = (ISlingLaunchpadServer)iServer.loadAdapter(SlingLaunchpadServer.class, monitor);
        ISlingLaunchpadConfiguration configuration = launchpadServer.getConfiguration();
        int debugPort = configuration.getDebugPort();
        if (debugPort <= 0) {
            throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse.wst", "debug port not configured"));
        }
        HashMap<String, String> connectMap = new HashMap<String, String>();
        connectMap.put("hostname", iServer.getHost());
        connectMap.put("port", String.valueOf(debugPort));
        int connectTimeout = JavaRuntime.getPreferences().getInt(JavaRuntime.PREF_CONNECT_TIMEOUT);
        connectMap.put("timeout", Integer.toString(connectTimeout));
        JavaSourceLookupDirector sourceLocator = new JavaSourceLookupDirector();
        sourceLocator.setSourcePathComputer(DebugPlugin.getDefault().getLaunchManager().getSourcePathComputer("org.eclipse.jdt.launching.sourceLookup.javaSourcePathComputer"));
        ArrayList<IRuntimeClasspathEntry> classpathEntries = new ArrayList<IRuntimeClasspathEntry>();
        IJavaProject[] iJavaProjectArray = ProjectHelper.getAllJavaProjects();
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject javaProject = iJavaProjectArray[n2];
            classpathEntries.add(JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)javaProject));
            ++n2;
        }
        ProgressUtils.advance(monitor, 5);
        int workTicksForReferences = 24;
        SourceReferenceResolver resolver = Activator.getDefault().getSourceReferenceResolver();
        if (resolver != null && configuration.resolveSourcesInDebugMode()) {
            try {
                List references = this.osgiClient.findSourceReferences();
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Resolving source references", (int)workTicksForReferences).setWorkRemaining(references.size());
                for (SourceReference reference : references) {
                    try {
                        subMonitor.setTaskName("Resolving source reference: " + reference);
                        IRuntimeClasspathEntry classpathEntry = resolver.resolve(reference);
                        if (classpathEntry != null) {
                            classpathEntries.add(classpathEntry);
                        }
                        ProgressUtils.advance((IProgressMonitor)subMonitor, 1);
                    }
                    catch (CoreException e) {
                        Activator.getDefault().getPluginLogger().warn("Failed resolving source reference", (Throwable)e);
                    }
                }
                subMonitor.done();
            }
            catch (OsgiClientException e1) {
                throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", e1.getMessage(), (Throwable)e1));
            }
        } else {
            monitor.worked(workTicksForReferences);
        }
        classpathEntries.add(JavaRuntime.computeJREEntry((ILaunchConfiguration)launch.getLaunchConfiguration()));
        IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveSourceLookupPath((IRuntimeClasspathEntry[])classpathEntries.toArray(new IRuntimeClasspathEntry[0]), (ILaunchConfiguration)launch.getLaunchConfiguration());
        sourceLocator.setSourceContainers(JavaRuntime.getSourceContainers((IRuntimeClasspathEntry[])resolved));
        sourceLocator.initializeParticipants();
        launch.setSourceLocator((ISourceLocator)sourceLocator);
        try {
            connector.connect(connectMap, monitor, launch);
            success = true;
            long elapsedMillis = System.currentTimeMillis() - start;
            Activator.getDefault().getPluginLogger().tracePerformance("Debug connection to {0}", elapsedMillis, new Object[]{iServer.getName()});
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse.wst", "could not establish debug connection to " + iServer.getHost() + " : " + debugPort, (Throwable)e));
        }
        return success;
    }

    public void stop(boolean force) {
        IDebugTarget dt;
        IDebugTarget[] debugTargets;
        IProcess[] processes = this.launch.getProcesses();
        if (processes != null) {
            int i = 0;
            while (i < processes.length) {
                IProcess iProcess = processes[i];
                try {
                    iProcess.terminate();
                }
                catch (DebugException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        if ((debugTargets = this.launch.getDebugTargets()) != null) {
            int i = 0;
            while (i < debugTargets.length) {
                IDebugTarget iDebugTarget = debugTargets[i];
                try {
                    iDebugTarget.disconnect();
                }
                catch (DebugException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        if ((dt = this.launch.getDebugTarget()) != null) {
            try {
                dt.disconnect();
            }
            catch (DebugException e) {
                e.printStackTrace();
            }
        }
    }
}

