/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core.internal;

import java.util.HashMap;
import org.apache.sling.ide.artifacts.EmbeddedArtifactLocator;
import org.apache.sling.ide.eclipse.core.Preferences;
import org.apache.sling.ide.eclipse.core.ServiceUtil;
import org.apache.sling.ide.eclipse.core.debug.PluginLoggerRegistrar;
import org.apache.sling.ide.eclipse.core.launch.SourceReferenceResolver;
import org.apache.sling.ide.filter.FilterLocator;
import org.apache.sling.ide.log.Logger;
import org.apache.sling.ide.osgi.OsgiClientFactory;
import org.apache.sling.ide.serialization.SerializationManager;
import org.apache.sling.ide.transport.BatcherFactory;
import org.apache.sling.ide.transport.CommandExecutionProperties;
import org.apache.sling.ide.transport.RepositoryFactory;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.apache.sling.ide.eclipse-core";
    private static Activator plugin;
    private ServiceTracker<EventAdmin, EventAdmin> eventAdmin;
    private ServiceTracker<RepositoryFactory, RepositoryFactory> repositoryFactory;
    private ServiceTracker<SerializationManager, SerializationManager> serializationManager;
    private ServiceTracker<FilterLocator, FilterLocator> filterLocator;
    private ServiceTracker<OsgiClientFactory, OsgiClientFactory> osgiClientFactory;
    private ServiceTracker<EmbeddedArtifactLocator, EmbeddedArtifactLocator> artifactLocator;
    private ServiceTracker<Logger, Logger> tracer;
    private ServiceTracker<BatcherFactory, BatcherFactory> batcherFactoryLocator;
    private ServiceTracker<SourceReferenceResolver, Object> sourceReferenceLocator;
    private ServiceRegistration<Logger> tracerRegistration;
    private Preferences preferences;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.tracerRegistration = PluginLoggerRegistrar.register(this);
        this.eventAdmin = new ServiceTracker(context, EventAdmin.class, null);
        this.eventAdmin.open();
        this.repositoryFactory = new ServiceTracker(context, RepositoryFactory.class, null);
        this.repositoryFactory.open();
        this.serializationManager = new ServiceTracker(context, SerializationManager.class, null);
        this.serializationManager.open();
        this.filterLocator = new ServiceTracker(context, FilterLocator.class, null);
        this.filterLocator.open();
        this.osgiClientFactory = new ServiceTracker(context, OsgiClientFactory.class, null);
        this.osgiClientFactory.open();
        this.artifactLocator = new ServiceTracker(context, EmbeddedArtifactLocator.class, null);
        this.artifactLocator.open();
        this.tracer = new ServiceTracker(context, this.tracerRegistration.getReference(), null);
        this.tracer.open();
        this.batcherFactoryLocator = new ServiceTracker(context, BatcherFactory.class, null);
        this.batcherFactoryLocator.open();
        this.sourceReferenceLocator = new ServiceTracker(context, SourceReferenceResolver.class, null);
        this.sourceReferenceLocator.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.tracerRegistration.unregister();
        this.repositoryFactory.close();
        this.serializationManager.close();
        this.filterLocator.close();
        this.osgiClientFactory.close();
        this.artifactLocator.close();
        this.tracer.close();
        this.batcherFactoryLocator.close();
        this.sourceReferenceLocator.close();
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public RepositoryFactory getRepositoryFactory() {
        return ServiceUtil.getNotNull(this.repositoryFactory);
    }

    public SerializationManager getSerializationManager() {
        return ServiceUtil.getNotNull(this.serializationManager);
    }

    public FilterLocator getFilterLocator() {
        return ServiceUtil.getNotNull(this.filterLocator);
    }

    public OsgiClientFactory getOsgiClientFactory() {
        return ServiceUtil.getNotNull(this.osgiClientFactory);
    }

    public EmbeddedArtifactLocator getArtifactLocator() {
        return ServiceUtil.getNotNull(this.artifactLocator);
    }

    public Logger getPluginLogger() {
        return ServiceUtil.getNotNull(this.tracer);
    }

    public BatcherFactory getBatcherFactory() {
        return ServiceUtil.getNotNull(this.batcherFactoryLocator);
    }

    @Deprecated
    public void issueConsoleLog(String actionType, String path, String message) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("result.txt", message);
        props.put("action.type", actionType);
        props.put("action.target", path);
        props.put("timestamp.start", System.currentTimeMillis());
        props.put("timestamp.end", System.currentTimeMillis());
        Event event = new Event(CommandExecutionProperties.REPOSITORY_TOPIC, props);
        this.getEventAdmin().postEvent(event);
    }

    public EventAdmin getEventAdmin() {
        return ServiceUtil.getNotNull(this.eventAdmin);
    }

    public SourceReferenceResolver getSourceReferenceResolver() {
        return (SourceReferenceResolver)this.sourceReferenceLocator.getService();
    }

    public Preferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = new Preferences();
        }
        return this.preferences;
    }
}

