/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt.serialization;

import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import javax.jcr.NamespaceException;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.vault.util.DocViewNode;
import org.apache.jackrabbit.vault.util.DocViewProperty;
import org.apache.sling.ide.impl.vlt.Activator;
import org.apache.sling.ide.transport.ResourceProxy;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ContentXmlHandler
extends DefaultHandler
implements NamespaceResolver {
    private static final String JCR_ROOT = "jcr:root";
    private final ResourceProxy root;
    private final Deque<ResourceProxy> queue = new LinkedList<ResourceProxy>();
    private final Map<String, String> uriPrefixMap;
    private final DefaultNamePathResolver npResolver = new DefaultNamePathResolver((NamespaceResolver)this);
    private static final Map<Integer, TypeHint> TYPE_HINT_MAP = new HashMap<Integer, TypeHint>();

    static {
        for (TypeHint hint : EnumSet.allOf(TypeHint.class)) {
            TYPE_HINT_MAP.put(hint.propertyType, hint);
        }
    }

    public ContentXmlHandler(String rootResourcePath) {
        this.root = new ResourceProxy(rootResourcePath);
        this.uriPrefixMap = new HashMap<String, String>();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.uriPrefixMap.put(uri, prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String label;
        String name = label = ISO9075.decode((String)qName);
        try {
            ResourceProxy current;
            DocViewNode node = new DocViewNode(name, label, attributes, (NamePathResolver)this.npResolver);
            if (qName.equals(JCR_ROOT)) {
                current = this.root;
            } else {
                ResourceProxy parent = this.queue.peekLast();
                StringBuilder path = new StringBuilder(parent.getPath());
                if (path.charAt(path.length() - 1) != '/') {
                    path.append('/');
                }
                path.append(qName);
                current = new ResourceProxy(ISO9075.decode((String)path.toString()));
                parent.addChild(current);
            }
            for (Map.Entry entry : node.props.entrySet()) {
                try {
                    Object typedValue = TypeHint.convertDocViewPropertyToTypedValue((DocViewProperty)entry.getValue());
                    if (typedValue == null) continue;
                    current.addProperty((String)entry.getKey(), typedValue);
                }
                catch (Throwable t) {
                    Activator.getDefault().getPluginLogger().error("Could not parse property '" + ((DocViewProperty)entry.getValue()).name, t);
                }
            }
            this.queue.add(current);
        }
        catch (NamespaceException e) {
            Activator.getDefault().getPluginLogger().error("Could not resolve a JCR namespace.", (Throwable)e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.queue.removeLast();
    }

    public ResourceProxy getRoot() {
        return this.root;
    }

    public String getURI(String prefix) throws NamespaceException {
        throw new UnsupportedOperationException("The method getUri is not implemented as this is not being used");
    }

    public String getPrefix(String uri) throws NamespaceException {
        String prefix = this.uriPrefixMap.get(uri);
        if (prefix == null) {
            throw new NamespaceException("Could not find defined prefix for uri " + uri);
        }
        return prefix;
    }

    static enum TypeHint {
        UNDEFINED(0){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                return STRING.parseValues(values, explicitMultiValue);
            }
        }
        ,
        STRING(1){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                if (values.length == 1 && !explicitMultiValue) {
                    return values[0];
                }
                return values;
            }
        }
        ,
        BINARY(2){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                return null;
            }
        }
        ,
        BOOLEAN(6){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                if (values.length == 1 && !explicitMultiValue) {
                    return Boolean.valueOf(values[0]);
                }
                Boolean[] ret = new Boolean[values.length];
                int i = 0;
                while (i < values.length) {
                    ret[i] = Boolean.parseBoolean(values[i]);
                    ++i;
                }
                return ret;
            }
        }
        ,
        DATE(5){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                if (values.length == 1 && !explicitMultiValue) {
                    return ISO8601.parse((String)values[0]);
                }
                Calendar[] ret = new Calendar[values.length];
                int i = 0;
                while (i < values.length) {
                    ret[i] = ISO8601.parse((String)values[i]);
                    ++i;
                }
                return ret;
            }
        }
        ,
        DOUBLE(4){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                if (values.length == 1 && !explicitMultiValue) {
                    return Double.parseDouble(values[0]);
                }
                Double[] ret = new Double[values.length];
                int i = 0;
                while (i < values.length) {
                    ret[i] = Double.parseDouble(values[i]);
                    ++i;
                }
                return ret;
            }
        }
        ,
        LONG(3){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                if (values.length == 1 && !explicitMultiValue) {
                    return Long.valueOf(values[0]);
                }
                Long[] ret = new Long[values.length];
                int i = 0;
                while (i < values.length) {
                    ret[i] = Long.valueOf(values[i]);
                    ++i;
                }
                return ret;
            }
        }
        ,
        DECIMAL(12){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                if (values.length == 1 && !explicitMultiValue) {
                    return new BigDecimal(values[0]);
                }
                BigDecimal[] ret = new BigDecimal[values.length];
                int i = 0;
                while (i < values.length) {
                    ret[i] = new BigDecimal(values[i]);
                    ++i;
                }
                return ret;
            }
        }
        ,
        NAME(7){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                if (values.length == 1 && !explicitMultiValue) {
                    return values[0];
                }
                return values;
            }
        }
        ,
        PATH(8){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                return NAME.parseValues(values, explicitMultiValue);
            }
        }
        ,
        REFERENCE(9){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                if (values.length == 1 && !explicitMultiValue) {
                    return UUID.fromString(values[0]);
                }
                UUID[] refs = new UUID[values.length];
                int i = 0;
                while (i < values.length) {
                    String value = values[i];
                    refs[i] = UUID.fromString(value);
                    ++i;
                }
                return refs;
            }
        }
        ,
        WEAKREFERENCE(10){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                return REFERENCE.parseValues(values, explicitMultiValue);
            }
        }
        ,
        URI(11){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                try {
                    if (values.length == 1 && !explicitMultiValue) {
                        return new URI(values[0]);
                    }
                    URI[] refs = new URI[values.length];
                    int i = 0;
                    while (i < values.length) {
                        String value = values[i];
                        refs[i] = new URI(value);
                        ++i;
                    }
                    return refs;
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Given value cannot be converted to URI", e);
                }
            }
        };

        private final int propertyType;

        static Object convertDocViewPropertyToTypedValue(DocViewProperty property) {
            TypeHint hint = (TypeHint)((Object)TYPE_HINT_MAP.get(property.type));
            if (hint == null) {
                throw new IllegalArgumentException("Unknown type value '" + property.type + "'");
            }
            return hint.parseValues(property.values, property.isMulti);
        }

        private TypeHint(int propertyType) {
            this.propertyType = propertyType;
        }

        abstract Object parseValues(String[] var1, boolean var2);
    }
}

