/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt;

import java.util.HashMap;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.ide.impl.vlt.JcrCommand;
import org.apache.sling.ide.log.Logger;
import org.apache.sling.ide.transport.CommandExecutionProperties;
import org.apache.sling.ide.transport.Repository;
import org.apache.sling.ide.transport.ResourceProxy;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class ListTreeCommand
extends JcrCommand<ResourceProxy> {
    private final int levels;
    private final EventAdmin eventAdmin;

    public ListTreeCommand(Repository repository, Credentials credentials, String path, int levels, EventAdmin eventAdmin, Logger logger) {
        super(repository, credentials, path, logger, new Repository.CommandExecutionFlag[0]);
        this.levels = Math.max(1, levels);
        this.eventAdmin = eventAdmin;
    }

    @Override
    protected ResourceProxy execute0(Session session) throws RepositoryException {
        Node node = session.getNode(this.getPath());
        ResourceProxy parent = this.nodeToResource(node);
        this.addChildren(parent, node, this.levels - 1);
        return parent;
    }

    private void addChildren(ResourceProxy parent, Node node, int remainingLevels) throws RepositoryException {
        if (remainingLevels < 0) {
            throw new IllegalArgumentException("remainingLevels must be >=0, not: " + remainingLevels);
        }
        long start = System.currentTimeMillis();
        NodeIterator nodes = node.getNodes();
        long end = System.currentTimeMillis();
        this.log("ListTreeCommand.child -> " + node.getPath(), start, end);
        while (nodes.hasNext()) {
            Node childNode = nodes.nextNode();
            if (childNode.getPath().equals("/jcr:system")) continue;
            ResourceProxy childResourceProxy = this.nodeToResource(childNode);
            parent.addChild(childResourceProxy);
            if (remainingLevels <= 0) continue;
            this.addChildren(childResourceProxy, childNode, remainingLevels - 1);
        }
    }

    private void log(String text, long start, long end) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("result.txt", text);
        props.put("result.status", Boolean.TRUE);
        props.put("action.type", this.getClass().getSimpleName());
        props.put("action.target", this.getPath());
        props.put("timestamp.start", start);
        props.put("timestamp.end", end);
        Event event = new Event(CommandExecutionProperties.REPOSITORY_TOPIC, props);
        this.eventAdmin.postEvent(event);
    }
}

