/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.wizards.np;

import java.util.List;
import java.util.Properties;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.sling.ide.eclipse.core.progress.ProgressUtils;
import org.apache.sling.ide.eclipse.ui.wizards.AbstractNewSlingApplicationWizard;
import org.apache.sling.ide.eclipse.ui.wizards.Projects;
import org.apache.sling.ide.eclipse.ui.wizards.np.ArchetypeParametersWizardPage;
import org.apache.sling.ide.eclipse.ui.wizards.np.ChooseArchetypeWizardPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.wst.server.core.IServer;

public abstract class AbstractNewMavenBasedSlingApplicationWizard
extends AbstractNewSlingApplicationWizard {
    private ChooseArchetypeWizardPage chooseArchetypePage;
    private ArchetypeParametersWizardPage archetypeParametersPage;

    private static boolean isConfiguredWithBndPlugin(Model model) {
        for (Plugin buildPlugin : model.getBuild().getPlugins()) {
            if (!"biz.aQute.bnd".equals(buildPlugin.getGroupId()) || !"bnd-maven-plugin".equals(buildPlugin.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    public abstract boolean acceptsArchetype(Archetype var1);

    public AbstractNewMavenBasedSlingApplicationWizard() {
        this.setWindowTitle(this.doGetWindowTitle());
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.chooseArchetypePage = new ChooseArchetypeWizardPage(this);
        this.addPage((IWizardPage)this.chooseArchetypePage);
        this.archetypeParametersPage = this.createArchetypeParametersWizardPage();
        this.addPage((IWizardPage)this.archetypeParametersPage);
        this.addPage((IWizardPage)this.getSetupServerWizardPage());
    }

    protected ArchetypeParametersWizardPage createArchetypeParametersWizardPage() {
        return new ArchetypeParametersWizardPage(this);
    }

    public ChooseArchetypeWizardPage getChooseArchetypePage() {
        return this.chooseArchetypePage;
    }

    protected List<IProject> createProjects(IProgressMonitor monitor) throws CoreException {
        IPath location = this.chooseArchetypePage.getLocation();
        Archetype archetype = this.chooseArchetypePage.getSelectedArchetype();
        String groupId = this.archetypeParametersPage.getGroupId();
        String artifactId = this.archetypeParametersPage.getArtifactId();
        String version = this.archetypeParametersPage.getVersion();
        String javaPackage = this.archetypeParametersPage.getJavaPackage();
        Properties properties = this.archetypeParametersPage.getProperties();
        ProjectImportConfiguration configuration = new ProjectImportConfiguration();
        IProject existingProject = ResourcesPlugin.getWorkspace().getRoot().getProject(artifactId);
        if (existingProject != null && existingProject.exists()) {
            throw new IllegalStateException("A project with the name " + artifactId + " already exists.");
        }
        ProgressUtils.advance((IProgressMonitor)monitor, (int)1);
        List projects = MavenPlugin.getProjectConfigurationManager().createArchetypeProjects(location, archetype, groupId, artifactId, version, javaPackage, properties, configuration, (IProgressMonitor)new NullProgressMonitor());
        monitor.worked(3);
        return projects;
    }

    protected Projects configureCreatedProjects(List<IProject> createdProjects, IProgressMonitor monitor) throws CoreException {
        Projects projects = new Projects();
        for (IProject project : createdProjects) {
            IPath prevLocation;
            IFile pomFile = project.getFile("pom.xml");
            if (!pomFile.exists()) continue;
            Model model = MavenPlugin.getMavenModelManager().readMavenModel(pomFile);
            String packaging = model.getPackaging();
            if ("content-package".equals(packaging)) {
                projects.getContentProjects().add(project);
                continue;
            }
            if ("bundle".equals(packaging) || AbstractNewMavenBasedSlingApplicationWizard.isConfiguredWithBndPlugin(model)) {
                projects.getBundleProjects().add(project);
                continue;
            }
            if (!"pom".equals(packaging)) continue;
            if (projects.getReactorProject() == null) {
                projects.setReactorProject(project);
                continue;
            }
            IPath currLocation = project.getFullPath();
            if (!currLocation.isPrefixOf(prevLocation = projects.getReactorProject().getFullPath())) continue;
            projects.setReactorProject(project);
        }
        ProgressUtils.advance((IProgressMonitor)monitor, (int)1);
        for (IProject contentProject : projects.getContentProjects()) {
            this.configureContentProject(contentProject, createdProjects, monitor);
        }
        for (IProject bundleProject : projects.getBundleProjects()) {
            this.configureBundleProject(bundleProject, createdProjects, monitor);
        }
        if (projects.getReactorProject() != null) {
            this.configureReactorProject(projects.getReactorProject(), monitor);
            ProgressUtils.advance((IProgressMonitor)monitor, (int)1);
        }
        IServer server = this.getSetupServerWizardPage().getOrCreateServer(monitor);
        ProgressUtils.advance((IProgressMonitor)monitor, (int)1);
        this.finishConfiguration(createdProjects, server, monitor);
        ProgressUtils.advance((IProgressMonitor)monitor, (int)1);
        return projects;
    }
}

