/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.m2e.internal;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenProjectUtils {
    private static final String DEFAULT_SERVLET_API_VERSION = "2.5";
    private static final Pattern SERVLET_API_VERSION_MATCHER = Pattern.compile("^(\\d\\.\\d)");

    public static Resource guessJcrRootFolder(MavenProject project) {
        for (Resource resource : project.getBuild().getResources()) {
            if (!resource.getDirectory().endsWith("jcr_root")) continue;
            return resource;
        }
        return (Resource)project.getBuild().getResources().get(0);
    }

    public static String guessServletApiVersion(MavenProject project) {
        for (Dependency dependency : project.getDependencies()) {
            Matcher matcher;
            if (!"servlet-api".equals(dependency.getArtifactId()) && !"javax.servlet-api".equals(dependency.getArtifactId()) || !(matcher = SERVLET_API_VERSION_MATCHER.matcher(dependency.getVersion())).matches()) continue;
            return matcher.group(1);
        }
        return DEFAULT_SERVLET_API_VERSION;
    }

    public static Set<String> getModelDirectoryCandidateLocations(MavenProject mavenProject) {
        Xpp3Dom config;
        Xpp3Dom modelDir;
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add("src/main/provisioning");
        candidates.add("src/test/provisioning");
        Plugin slingstartPlugin = mavenProject.getPlugin("org.apache.sling:slingstart-maven-plugin");
        if (slingstartPlugin != null && slingstartPlugin.getConfiguration() instanceof Xpp3Dom && (modelDir = (config = (Xpp3Dom)slingstartPlugin.getConfiguration()).getChild("modelDirectory")) != null) {
            candidates.add(0, modelDir.getValue());
        }
        return new LinkedHashSet<String>(candidates);
    }

    private MavenProjectUtils() {
    }
}

