/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.apache.sling.ide.eclipse.ui.WhitelabelSupport;
import org.apache.sling.ide.eclipse.ui.internal.Activator;
import org.apache.sling.ide.eclipse.ui.internal.ImportRepositoryContentAction;
import org.apache.sling.ide.eclipse.ui.internal.ImportWizardPage;
import org.apache.sling.ide.serialization.SerializationException;
import org.apache.sling.ide.serialization.SerializationManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.server.core.IServer;

public class ImportWizard
extends Wizard
implements IImportWizard {
    private ImportWizardPage mainPage;
    private SerializationManager serializationManager;

    public ImportWizard() {
        Activator activator = Activator.getDefault();
        this.serializationManager = activator.getSerializationManager();
    }

    public boolean performFinish() {
        if (!this.mainPage.isPageComplete()) {
            return false;
        }
        final IServer server = this.mainPage.getServer();
        IResource resource = this.mainPage.getResource();
        final IProject project = resource.getProject();
        final IPath projectRelativePath = resource.getProjectRelativePath();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) throws CoreException {
                                try {
                                    try {
                                        new ImportRepositoryContentAction(server, projectRelativePath, project, ImportWizard.this.serializationManager).run(monitor);
                                    }
                                    catch (SerializationException e) {
                                        throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", "Import failed", (Throwable)e));
                                    }
                                    catch (InvocationTargetException e) {
                                        throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", "Import failed", e.getCause()));
                                    }
                                    catch (InterruptedException interruptedException) {
                                        Thread.currentThread().interrupt();
                                        ImportWizard.this.serializationManager.destroy();
                                    }
                                }
                                finally {
                                    ImportWizard.this.serializationManager.destroy();
                                }
                            }
                        }, (ISchedulingRule)project, 1, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            this.mainPage.setErrorMessage("Import error : " + cause.getMessage() + " . Please see the error log for details.");
            Activator.getDefault().getPluginLogger().error("Repository import failed", cause);
            return false;
        }
        catch (InterruptedException | OperationCanceledException throwable) {
            Thread.currentThread().interrupt();
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("Repositoy Import");
        this.setNeedsProgressMonitor(true);
        this.mainPage = new ImportWizardPage("Import from Repository", selection);
        this.setDefaultPageImageDescriptor(WhitelabelSupport.getWizardBanner());
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.mainPage);
    }
}

