/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.nav.model;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.XMLTokenizer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.sling.ide.eclipse.core.internal.Activator;
import org.apache.sling.ide.eclipse.ui.nav.model.DirNode;
import org.apache.sling.ide.eclipse.ui.nav.model.JcrNode;
import org.apache.sling.ide.eclipse.ui.nav.model.ModifiableProperties;
import org.apache.sling.ide.eclipse.ui.nav.model.SyncDirManager;
import org.apache.sling.ide.eclipse.ui.nav.model.TolerantXMLParser;
import org.apache.sling.ide.serialization.SerializationManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.xml.sax.SAXException;

public class GenericJcrRootFile
extends JcrNode {
    final IFile file;
    private final Document document;

    public GenericJcrRootFile(JcrNode parent, IFile file) throws ParserConfigurationException, SAXException, IOException, CoreException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        this.file = file;
        this.setResource((IResource)file);
        if (parent == null) {
            throw new IllegalArgumentException("parent must not be null");
        }
        this.parent = parent;
        this.domElement = null;
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream in = file.getContents();){
            this.document = TolerantXMLParser.parse(in, file.getFullPath().toOSString());
            this.handleJcrRoot(this.document.getRootElement());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof GenericJcrRootFile) {
            GenericJcrRootFile other = (GenericJcrRootFile)obj;
            return this.file.equals((Object)other.file);
        }
        return false;
    }

    private void handleJcrRoot(Element element) {
        JcrNode effectiveParent;
        List children = element.getChildren();
        if (this.isRootContentXml()) {
            if (this.parent instanceof DirNode) {
                DirNode dirNodeParent = (DirNode)this.parent;
                JcrNode effectiveSibling = dirNodeParent.getEffectiveSibling();
                if (effectiveSibling != null) {
                    effectiveSibling.dirSibling = dirNodeParent;
                    this.handleProperties(element, effectiveSibling.properties);
                } else {
                    this.handleProperties(element, this.parent.properties);
                }
                effectiveParent = this.parent;
            } else {
                this.handleProperties(element, this.parent.properties);
                effectiveParent = this.parent;
            }
        } else {
            this.handleProperties(element, this.properties);
            effectiveParent = this;
            this.parent.addChild(this);
        }
        for (Element aChild : children) {
            this.handleChild(effectiveParent, aChild);
        }
    }

    private boolean isRootContentXml() {
        return this.file.getName().equals(".content.xml");
    }

    private void handleProperties(Element domNode, ModifiableProperties properties) {
        properties.setNode(this, domNode);
    }

    @Override
    public String getLabel() {
        int first;
        if (this.isRootContentXml()) {
            return "SHOULD NOT OCCUR";
        }
        String label = this.file.getName();
        if (label.endsWith(".xml")) {
            label = label.substring(0, label.length() - 4);
        }
        if (label.startsWith("_") && (first = (label = label.substring(1)).indexOf("_")) != -1) {
            label = String.valueOf(label.substring(0, first)) + ":" + label.substring(first + 1);
        }
        return label;
    }

    private void handleChild(JcrNode parent, Element domNode) {
        if (domNode.getType() == XMLTokenizer.Type.TEXT) {
            return;
        }
        JcrNode childJcrNode = new JcrNode(parent, domNode, this, null);
        this.handleProperties(domNode, childJcrNode.properties);
        for (Element element : domNode.getChildren()) {
            this.handleChild(childJcrNode, element);
        }
    }

    public void pickResources(List<IResource> membersList) {
        SerializationManager serializationManager = Activator.getDefault().getSerializationManager();
        Iterator<IResource> it = membersList.iterator();
        block0: while (it.hasNext()) {
            IResource resource = it.next();
            String resName = resource.getName();
            Iterator<Object> it2 = this.isRootContentXml() ? this.parent.children.iterator() : this.children.iterator();
            while (it2.hasNext()) {
                JcrNode aChild = (JcrNode)it2.next();
                if (!resName.equals(serializationManager.getOsPath(aChild.getName()))) continue;
                it.remove();
                aChild.setResource(resource);
                continue block0;
            }
        }
    }

    @Override
    public IFile getFileForEditor() {
        return this.file;
    }

    @Override
    void createDomChild(String childNodeName, String childNodeType) {
        this.createChild(childNodeName, childNodeType, this.document.getRootElement(), this.underlying);
    }

    public void save() {
        try {
            String xml = this.document.toXML();
            this.file.setContents((InputStream)new ByteArrayInputStream(xml.getBytes()), true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        SyncDirManager.syncDirChanged(this.getSyncDir());
    }

    @Override
    public boolean canBeRenamed() {
        return true;
    }

    @Override
    public boolean canBeDeleted() {
        return true;
    }

    @Override
    public void rename(String string) {
        try {
            this.file.move(this.file.getParent().getFullPath().append(String.valueOf(string) + ".xml"), true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.getDefault().getPluginLogger().error("Error renaming resource (" + this.file + "): " + (Object)((Object)e), (Throwable)e);
        }
    }

    @Override
    public void delete() {
        try {
            this.file.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.getDefault().getPluginLogger().error("Error deleting resource (" + this.file + "): " + (Object)((Object)e), (Throwable)e);
        }
    }
}

