/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.internal;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.sling.ide.eclipse.ui.internal.SharedImages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.IServerModule;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;

public class ServersActionModeFiddlerActionDelegate
implements IViewActionDelegate {
    private IActionBars actionBars;
    private IViewPart view;
    private IPropertyChangeListener runTooltipListener;
    private IPropertyChangeListener debugTooltipListener;
    private IPropertyChangeListener disconnectTooltipListener;
    private List<ActionContributionItem> prependedToolbarActions = new LinkedList<ActionContributionItem>();
    private List<ActionContributionItem> appendedToolbarActionContributionItems = new LinkedList<ActionContributionItem>();
    private IServer server;
    private List<IModule[]> modules;
    private Action cleanAction;
    private Action publishAction;
    private ActionContributionItem wstPublishAction;
    private ActionContributionItem cleanActionContributionItem;
    private ActionContributionItem publishActionContributionItem;
    protected boolean doNotAskAgain = false;

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.server = null;
        this.modules = null;
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection iss = (IStructuredSelection)selection;
            Object first = iss.getFirstElement();
            if (first instanceof IServer) {
                this.server = (IServer)first;
                this.modules = null;
                if (iss.size() > 1) {
                    Iterator it = iss.iterator();
                    it.next();
                    while (it.hasNext()) {
                        Object next = it.next();
                        if (next instanceof IServer) continue;
                        this.server = null;
                        this.modules = null;
                        break;
                    }
                }
            } else if (first instanceof IServerModule) {
                this.modules = new LinkedList<IModule[]>();
                IServerModule module = (IServerModule)first;
                this.modules.add(module.getModule());
                this.server = module.getServer();
                if (iss.size() > 1) {
                    Iterator it = iss.iterator();
                    it.next();
                    while (it.hasNext()) {
                        Object next = it.next();
                        if (!(next instanceof IServerModule)) {
                            this.server = null;
                            module = null;
                            break;
                        }
                        module = (IServerModule)next;
                        this.modules.add(module.getModule());
                    }
                }
            }
        }
        if (this.server != null && this.server.getServerState() != 2) {
            this.server = null;
            this.modules = null;
        }
        this.cleanAction.setEnabled(this.server != null);
        this.publishAction.setEnabled(this.server != null);
        action.setEnabled(true);
        final IAction serverRunAction = this.actionBars.getGlobalActionHandler("org.eclipse.wst.server.run");
        final IAction serverDebugAction = this.actionBars.getGlobalActionHandler("org.eclipse.wst.server.debug");
        IAction stopRunAction = this.actionBars.getGlobalActionHandler("org.eclipse.wst.server.stop");
        if (serverRunAction == null || stopRunAction == null || serverDebugAction == null) {
            return;
        }
        serverRunAction.setHoverImageDescriptor(SharedImages.RUN_CONNECT);
        serverDebugAction.setHoverImageDescriptor(SharedImages.DEBUG_CONNECT);
        stopRunAction.setHoverImageDescriptor(SharedImages.DISCONNECT);
        this.findWstPublishAction();
        for (ActionContributionItem appendedAction : this.appendedToolbarActionContributionItems) {
            if (this.contributionAdded(appendedAction)) continue;
            this.actionBars.getToolBarManager().add((IContributionItem)appendedAction);
        }
        if (this.wstPublishAction != null) {
            this.wstPublishAction.setVisible(false);
            this.publishActionContributionItem.setVisible(true);
        } else {
            this.publishActionContributionItem.setVisible(false);
        }
        if (this.runTooltipListener == null) {
            this.runTooltipListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("toolTipText") && !event.getNewValue().equals("Connect to server in run mode")) {
                        serverRunAction.setToolTipText("Connect to server in run mode");
                    }
                }
            };
            serverRunAction.addPropertyChangeListener(this.runTooltipListener);
        }
        if (this.debugTooltipListener == null) {
            this.debugTooltipListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("toolTipText") && !event.getNewValue().equals("Connect to server in debug mode")) {
                        serverDebugAction.setToolTipText("Connect to server in debug mode");
                    }
                }
            };
            serverDebugAction.addPropertyChangeListener(this.debugTooltipListener);
        }
        if (this.disconnectTooltipListener == null) {
            this.disconnectTooltipListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("toolTipText") && !event.getNewValue().equals("Disconnect from server")) {
                        serverRunAction.setToolTipText("Disconnect from server");
                    }
                }
            };
            stopRunAction.addPropertyChangeListener(this.disconnectTooltipListener);
        }
        serverRunAction.setToolTipText("Connect to server in run mode");
        serverDebugAction.setToolTipText("Connect to server in debug mode");
        stopRunAction.setToolTipText("Disconnect from server");
    }

    private void findWstPublishAction() {
        IContributionItem[] items;
        if (this.wstPublishAction != null) {
            return;
        }
        IContributionItem[] iContributionItemArray = items = this.actionBars.getToolBarManager().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ActionContributionItem actionItem;
            IAction a;
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem && "org.eclipse.wst.server.publish".equals((a = (actionItem = (ActionContributionItem)item).getAction()).getActionDefinitionId())) {
                this.wstPublishAction = actionItem;
            }
            ++n2;
        }
    }

    private boolean contributionAdded(ActionContributionItem action) {
        IContributionItem[] items;
        IContributionItem[] iContributionItemArray = items = this.actionBars.getToolBarManager().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem iContributionItem = iContributionItemArray[n2];
            if (iContributionItem == action) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void init(IViewPart view) {
        this.view = view;
        this.actionBars = view.getViewSite().getActionBars();
        this.initToolbarContributedActions();
        for (ActionContributionItem actionContributionItem : this.prependedToolbarActions) {
            IAction action = (IAction)actionContributionItem;
            ActionContributionItem contribution = new ActionContributionItem(action);
            this.actionBars.getToolBarManager().add((IContributionItem)contribution);
        }
    }

    private void initToolbarContributedActions() {
        this.cleanAction = new Action("Clean Publish...", 1){

            public void run() {
                if (ServersActionModeFiddlerActionDelegate.this.server == null) {
                    MessageDialog.openInformation((Shell)ServersActionModeFiddlerActionDelegate.this.view.getSite().getShell(), (String)"No server selected", (String)"A server must be selected");
                    return;
                }
                int selection = 2;
                if (!ServersActionModeFiddlerActionDelegate.this.doNotAskAgain) {
                    MessageDialog dialog = new MessageDialog(ServersActionModeFiddlerActionDelegate.this.view.getSite().getShell(), Messages.defaultDialogTitle, null, Messages.dialogPublishClean, 6, new String[]{"Cancel", "OK (do not ask again)", "OK"}, 1){

                        protected void configureShell(Shell shell) {
                            super.configureShell(shell);
                            this.setShellStyle(this.getShellStyle() | 0x10000000);
                        }
                    };
                    selection = dialog.open();
                }
                if (selection != 0) {
                    if (selection == 1) {
                        ServersActionModeFiddlerActionDelegate.this.doNotAskAgain = true;
                    }
                    IAdaptable info = new IAdaptable(){

                        public Object getAdapter(Class adapter) {
                            if (Shell.class.equals((Object)adapter)) {
                                return ServersActionModeFiddlerActionDelegate.this.view.getSite().getShell();
                            }
                            if (String.class.equals((Object)adapter)) {
                                return "user";
                            }
                            return null;
                        }
                    };
                    ServersActionModeFiddlerActionDelegate.this.server.publish(4, ServersActionModeFiddlerActionDelegate.this.modules, info, null);
                }
            }
        };
        this.cleanAction.setText("Clean Publish...");
        this.cleanAction.setToolTipText("Clean and Publish...");
        DecorationOverlayIcon cleanAndPublishImageDesc = new DecorationOverlayIcon(ImageResource.getImageDescriptor((String)"IMG_CLCL_PUBLISH").createImage(), ImageDescriptor.createFromFile(SharedImages.class, (String)"refresh.gif"), 3);
        this.cleanAction.setImageDescriptor((ImageDescriptor)cleanAndPublishImageDesc);
        this.cleanAction.setId("org.apache.sling.ide.eclipse.ui.actions.CleanPublishAction");
        this.publishAction = new Action("Publish", 1){

            public void run() {
                if (ServersActionModeFiddlerActionDelegate.this.server == null) {
                    MessageDialog.openInformation((Shell)ServersActionModeFiddlerActionDelegate.this.view.getSite().getShell(), (String)"No server selected", (String)"A server must be selected");
                    return;
                }
                IAdaptable info = new IAdaptable(){

                    public Object getAdapter(Class adapter) {
                        if (Shell.class.equals((Object)adapter)) {
                            return ServersActionModeFiddlerActionDelegate.this.view.getSite().getShell();
                        }
                        if (String.class.equals((Object)adapter)) {
                            return "user";
                        }
                        return null;
                    }
                };
                ServersActionModeFiddlerActionDelegate.this.server.publish(1, ServersActionModeFiddlerActionDelegate.this.modules, info, null);
            }
        };
        this.publishAction.setText("Publish");
        this.publishAction.setToolTipText("Publish");
        this.publishAction.setImageDescriptor(ImageResource.getImageDescriptor((String)"IMG_CLCL_PUBLISH"));
        this.publishAction.setId("org.apache.sling.ide.eclipse.ui.actions.PublishAction");
        this.cleanAction.setEnabled(false);
        this.publishAction.setEnabled(false);
        this.cleanActionContributionItem = new ActionContributionItem((IAction)this.cleanAction);
        this.publishActionContributionItem = new ActionContributionItem((IAction)this.publishAction);
        this.appendedToolbarActionContributionItems.add(this.publishActionContributionItem);
        this.appendedToolbarActionContributionItems.add(this.cleanActionContributionItem);
    }
}

