/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hapi.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.hapi.HApiProperty;
import org.apache.sling.hapi.HApiType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HApiTypeImpl
implements HApiType {
    public static final Logger LOG = LoggerFactory.getLogger(HApiTypeImpl.class);
    private HApiType parent;
    private String name;
    private String description;
    private final String serverUrl;
    private String path;
    private String fqdn;
    private List<String> parameters;
    private Map<String, HApiProperty> properties;
    private boolean isAbstract;

    public HApiTypeImpl(String name, String description, String serverUrl, String path, String fqdn, List<String> parameters, Map<String, HApiProperty> properties, HApiType parent, boolean isAbstract) {
        this.name = name;
        this.description = description;
        this.serverUrl = serverUrl.substring(0, serverUrl.length() - (serverUrl.endsWith("/") ? 1 : 0));
        this.path = path;
        this.fqdn = fqdn;
        this.parameters = parameters;
        this.properties = properties;
        this.parent = parent;
        this.isAbstract = isAbstract;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getUrl() {
        return this.serverUrl + this.getPath() + ".html";
    }

    @Override
    public String getFqdn() {
        return this.fqdn;
    }

    @Override
    public List<String> getParameters() {
        return this.parameters;
    }

    @Override
    public Map<String, HApiProperty> getProperties() {
        return this.properties;
    }

    @Override
    public Map<String, HApiProperty> getAllProperties() {
        HashMap<String, HApiProperty> allProps = new HashMap<String, HApiProperty>();
        LOG.debug("parent: {}", (Object)this.parent);
        if (null != this.parent) {
            Map<String, HApiProperty> parentProps = this.parent.getAllProperties();
            LOG.debug("parent props: {}", parentProps);
            allProps.putAll(parentProps);
        }
        allProps.putAll(this.getProperties());
        return allProps;
    }

    @Override
    public HApiType getParent() {
        return this.parent;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setParent(HApiType parent) {
        this.parent = parent;
    }

    public void setProperties(Map<String, HApiProperty> properties) {
        this.properties = properties;
    }

    public String toString() {
        return this.getName() + "(" + this.getPath() + "): Properties: " + this.getProperties();
    }
}

