/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.engine;

import graphql.com.google.common.collect.ImmutableList;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.SelectedField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SelectedFieldWrapper
implements org.apache.sling.graphql.api.SelectedField {
    private String name;
    @Deprecated
    private boolean isInline;
    private boolean conditional;
    private List<String> objectTypeNames;
    private Map<String, org.apache.sling.graphql.api.SelectedField> subFieldMap = new HashMap<String, org.apache.sling.graphql.api.SelectedField>();
    private List<org.apache.sling.graphql.api.SelectedField> subFields;

    public SelectedFieldWrapper(SelectedField selectedField) {
        this.name = selectedField.getName();
        this.objectTypeNames = selectedField.getObjectTypeNames() == null ? Collections.emptyList() : new ArrayList(selectedField.getObjectTypeNames());
        this.conditional = selectedField.isConditional();
        DataFetchingFieldSelectionSet selectionSet = selectedField.getSelectionSet();
        if (selectionSet != null) {
            selectionSet.getImmediateFields().forEach(sf -> {
                SelectedFieldWrapper selectedChildField = (SelectedFieldWrapper)this.subFieldMap.get(sf.getName());
                if (selectedChildField == null) {
                    selectedChildField = new SelectedFieldWrapper((SelectedField)sf);
                    this.subFieldMap.put(selectedChildField.getName(), selectedChildField);
                } else {
                    for (String objectTypeName : sf.getObjectTypeNames()) {
                        if (selectedChildField.objectTypeNames.contains(objectTypeName)) continue;
                        selectedChildField.objectTypeNames.add(objectTypeName);
                    }
                }
            });
        }
        this.subFields = this.subFieldMap.values().stream().collect(Collectors.toList());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<org.apache.sling.graphql.api.SelectedField> getSubSelectedFields() {
        return this.subFields;
    }

    @Override
    public org.apache.sling.graphql.api.SelectedField getSubSelectedField(String name) {
        return this.subFieldMap.get(name);
    }

    @Override
    public boolean hasSubSelectedFields(String ... name) {
        return Arrays.stream(name).anyMatch(this.subFieldMap::containsKey);
    }

    @Override
    public boolean isInline() {
        return this.isInline;
    }

    @Override
    public List<String> getObjectTypeNames() {
        return ImmutableList.copyOf(this.objectTypeNames);
    }
}

