/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.servlet;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import javax.servlet.Servlet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.metrics.Counter;
import org.apache.sling.commons.metrics.MetricsService;
import org.apache.sling.commons.metrics.Timer;
import org.apache.sling.graphql.api.cache.GraphQLCacheProvider;
import org.apache.sling.graphql.api.engine.QueryExecutor;
import org.apache.sling.graphql.api.engine.ValidationResult;
import org.apache.sling.graphql.core.servlet.QueryParser;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, name="org.apache.sling.graphql.core.GraphQLServlet", immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.description=Sling GraphQL Servlet", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=Config.class, factory=true)
public class GraphQLServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphQLServlet.class);
    public static final String P_QUERY = "query";
    @Reference
    private QueryExecutor queryExecutor;
    @Reference
    private GraphQLCacheProvider cacheProvider;
    @Reference
    private MetricsService metricsService;
    @Reference(target="(name=sling)")
    private MetricRegistry metricRegistry;
    private String suffixPersisted;
    private Pattern patternGetPersistedQuery;
    private int cacheControlMaxAge;
    private Counter cacheHits;
    private Counter cacheMisses;
    private Counter requestsServed;
    private Timer requestTimer;
    private static final String METRIC_NS = GraphQLServlet.class.getName();
    private String gaugeCacheHitRate;

    @Activate
    private void activate(Config config) {
        Object[] extensions = config.sling_servlet_extensions();
        StringBuilder extensionsPattern = new StringBuilder();
        for (String string : extensions) {
            if (extensionsPattern.length() > 0) {
                extensionsPattern.append("|");
            }
            extensionsPattern.append(string);
        }
        if (extensionsPattern.length() > 0) {
            extensionsPattern.insert(0, "(");
            extensionsPattern.append(")");
        }
        this.cacheControlMaxAge = config.cache$_$control_max$_$age() >= 0 ? config.cache$_$control_max$_$age() : 0;
        String suffix = config.persistedQueries_suffix();
        if (StringUtils.isNotEmpty((CharSequence)suffix) && suffix.startsWith("/")) {
            this.suffixPersisted = suffix;
            this.patternGetPersistedQuery = Pattern.compile("^" + this.suffixPersisted + "/([a-f0-9]{64})" + (extensionsPattern.length() > 0 ? "\\." + extensionsPattern.toString() + "$" : "$"));
        } else {
            this.suffixPersisted = null;
            this.patternGetPersistedQuery = null;
        }
        StringBuilder sb = new StringBuilder();
        Object[] resourceTypes = config.sling_servlet_resourceTypes();
        Arrays.sort(resourceTypes);
        sb.append("rt:").append(String.join((CharSequence)"_", (CharSequence[])resourceTypes));
        if (config.sling_servlet_methods().length > 0) {
            Object[] objectArray = config.sling_servlet_methods();
            Arrays.sort(objectArray);
            sb.append(".m:").append(String.join((CharSequence)"_", (CharSequence[])objectArray));
        }
        if (config.sling_servlet_selectors().length > 0) {
            Object[] objectArray = config.sling_servlet_selectors();
            Arrays.sort(objectArray);
            sb.append(".s:").append(String.join((CharSequence)"_", (CharSequence[])objectArray));
        }
        if (extensions.length > 0) {
            Arrays.sort(extensions);
            sb.append(".e:").append(String.join((CharSequence)"_", (CharSequence[])extensions));
        }
        String string = sb.toString();
        this.cacheHits = this.metricsService.counter(METRIC_NS + "." + string + ".cache_hits");
        this.cacheMisses = this.metricsService.counter(METRIC_NS + "." + string + ".cache_misses");
        this.requestsServed = this.metricsService.counter(METRIC_NS + "." + string + ".requests_total");
        this.gaugeCacheHitRate = METRIC_NS + "." + string + ".cache_hit_rate";
        this.metricRegistry.register(this.gaugeCacheHitRate, (Metric)((Gauge)() -> Float.valueOf((float)this.cacheHits.getCount() / (float)(this.cacheHits.getCount() + this.cacheMisses.getCount()))));
        this.requestTimer = this.metricsService.timer(METRIC_NS + "." + string + ".requests_timer");
    }

    @Deactivate
    private void deactivate() {
        if (StringUtils.isNotEmpty((CharSequence)this.gaugeCacheHitRate)) {
            this.metricRegistry.remove(this.gaugeCacheHitRate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        this.requestsServed.increment();
        Timer.Context requestTimerContext = this.requestTimer.time();
        try {
            String suffix = request.getRequestPathInfo().getSuffix();
            if (suffix != null) {
                if (StringUtils.isNotEmpty((CharSequence)this.suffixPersisted) && suffix.startsWith(this.suffixPersisted)) {
                    Matcher matcher = this.patternGetPersistedQuery.matcher(suffix);
                    if (matcher.matches()) {
                        String queryHash = matcher.group(1);
                        String extension = matcher.group(2);
                        String requestExtension = request.getRequestPathInfo().getExtension();
                        if (requestExtension != null && requestExtension.equals(extension)) {
                            if (StringUtils.isNotEmpty((CharSequence)queryHash)) {
                                String query = this.cacheProvider.getQuery(queryHash, request.getResource().getResourceType(), request.getRequestPathInfo().getSelectorString());
                                if (query != null) {
                                    boolean isAuthenticated = request.getHeaders("Authorization").hasMoreElements();
                                    StringBuilder cacheControlValue = new StringBuilder("max-age=").append(this.cacheControlMaxAge);
                                    if (isAuthenticated) {
                                        cacheControlValue.append(",private");
                                    }
                                    response.addHeader("Cache-Control", cacheControlValue.toString());
                                    this.execute(query, request, response);
                                    this.cacheHits.increment();
                                } else {
                                    this.cacheMisses.increment();
                                    response.sendError(404, "Cannot find persisted query " + queryHash);
                                }
                            }
                        } else {
                            response.sendError(400, "The persisted query's extension does not match the servlet extension.");
                        }
                    } else {
                        response.sendError(400, "Unexpected hash.");
                    }
                } else {
                    response.sendError(400, "Persisted queries are disabled.");
                }
            } else {
                this.execute(request.getResource(), request, response);
            }
        }
        finally {
            requestTimerContext.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        this.requestsServed.increment();
        Timer.Context requestTimerContext = this.requestTimer.time();
        try {
            String suffix = request.getRequestPathInfo().getSuffix();
            if (suffix != null) {
                if (StringUtils.isNotEmpty((CharSequence)this.suffixPersisted) && suffix.equals(this.suffixPersisted)) {
                    this.doPostPersistedQuery(request, response);
                } else {
                    response.sendError(400);
                }
            } else {
                this.execute(request.getResource(), request, response);
            }
        }
        finally {
            requestTimerContext.stop();
        }
    }

    private void doPostPersistedQuery(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        String rawQuery = IOUtils.toString((Reader)request.getReader());
        QueryParser.Result query = QueryParser.fromJSON(rawQuery);
        ValidationResult validationResult = this.queryExecutor.validate(query.getQuery(), query.getVariables(), request.getResource(), request.getRequestPathInfo().getSelectors());
        if (validationResult.isValid()) {
            String hash = this.cacheProvider.cacheQuery(rawQuery, request.getResource().getResourceType(), request.getRequestPathInfo().getSelectorString());
            if (hash != null) {
                response.addHeader("Location", this.getLocationHeaderValue(request, hash));
                response.setStatus(201);
            } else {
                response.sendError(500, "Cannot store persisted query.");
            }
        } else {
            LOGGER.error("Invalid GraphQL query: " + String.join((CharSequence)System.lineSeparator(), validationResult.getErrors()));
            response.sendError(400, "Invalid GraphQL query.");
        }
    }

    private void execute(Resource resource, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        QueryParser.Result result = QueryParser.fromRequest(request);
        if (result == null) {
            response.sendError(400);
            return;
        }
        String query = result.getQuery();
        if (query.trim().length() == 0) {
            response.sendError(400, "Missing request parameter:query");
            return;
        }
        try (JsonWriter writer = Json.createWriter((Writer)response.getWriter());){
            Map<String, Object> executionResult = this.queryExecutor.execute(query, result.getVariables(), resource, request.getRequestPathInfo().getSelectors());
            writer.write((JsonStructure)Json.createObjectBuilder(executionResult).build().asJsonObject());
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private void execute(@NotNull String persistedQuery, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        try (JsonWriter writer = Json.createWriter((Writer)response.getWriter());){
            QueryParser.Result result = QueryParser.fromJSON(persistedQuery);
            Map<String, Object> executionResult = this.queryExecutor.execute(result.getQuery(), result.getVariables(), request.getResource(), request.getRequestPathInfo().getSelectors());
            writer.write((JsonStructure)Json.createObjectBuilder(executionResult).build().asJsonObject());
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    @NotNull
    private String getLocationHeaderValue(@NotNull SlingHttpServletRequest request, @NotNull String hash) {
        StringBuilder location = new StringBuilder();
        location.append(request.getScheme()).append("://");
        location.append(request.getServerName());
        int localPort = request.getServerPort();
        if (localPort != 80 && localPort != 443) {
            location.append(":").append(localPort);
        }
        String extension = request.getRequestPathInfo().getExtension();
        location.append(request.getContextPath()).append(request.getPathInfo()).append("/").append(hash).append(StringUtils.isNotEmpty((CharSequence)extension) ? "." + extension : "");
        return location.toString();
    }

    @ObjectClassDefinition(name="Apache Sling GraphQL Servlet", description="Servlet that implements GraphQL endpoints")
    public static @interface Config {
        @AttributeDefinition(name="Selectors", description="Standard Sling servlet property")
        public String[] sling_servlet_selectors() default {""};

        @AttributeDefinition(name="Resource Types", description="Standard Sling servlet property")
        public String[] sling_servlet_resourceTypes() default {"sling/servlet/default"};

        @AttributeDefinition(name="Methods", description="Standard Sling servlet property")
        public String[] sling_servlet_methods() default {"GET"};

        @AttributeDefinition(name="Extensions", description="Standard Sling servlet property")
        public String[] sling_servlet_extensions() default {"gql"};

        @AttributeDefinition(name="Persisted queries suffix", description="The request suffix under which the HTTP API for persisted queries should be made available.")
        public String persistedQueries_suffix() default "/persisted";

        @AttributeDefinition(name="Persisted Queries Cache-Control max-age", description="The maximum amount of time a persisted query resource is considered fresh (in seconds). A negative value will be interpreted as 0.", min="0", type=AttributeType.INTEGER)
        public int cache$_$control_max$_$age() default 60;
    }
}

